/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.metadatamapping.contributor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.importer.external.metadatamapping.MetadataFieldConfig;
import org.dspace.importer.external.metadatamapping.MetadataFieldMapping;
import org.dspace.importer.external.metadatamapping.MetadatumDTO;
import org.dspace.importer.external.metadatamapping.contributor.JsonPathMetadataProcessor;
import org.dspace.importer.external.metadatamapping.contributor.MetadataContributor;

public class SimpleJsonPathMetadataContributor
implements MetadataContributor<String> {
    private static final Logger log = LogManager.getLogger();
    private String query;
    private MetadataFieldConfig field;
    protected JsonPathMetadataProcessor metadataProcessor;

    public SimpleJsonPathMetadataContributor(String query, MetadataFieldConfig field) {
        this.query = query;
        this.field = field;
    }

    @Override
    public void setMetadataFieldMapping(MetadataFieldMapping<String, MetadataContributor<String>> rt) {
    }

    public SimpleJsonPathMetadataContributor() {
    }

    public MetadataFieldConfig getField() {
        return this.field;
    }

    public void setField(MetadataFieldConfig field) {
        this.field = field;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setMetadataProcessor(JsonPathMetadataProcessor metadataProcessor) {
        this.metadataProcessor = metadataProcessor;
    }

    @Override
    public Collection<MetadatumDTO> contributeMetadata(String fullJson) {
        ArrayList<MetadatumDTO> metadata = new ArrayList<MetadatumDTO>();
        Collection<Object> metadataValue = new ArrayList();
        if (Objects.nonNull(this.metadataProcessor)) {
            metadataValue = this.metadataProcessor.processMetadata(fullJson);
        } else {
            String nodeValue;
            JsonNode jsonNode = this.convertStringJsonToJsonNode(fullJson);
            JsonNode jsonNode2 = jsonNode.at(this.query);
            if (jsonNode2.isArray()) {
                Iterator nodes = jsonNode2.iterator();
                while (nodes.hasNext()) {
                    String nodeValue2 = this.getStringValue((JsonNode)nodes.next());
                    if (!StringUtils.isNotBlank((CharSequence)nodeValue2)) continue;
                    metadataValue.add(nodeValue2);
                }
            } else if (!jsonNode2.isNull() && StringUtils.isNotBlank((CharSequence)jsonNode2.toString()) && StringUtils.isNotBlank((CharSequence)(nodeValue = this.getStringValue(jsonNode2)))) {
                metadataValue.add(nodeValue);
            }
        }
        for (String string : metadataValue) {
            MetadatumDTO metadatumDto = new MetadatumDTO();
            metadatumDto.setValue(string);
            metadatumDto.setElement(this.field.getElement());
            metadatumDto.setQualifier(this.field.getQualifier());
            metadatumDto.setSchema(this.field.getSchema());
            metadata.add(metadatumDto);
        }
        return metadata;
    }

    private String getStringValue(JsonNode node) {
        if (node.isTextual()) {
            return node.textValue();
        }
        if (node.isNumber()) {
            return node.numberValue().toString();
        }
        log.error("It wasn't possible to convert the value of the following JsonNode:" + node.asText());
        return "";
    }

    private JsonNode convertStringJsonToJsonNode(String json) {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode body = null;
        try {
            body = mapper.readTree(json);
        }
        catch (JsonProcessingException e) {
            log.error("Unable to process json response.", (Throwable)e);
        }
        return body;
    }
}

