/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.metadatamapping.contributor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import org.dspace.importer.external.metadatamapping.MetadatumDTO;
import org.dspace.importer.external.metadatamapping.contributor.SimpleJsonPathMetadataContributor;

public class RorParentOrgUnitMetadataContributor
extends SimpleJsonPathMetadataContributor {
    private String typeField;
    private String parentType;
    private String labelField;

    @Override
    public Collection<MetadatumDTO> contributeMetadata(String fullJson) {
        ArrayList<MetadatumDTO> metadata = new ArrayList<MetadatumDTO>();
        ArrayList<String> metadataValue = new ArrayList<String>();
        JsonNode jsonNode = this.convertStringJsonToJsonNode(fullJson);
        JsonNode array = jsonNode.at(this.getQuery());
        if (!array.isArray()) {
            return metadata;
        }
        for (JsonNode node : array) {
            if (!node.has(this.labelField)) continue;
            String type = node.has(this.typeField) ? node.get(this.typeField).asText() : null;
            String label = node.get(this.labelField).asText();
            if (!this.parentType.equalsIgnoreCase(type)) continue;
            metadataValue.add(label);
        }
        for (String value : metadataValue) {
            MetadatumDTO metadatumDto = new MetadatumDTO();
            metadatumDto.setValue(value);
            metadatumDto.setElement(this.getField().getElement());
            metadatumDto.setQualifier(this.getField().getQualifier());
            metadatumDto.setSchema(this.getField().getSchema());
            metadata.add(metadatumDto);
        }
        return metadata;
    }

    private JsonNode convertStringJsonToJsonNode(String json) {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode body = null;
        try {
            body = mapper.readTree(json);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return body;
    }

    public String getTypeField() {
        return this.typeField;
    }

    public void setTypeField(String typeField) {
        this.typeField = typeField;
    }

    public String getLabelField() {
        return this.labelField;
    }

    public void setLabelField(String labelField) {
        this.labelField = labelField;
    }

    public String getParentType() {
        return this.parentType;
    }

    public void setParentType(String parentType) {
        this.parentType = parentType;
    }
}

