/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.metadatamapping.contributor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Logger;
import org.dspace.importer.external.metadatamapping.contributor.JsonPathMetadataProcessor;

public abstract class AbstractJsonPathMetadataProcessor
implements JsonPathMetadataProcessor {
    @Override
    public Collection<String> processMetadata(String json) {
        String nodeValue;
        ArrayList<String> values = new ArrayList<String>();
        JsonNode jsonNode = this.convertStringJsonToJsonNode(json);
        JsonNode node = jsonNode.at(this.getPath());
        if (node.isArray()) {
            for (JsonNode value : node) {
                String nodeValue2 = this.getStringValue(value);
                if (!StringUtils.isNotBlank((CharSequence)nodeValue2)) continue;
                values.add(nodeValue2);
            }
        } else if (!node.isNull() && StringUtils.isNotBlank((CharSequence)node.toString()) && StringUtils.isNotBlank((CharSequence)(nodeValue = this.getStringValue(node)))) {
            values.add(nodeValue);
        }
        return values;
    }

    protected abstract String getStringValue(JsonNode var1);

    protected abstract Logger getLogger();

    protected abstract String getPath();

    private JsonNode convertStringJsonToJsonNode(String json) {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode body = null;
        try {
            body = mapper.readTree(json);
        }
        catch (JsonProcessingException e) {
            this.getLogger().error("Unable to process json response.", (Throwable)e);
        }
        return body;
    }
}

