/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.epo.service;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.invoke.CallSite;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpException;
import org.apache.http.client.utils.URIBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xerces.impl.dv.util.Base64;
import org.dspace.content.Item;
import org.dspace.importer.external.datamodel.ImportRecord;
import org.dspace.importer.external.datamodel.Query;
import org.dspace.importer.external.exception.MetadataSourceException;
import org.dspace.importer.external.liveimportclient.service.LiveImportClient;
import org.dspace.importer.external.metadatamapping.MetadataFieldConfig;
import org.dspace.importer.external.metadatamapping.contributor.EpoIdMetadataContributor;
import org.dspace.importer.external.service.AbstractImportMetadataSourceService;
import org.dspace.importer.external.service.components.QuerySource;
import org.jaxen.JaxenException;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.Text;
import org.jdom2.filter.Filters;
import org.jdom2.input.SAXBuilder;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class EpoImportMetadataSourceServiceImpl
extends AbstractImportMetadataSourceService<Element>
implements QuerySource {
    private static final Logger log = LogManager.getLogger();
    private String url;
    private String authUrl;
    private String searchUrl;
    private String consumerKey;
    private String consumerSecret;
    private MetadataFieldConfig dateFiled;
    private MetadataFieldConfig applicationNumber;
    public static final String APP_NO_DATE_SEPARATOR = "$$$";
    private static final String APP_NO_DATE_SEPARATOR_REGEX = "\\$\\$\\$";
    @Autowired
    private LiveImportClient liveImportClient;

    @Override
    public void init() throws Exception {
    }

    @Override
    public String getImportSource() {
        return "epo";
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public void setDateFiled(MetadataFieldConfig dateFiled) {
        this.dateFiled = dateFiled;
    }

    public MetadataFieldConfig getDateFiled() {
        return this.dateFiled;
    }

    public void setApplicationNumber(MetadataFieldConfig applicationNumber) {
        this.applicationNumber = applicationNumber;
    }

    public MetadataFieldConfig getApplicationNumber() {
        return this.applicationNumber;
    }

    protected String login() throws IOException, HttpException {
        Map<String, Map<String, String>> params = this.getLoginParams();
        String entity = "grant_type=client_credentials";
        String json = this.liveImportClient.executeHttpPostRequest(this.authUrl, params, entity);
        ObjectMapper mapper = new ObjectMapper(new JsonFactory());
        JsonNode rootNode = mapper.readTree(json);
        JsonNode accessTokenNode = rootNode.get("access_token");
        return accessTokenNode.asText();
    }

    private Map<String, Map<String, String>> getLoginParams() {
        HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>();
        Map<String, String> headerParams = this.getLoginHeaderParams();
        params.put("headerParameters", headerParams);
        return params;
    }

    private Map<String, String> getLoginHeaderParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        String authString = this.consumerKey + ":" + this.consumerSecret;
        params.put("Authorization", "Basic " + Base64.encode((byte[])authString.getBytes()));
        params.put("Content-type", "application/x-www-form-urlencoded");
        return params;
    }

    @Override
    public int getRecordsCount(String query) throws MetadataSourceException {
        if (StringUtils.isNotBlank((CharSequence)this.consumerKey) && StringUtils.isNotBlank((CharSequence)this.consumerSecret)) {
            try {
                String bearer = this.login();
                return this.retry(new CountRecordsCallable(query, bearer));
            }
            catch (IOException | HttpException e) {
                log.warn(e.getMessage());
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return 0;
    }

    @Override
    public int getRecordsCount(Query query) throws MetadataSourceException {
        if (StringUtils.isNotBlank((CharSequence)this.consumerKey) && StringUtils.isNotBlank((CharSequence)this.consumerSecret)) {
            try {
                String bearer = this.login();
                return this.retry(new CountRecordsCallable(query, bearer));
            }
            catch (IOException | HttpException e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    @Override
    public Collection<ImportRecord> getRecords(String query, int start, int count) throws MetadataSourceException {
        if (StringUtils.isNotBlank((CharSequence)this.consumerKey) && StringUtils.isNotBlank((CharSequence)this.consumerSecret)) {
            try {
                String bearer = this.login();
                return this.retry(new SearchByQueryCallable(query, bearer, start, count));
            }
            catch (IOException | HttpException e) {
                log.warn(e.getMessage());
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return new ArrayList<ImportRecord>();
    }

    @Override
    public Collection<ImportRecord> getRecords(Query query) throws MetadataSourceException {
        if (StringUtils.isNotBlank((CharSequence)this.consumerKey) && StringUtils.isNotBlank((CharSequence)this.consumerSecret)) {
            try {
                String bearer = this.login();
                return this.retry(new SearchByQueryCallable(query, bearer));
            }
            catch (IOException | HttpException e) {
                log.warn(e.getMessage());
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return new ArrayList<ImportRecord>();
    }

    @Override
    public ImportRecord getRecord(String id) throws MetadataSourceException {
        if (StringUtils.isNotBlank((CharSequence)this.consumerKey) && StringUtils.isNotBlank((CharSequence)this.consumerSecret)) {
            try {
                String bearer = this.login();
                List<ImportRecord> list = this.retry(new SearchByIdCallable(id, bearer));
                return CollectionUtils.isNotEmpty(list) ? list.get(0) : null;
            }
            catch (IOException | HttpException e) {
                log.warn(e.getMessage());
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return null;
    }

    @Override
    public ImportRecord getRecord(Query query) throws MetadataSourceException {
        return null;
    }

    @Override
    public Collection<ImportRecord> findMatchingRecords(Item item) throws MetadataSourceException {
        return null;
    }

    @Override
    public Collection<ImportRecord> findMatchingRecords(Query query) throws MetadataSourceException {
        return null;
    }

    private Integer countDocument(String bearer, String query) {
        if (StringUtils.isBlank((CharSequence)bearer)) {
            return null;
        }
        try {
            HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>();
            HashMap<String, Object> headerParameters = new HashMap<String, Object>();
            headerParameters.put("Authorization", "Bearer " + bearer);
            headerParameters.put("X-OPS-Range", "1-1");
            params.put("headerParameters", headerParameters);
            URIBuilder uriBuilder = new URIBuilder(this.searchUrl);
            uriBuilder.addParameter("q", query);
            String response = this.liveImportClient.executeHttpGetRequest(1000, uriBuilder.toString(), params);
            SAXBuilder saxBuilder = new SAXBuilder();
            saxBuilder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            Document document = saxBuilder.build((Reader)new StringReader(response));
            Element root = document.getRootElement();
            List<Namespace> namespaces = Arrays.asList(Namespace.getNamespace((String)"xlink", (String)"http://www.w3.org/1999/xlink"), Namespace.getNamespace((String)"ops", (String)"http://ops.epo.org"), Namespace.getNamespace((String)"ns", (String)"http://www.epo.org/exchange"));
            String totalRes = this.getElement(root, namespaces, "//ops:biblio-search/@total-result-count");
            return Integer.parseInt(totalRes);
        }
        catch (IOException | URISyntaxException | JaxenException | JDOMException e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

    private List<EpoIdMetadataContributor.EpoDocumentId> searchDocumentIds(String bearer, String query, int start, int count) {
        ArrayList<EpoIdMetadataContributor.EpoDocumentId> results = new ArrayList<EpoIdMetadataContributor.EpoDocumentId>();
        int end = start + count;
        if (StringUtils.isBlank((CharSequence)bearer)) {
            return results;
        }
        try {
            HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>();
            HashMap<String, CallSite> headerParameters = new HashMap<String, CallSite>();
            headerParameters.put("Authorization", (CallSite)((Object)("Bearer " + bearer)));
            if (start >= 1 && end > start) {
                headerParameters.put("X-OPS-Range", (CallSite)((Object)(start + "-" + end)));
            }
            params.put("headerParameters", headerParameters);
            URIBuilder uriBuilder = new URIBuilder(this.searchUrl);
            uriBuilder.addParameter("q", query);
            String response = this.liveImportClient.executeHttpGetRequest(1000, uriBuilder.toString(), params);
            SAXBuilder saxBuilder = new SAXBuilder();
            saxBuilder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            Document document = saxBuilder.build((Reader)new StringReader(response));
            Element root = document.getRootElement();
            List<Namespace> namespaces = Arrays.asList(Namespace.getNamespace((String)"xlink", (String)"http://www.w3.org/1999/xlink"), Namespace.getNamespace((String)"ops", (String)"http://ops.epo.org"), Namespace.getNamespace((String)"ns", (String)"http://www.epo.org/exchange"));
            XPathExpression xpath = XPathFactory.instance().compile("//ns:document-id", Filters.element(), null, namespaces);
            List documentIds = xpath.evaluate((Object)root);
            for (Element documentId : documentIds) {
                results.add(new EpoIdMetadataContributor.EpoDocumentId(documentId, namespaces));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return results;
    }

    private List<ImportRecord> searchDocument(String bearer, EpoIdMetadataContributor.EpoDocumentId id) {
        return this.searchDocument(bearer, id.getId(), id.getDocumentIdType());
    }

    private List<ImportRecord> searchDocument(String bearer, String id, String docType) {
        ArrayList<ImportRecord> results = new ArrayList<ImportRecord>();
        if (StringUtils.isBlank((CharSequence)bearer)) {
            return results;
        }
        try {
            HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>();
            HashMap<String, CallSite> headerParameters = new HashMap<String, CallSite>();
            headerParameters.put("Authorization", (CallSite)((Object)("Bearer " + bearer)));
            params.put("headerParameters", headerParameters);
            String url = this.url.replace("$(doctype)", docType).replace("$(id)", id);
            String response = this.liveImportClient.executeHttpGetRequest(1000, url, params);
            List<Element> elements = this.splitToRecords(response);
            for (Element element : elements) {
                results.add(this.transformSourceRecords(element));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return results;
    }

    private List<Element> splitToRecords(String recordsSrc) {
        try {
            SAXBuilder saxBuilder = new SAXBuilder();
            saxBuilder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            Document document = saxBuilder.build((Reader)new StringReader(recordsSrc));
            Element root = document.getRootElement();
            List<Namespace> namespaces = Arrays.asList(Namespace.getNamespace((String)"ns", (String)"http://www.epo.org/exchange"));
            XPathExpression xpath = XPathFactory.instance().compile("//ns:exchange-document", Filters.element(), null, namespaces);
            List recordsList = xpath.evaluate((Object)root);
            return recordsList;
        }
        catch (IOException | JDOMException e) {
            log.error(e.getMessage(), e);
            return new LinkedList<Element>();
        }
    }

    private String getElement(Element document, List<Namespace> namespaces, String path) throws JaxenException {
        XPathExpression xpath = XPathFactory.instance().compile(path, Filters.fpassthrough(), null, namespaces);
        List nodes = xpath.evaluate((Object)document);
        if (CollectionUtils.isEmpty((Collection)nodes)) {
            return "";
        }
        return this.getValue(nodes.get(0));
    }

    private String getValue(Object el) {
        if (el instanceof Element) {
            return ((Element)el).getText();
        }
        if (el instanceof Attribute) {
            return ((Attribute)el).getValue();
        }
        if (el instanceof String) {
            return (String)el;
        }
        if (el instanceof Text) {
            return ((Text)el).getText();
        }
        log.error("node of type: " + el.getClass());
        return "";
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setAuthUrl(String authUrl) {
        this.authUrl = authUrl;
    }

    public void setSearchUrl(String searchUrl) {
        this.searchUrl = searchUrl;
    }

    private class CountRecordsCallable
    implements Callable<Integer> {
        private String bearer;
        private String query;

        private CountRecordsCallable(Query query, String bearer) {
            this.query = query.getParameterAsClass("query", String.class);
            this.bearer = bearer;
        }

        private CountRecordsCallable(String query, String bearer) {
            this.query = query;
            this.bearer = bearer;
        }

        @Override
        public Integer call() throws Exception {
            return EpoImportMetadataSourceServiceImpl.this.countDocument(this.bearer, this.query);
        }
    }

    private class SearchByQueryCallable
    implements Callable<List<ImportRecord>> {
        private Query query;
        private Integer start;
        private Integer count;
        private String bearer;

        private SearchByQueryCallable(Query query, String bearer) {
            this.query = query;
            this.bearer = bearer;
        }

        public SearchByQueryCallable(String queryValue, String bearer, int start, int count) {
            this.query = new Query();
            this.query.addParameter("query", queryValue);
            this.start = this.query.getParameterAsClass("start", Integer.class) != null ? this.query.getParameterAsClass("start", Integer.class) : Integer.valueOf(0);
            this.count = this.query.getParameterAsClass("count", Integer.class) != null ? this.query.getParameterAsClass("count", Integer.class) : Integer.valueOf(20);
            this.bearer = bearer;
        }

        @Override
        public List<ImportRecord> call() throws Exception {
            ArrayList<ImportRecord> records = new ArrayList<ImportRecord>();
            String queryString = this.query.getParameterAsClass("query", String.class);
            if (StringUtils.isNotBlank((CharSequence)EpoImportMetadataSourceServiceImpl.this.consumerKey) && StringUtils.isNotBlank((CharSequence)EpoImportMetadataSourceServiceImpl.this.consumerSecret) && StringUtils.isNotBlank((CharSequence)queryString) && StringUtils.isNotBlank((CharSequence)this.bearer)) {
                List<EpoIdMetadataContributor.EpoDocumentId> epoDocIds = EpoImportMetadataSourceServiceImpl.this.searchDocumentIds(this.bearer, queryString, this.start + 1, this.count);
                for (EpoIdMetadataContributor.EpoDocumentId epoDocId : epoDocIds) {
                    List<ImportRecord> recordfounds = EpoImportMetadataSourceServiceImpl.this.searchDocument(this.bearer, epoDocId);
                    if (recordfounds.size() > 1) {
                        log.warn("More record are returned with epocID " + epoDocId.toString());
                    }
                    records.addAll(recordfounds);
                }
            }
            return records;
        }
    }

    private class SearchByIdCallable
    implements Callable<List<ImportRecord>> {
        private String id;
        private String bearer;

        private SearchByIdCallable(String id, String bearer) {
            this.id = id;
            this.bearer = bearer;
        }

        @Override
        public List<ImportRecord> call() throws Exception {
            int positionToSplit = this.id.indexOf(":");
            String docType = "epodoc";
            String idS = this.id;
            if (positionToSplit != -1) {
                docType = this.id.substring(0, positionToSplit);
                idS = this.id.substring(positionToSplit + 1, this.id.length());
            } else if (this.id.contains(EpoImportMetadataSourceServiceImpl.APP_NO_DATE_SEPARATOR)) {
                String query = "applicationnumber=" + this.id.split(EpoImportMetadataSourceServiceImpl.APP_NO_DATE_SEPARATOR_REGEX)[0];
                SearchByQueryCallable search = new SearchByQueryCallable(query, this.bearer, 0, 10);
                List<ImportRecord> records = search.call().stream().filter(r -> r.getValue(EpoImportMetadataSourceServiceImpl.this.dateFiled.getSchema(), EpoImportMetadataSourceServiceImpl.this.dateFiled.getElement(), EpoImportMetadataSourceServiceImpl.this.dateFiled.getQualifier()).stream().anyMatch(m -> StringUtils.equals((CharSequence)m.getValue(), (CharSequence)this.id.split(EpoImportMetadataSourceServiceImpl.APP_NO_DATE_SEPARATOR_REGEX)[1]))).limit(1L).collect(Collectors.toList());
                return records;
            }
            List<ImportRecord> records = EpoImportMetadataSourceServiceImpl.this.searchDocument(this.bearer, idS, docType);
            if (records.size() > 1) {
                log.warn("More record are returned with epocID " + this.id);
            }
            return records;
        }
    }
}

