/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.identifier.doi;

import jakarta.mail.MessagingException;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.SQLException;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.DSpaceObject;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.logic.Filter;
import org.dspace.content.logic.FilterUtils;
import org.dspace.content.logic.TrueFilter;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.I18nUtil;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.identifier.DOI;
import org.dspace.identifier.DOIIdentifierProvider;
import org.dspace.identifier.IdentifierException;
import org.dspace.identifier.doi.DOIIdentifierException;
import org.dspace.identifier.factory.IdentifierServiceFactory;
import org.dspace.identifier.service.DOIService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.utils.DSpace;

public class DOIOrganiser {
    private static final Logger LOG = LogManager.getLogger(DOIOrganiser.class);
    private final DOIIdentifierProvider provider;
    private final Context context;
    private boolean quiet;
    protected HandleService handleService;
    protected ItemService itemService;
    protected DOIService doiService;
    protected ConfigurationService configurationService;
    protected Filter filter;

    public DOIOrganiser(Context context, DOIIdentifierProvider provider) {
        this.context = context;
        this.provider = provider;
        this.quiet = false;
        this.handleService = HandleServiceFactory.getInstance().getHandleService();
        this.itemService = ContentServiceFactory.getInstance().getItemService();
        this.doiService = IdentifierServiceFactory.getInstance().getDOIService();
        this.configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        this.filter = (Filter)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName("always_true_filter", TrueFilter.class);
    }

    public static void main(String[] args) {
        LOG.debug("Starting DOI organiser ");
        Context context = new Context();
        context.turnOffAuthorisationSystem();
        DOIOrganiser organiser = new DOIOrganiser(context, (DOIIdentifierProvider)new DSpace().getSingletonService(DOIIdentifierProvider.class));
        DOIOrganiser.runCLI(context, organiser, args);
        try {
            context.complete();
        }
        catch (SQLException sqle) {
            System.err.println("Cannot save changes to database: " + sqle.getMessage());
            System.exit(-1);
        }
    }

    public static void runCLI(Context context, DOIOrganiser organiser, String[] args) {
        DOI doiRow;
        String identifier;
        List<DOI> dois;
        String filter;
        Options options = new Options();
        options.addOption("h", "help", false, "Help");
        options.addOption("l", "list", false, "List all objects to be reserved, registered, deleted of updated ");
        options.addOption("r", "register-all", false, "Perform online registration for all identifiers queued for registration.");
        options.addOption("s", "reserve-all", false, "Perform online reservation for all identifiers queued for reservation.");
        options.addOption("u", "update-all", false, "Perform online metadata update for all identifiers queued for metadata update.");
        options.addOption("d", "delete-all", false, "Perform online deletion for all identifiers queued for deletion.");
        options.addOption("q", "quiet", false, "Turn the command line output off.");
        Option filterDoi = Option.builder().optionalArg(true).longOpt("filter").hasArg().argName("filterName").desc("Use the specified filter name instead of the provider's filter. Defaults to a special 'always true' filter to force operations").build();
        options.addOption(filterDoi);
        Option registerDoi = Option.builder().longOpt("register-doi").hasArg().argName("DOI|ItemID|handle").desc("Register a specified identifier. You can specify the identifier by ItemID, Handle or DOI.").build();
        options.addOption(registerDoi);
        Option reserveDoi = Option.builder().longOpt("reserve-doi").hasArg().argName("DOI|ItemID|handle").desc("Reserve a specified identifier online. You can specify the identifier by ItemID, Handle or DOI.").build();
        options.addOption(reserveDoi);
        Option update = Option.builder().longOpt("update-doi").hasArg().argName("DOI|ItemID|handle").desc("Update online an object for a given DOI identifier or ItemID or Handle. A DOI identifier or an ItemID or a Handle is needed.").build();
        options.addOption(update);
        Option delete = Option.builder().argName("DOI identifier").longOpt("delete-doi").hasArg().desc("Delete a specified identifier.").build();
        options.addOption(delete);
        DefaultParser parser = new DefaultParser();
        CommandLine line = null;
        HelpFormatter helpformater = new HelpFormatter();
        try {
            line = parser.parse(options, args);
        }
        catch (ParseException ex) {
            LOG.fatal((Object)ex);
            System.exit(1);
        }
        if (line.hasOption('h') || 0 == line.getOptions().length) {
            helpformater.printHelp("\nDOI organiser\n", options);
        }
        if (line.hasOption('q')) {
            organiser.setQuiet();
        }
        if (line.hasOption('l')) {
            organiser.list("reservation", null, null, DOIIdentifierProvider.TO_BE_RESERVED);
            organiser.list("registration", null, null, DOIIdentifierProvider.TO_BE_REGISTERED);
            organiser.list("update", null, null, DOIIdentifierProvider.UPDATE_BEFORE_REGISTRATION, DOIIdentifierProvider.UPDATE_REGISTERED, DOIIdentifierProvider.UPDATE_RESERVED);
            organiser.list("deletion", null, null, DOIIdentifierProvider.TO_BE_DELETED);
        }
        DOIService doiService = IdentifierServiceFactory.getInstance().getDOIService();
        if (line.hasOption("filter") && null != (filter = line.getOptionValue("filter"))) {
            organiser.filter = FilterUtils.getFilterFromConfiguration(filter);
        }
        if (line.hasOption('s')) {
            try {
                dois = doiService.getDOIsByStatus(context, Arrays.asList(DOIIdentifierProvider.TO_BE_RESERVED));
                if (dois.isEmpty()) {
                    System.err.println("There are no objects in the database that could be reserved.");
                }
                for (DOI doi : dois) {
                    doi = context.reloadEntity(doi);
                    try {
                        organiser.reserve(doi);
                        context.commit();
                    }
                    catch (RuntimeException e) {
                        System.err.format("DOI %s for object %s reservation failed, skipping:  %s%n", doi.getDSpaceObject().getID().toString(), doi.getDoi(), e.getMessage());
                        context.rollback();
                    }
                }
            }
            catch (SQLException ex) {
                System.err.println("Error in database connection:" + ex.getMessage());
                ex.printStackTrace(System.err);
            }
        }
        if (line.hasOption('r')) {
            try {
                dois = doiService.getDOIsByStatus(context, Arrays.asList(DOIIdentifierProvider.TO_BE_REGISTERED));
                if (dois.isEmpty()) {
                    System.err.println("There are no objects in the database that could be registered.");
                }
                for (DOI doi : dois) {
                    doi = context.reloadEntity(doi);
                    try {
                        organiser.register(doi);
                        context.commit();
                    }
                    catch (SQLException e) {
                        System.err.format("DOI %s for object %s registration failed, skipping:  %s%n", doi.getDSpaceObject().getID().toString(), doi.getDoi(), e.getMessage());
                        context.rollback();
                    }
                }
            }
            catch (SQLException ex) {
                System.err.format("Error in database connection:  %s%n", ex.getMessage());
                ex.printStackTrace(System.err);
            }
            catch (RuntimeException ex) {
                System.err.format("Error registering DOI identifier:  %s%n", ex.getMessage());
            }
        }
        if (line.hasOption('u')) {
            try {
                dois = doiService.getDOIsByStatus(context, Arrays.asList(DOIIdentifierProvider.UPDATE_BEFORE_REGISTRATION, DOIIdentifierProvider.UPDATE_RESERVED, DOIIdentifierProvider.UPDATE_REGISTERED));
                if (dois.isEmpty()) {
                    System.err.println("There are no objects in the database whose metadata needs an update.");
                }
                for (DOI doi : dois) {
                    doi = context.reloadEntity(doi);
                    organiser.update(doi);
                    context.commit();
                }
            }
            catch (SQLException ex) {
                System.err.println("Error in database connection:" + ex.getMessage());
                ex.printStackTrace(System.err);
            }
        }
        if (line.hasOption('d')) {
            try {
                dois = doiService.getDOIsByStatus(context, Arrays.asList(DOIIdentifierProvider.TO_BE_DELETED));
                if (dois.isEmpty()) {
                    System.err.println("There are no objects in the database that could be deleted.");
                }
                for (DOI doi : dois) {
                    doi = context.reloadEntity(doi);
                    try {
                        organiser.delete(doi.getDoi());
                        context.commit();
                    }
                    catch (SQLException e) {
                        System.err.format("DOI %s for object %s deletion failed, skipping:  %s%n", doi.getDSpaceObject().getID().toString(), doi.getDoi(), e.getMessage());
                        context.rollback();
                    }
                }
            }
            catch (SQLException ex) {
                System.err.println("Error in database connection:" + ex.getMessage());
                ex.printStackTrace(System.err);
            }
        }
        if (line.hasOption("reserve-doi")) {
            identifier = line.getOptionValue("reserve-doi");
            if (null == identifier) {
                helpformater.printHelp("\nDOI organiser\n", options);
            } else {
                try {
                    doiRow = organiser.resolveToDOI(identifier);
                    organiser.reserve(doiRow);
                }
                catch (IllegalArgumentException | IllegalStateException | SQLException | IdentifierException ex) {
                    LOG.error((Object)ex);
                }
            }
        }
        if (line.hasOption("register-doi")) {
            identifier = line.getOptionValue("register-doi");
            if (null == identifier) {
                helpformater.printHelp("\nDOI organiser\n", options);
            } else {
                try {
                    doiRow = organiser.resolveToDOI(identifier);
                    organiser.register(doiRow);
                }
                catch (IllegalArgumentException | IllegalStateException | SQLException | IdentifierException ex) {
                    LOG.error((Object)ex);
                }
            }
        }
        if (line.hasOption("update-doi")) {
            identifier = line.getOptionValue("update-doi");
            if (null == identifier) {
                helpformater.printHelp("\nDOI organiser\n", options);
            } else {
                try {
                    doiRow = organiser.resolveToDOI(identifier);
                    organiser.update(doiRow);
                }
                catch (IllegalArgumentException | IllegalStateException | SQLException | IdentifierException ex) {
                    LOG.error((Object)ex);
                }
            }
        }
        if (line.hasOption("delete-doi")) {
            identifier = line.getOptionValue("delete-doi");
            if (null == identifier) {
                helpformater.printHelp("\nDOI organiser\n", options);
            } else {
                try {
                    organiser.delete(identifier);
                }
                catch (IllegalArgumentException | SQLException ex) {
                    LOG.error((Object)ex);
                }
            }
        }
    }

    public void list(String processName, PrintStream out, PrintStream err, Integer ... status) {
        String indent = "    ";
        if (null == out) {
            out = System.out;
        }
        if (null == err) {
            err = System.err;
        }
        try {
            List<DOI> doiList = this.doiService.getDOIsByStatus(this.context, Arrays.asList(status));
            if (0 < doiList.size()) {
                out.println("DOIs queued for " + processName + ": ");
            } else {
                out.println("There are no DOIs queued for " + processName + ".");
            }
            for (DOI doiRow : doiList) {
                out.print(indent + "doi:" + doiRow.getDoi());
                DSpaceObject dso = doiRow.getDSpaceObject();
                if (null != dso) {
                    out.println(" (belongs to item with handle " + dso.getHandle() + ")");
                    continue;
                }
                out.println(" (cannot determine handle of assigned object)");
            }
            out.println("");
        }
        catch (SQLException ex) {
            err.println("Error in database Connection: " + ex.getMessage());
            ex.printStackTrace(err);
        }
    }

    public void register(DOI doiRow, Filter filter) throws IllegalArgumentException, IllegalStateException, RuntimeException {
        DSpaceObject dso = doiRow.getDSpaceObject();
        if (2 != dso.getType()) {
            throw new IllegalArgumentException("Currenty DSpace supports DOIs for Items only.");
        }
        try {
            this.provider.registerOnline(this.context, dso, "doi:" + doiRow.getDoi(), filter);
            if (!this.quiet) {
                System.out.println("This identifier: doi:" + doiRow.getDoi() + " is successfully registered.");
            }
        }
        catch (IdentifierException ex) {
            if (!(ex instanceof DOIIdentifierException)) {
                LOG.error("It wasn't possible to register this identifier: doi:" + doiRow.getDoi() + " online. ", (Throwable)ex);
            }
            DOIIdentifierException doiIdentifierException = (DOIIdentifierException)ex;
            try {
                this.sendAlertMail("Register", dso, "doi:" + doiRow.getDoi(), DOIIdentifierException.codeToString(doiIdentifierException.getCode()));
            }
            catch (IOException ioe) {
                LOG.error("Couldn't send mail", (Throwable)ioe);
            }
            LOG.error("It wasn't possible to register this identifier : doi:" + doiRow.getDoi() + " online. Exceptions code: " + DOIIdentifierException.codeToString(doiIdentifierException.getCode()), (Throwable)ex);
            if (!this.quiet) {
                System.err.println("It wasn't possible to register this identifier: doi:" + doiRow.getDoi());
            }
        }
        catch (IllegalArgumentException ex) {
            LOG.error("Database table DOI contains a DOI that is not valid: doi:" + doiRow.getDoi() + "!", (Throwable)ex);
            if (!this.quiet) {
                System.err.println("It wasn't possible to register this identifier: doi:" + doiRow.getDoi());
            }
            throw new IllegalStateException("Database table DOI contains a DOI  that is not valid: doi:" + doiRow.getDoi() + "!", ex);
        }
        catch (SQLException ex) {
            LOG.error("Error while trying to get data from database", (Throwable)ex);
            if (!this.quiet) {
                System.err.println("It wasn't possible to register this identifier: doi:" + doiRow.getDoi());
            }
            throw new RuntimeException("Error while trying to get data from database", ex);
        }
    }

    public void register(DOI doiRow) throws IllegalStateException, IllegalArgumentException, RuntimeException {
        this.register(doiRow, this.filter);
    }

    public void reserve(DOI doiRow) {
        this.reserve(doiRow, this.filter);
    }

    public void reserve(DOI doiRow, Filter filter) {
        DSpaceObject dso = doiRow.getDSpaceObject();
        if (2 != dso.getType()) {
            throw new IllegalArgumentException("Currently DSpace supports DOIs for Items only.");
        }
        try {
            this.provider.reserveOnline(this.context, dso, "doi:" + doiRow.getDoi(), filter);
            if (!this.quiet) {
                System.out.println("This identifier : doi:" + doiRow.getDoi() + " is successfully reserved.");
            }
        }
        catch (IdentifierException ex) {
            if (!(ex instanceof DOIIdentifierException)) {
                LOG.error("It wasn't possible to register this identifier : doi:" + doiRow.getDoi() + " online. ", (Throwable)ex);
            }
            DOIIdentifierException doiIdentifierException = (DOIIdentifierException)ex;
            try {
                this.sendAlertMail("Reserve", dso, "doi:" + doiRow.getDoi(), DOIIdentifierException.codeToString(doiIdentifierException.getCode()));
            }
            catch (IOException ioe) {
                LOG.error("Couldn't send mail", (Throwable)ioe);
            }
            LOG.error("It wasn't possible to reserve the identifier online.  Exceptions code:  " + DOIIdentifierException.codeToString(doiIdentifierException.getCode()), (Throwable)ex);
            if (!this.quiet) {
                System.err.println("It wasn't possible to reserve this identifier: doi:" + doiRow.getDoi());
            }
        }
        catch (IllegalArgumentException ex) {
            LOG.error("Database table DOI contains a DOI that is not valid: doi:" + doiRow.getDoi() + "!", (Throwable)ex);
            if (!this.quiet) {
                System.err.println("It wasn't possible to reserve this identifier: doi:" + doiRow.getDoi());
            }
            throw new IllegalStateException("Database table DOI contains a DOI  that is not valid: doi:" + doiRow.getDoi() + "!", ex);
        }
        catch (SQLException ex) {
            LOG.error("Error while trying to get data from database", (Throwable)ex);
            if (!this.quiet) {
                System.err.println("It wasn't possible to reserve this identifier: doi:" + doiRow.getDoi());
            }
            throw new RuntimeException("Error while trying to get data from database", ex);
        }
    }

    public void update(DOI doiRow) {
        DSpaceObject dso = doiRow.getDSpaceObject();
        if (2 != dso.getType()) {
            throw new IllegalArgumentException("Currently DSpace supports DOIs for Items only.");
        }
        try {
            this.provider.updateMetadataOnline(this.context, dso, "doi:" + doiRow.getDoi());
            if (!this.quiet) {
                System.out.println("Successfully updated metadata of DOI doi:" + doiRow.getDoi() + ".");
            }
        }
        catch (IdentifierException ex) {
            if (!(ex instanceof DOIIdentifierException)) {
                LOG.error("Registering DOI {} for object {}:  the registrar returned an error.", (Object)doiRow.getDoi(), (Object)dso.getID(), (Object)ex);
            }
            DOIIdentifierException doiIdentifierException = (DOIIdentifierException)ex;
            try {
                this.sendAlertMail("Update", dso, "doi:" + doiRow.getDoi(), DOIIdentifierException.codeToString(doiIdentifierException.getCode()));
            }
            catch (IOException ioe) {
                LOG.error("Couldn't send mail", (Throwable)ioe);
            }
            LOG.error("It wasn't possible to update this identifier:  doi:" + doiRow.getDoi() + " Exceptions code:  " + DOIIdentifierException.codeToString(doiIdentifierException.getCode()), (Throwable)ex);
            if (!this.quiet) {
                System.err.println("It wasn't possible to update this identifier: doi:" + doiRow.getDoi());
            }
        }
        catch (IllegalArgumentException ex) {
            LOG.error("Database table DOI contains a DOI that is not valid: doi:" + doiRow.getDoi() + "!", (Throwable)ex);
            if (!this.quiet) {
                System.err.println("It wasn't possible to update this identifier: doi:" + doiRow.getDoi());
            }
            throw new IllegalStateException("Database table DOI contains a DOI  that is not valid: doi:" + doiRow.getDoi() + "!", ex);
        }
        catch (SQLException ex) {
            LOG.error("It wasn't possible to connect to the Database!", (Throwable)ex);
        }
    }

    public void delete(String identifier) throws SQLException {
        block6: {
            String doi = null;
            DOI doiRow = null;
            try {
                doi = this.doiService.formatIdentifier(identifier);
                doiRow = this.doiService.findByDoi(this.context, doi.substring("doi:".length()));
                if (null == doiRow) {
                    throw new IllegalStateException("You specified a valid DOI, that is not stored in our database.");
                }
                this.provider.deleteOnline(this.context, doi);
                if (!this.quiet) {
                    System.err.println("It was possible to delete this identifier: doi:" + doiRow.getDoi() + " online.");
                }
            }
            catch (DOIIdentifierException ex) {
                LOG.error("It wasn't possible to detect this identifier:  " + identifier + " Exceptions code:  " + DOIIdentifierException.codeToString(ex.getCode()), (Throwable)ex);
                if (!this.quiet) {
                    System.err.println("It wasn't possible to detect this identifier: " + identifier);
                }
            }
            catch (IllegalArgumentException ex) {
                if (this.quiet) break block6;
                System.err.println("It wasn't possible to delete this identifier: doi:" + doiRow.getDoi() + " online. Take a look in log file.");
            }
        }
    }

    public DOI resolveToDOI(String identifier) throws SQLException, IllegalArgumentException, IllegalStateException, IdentifierException {
        DOI doiRow;
        block10: {
            if (null == identifier || identifier.isEmpty()) {
                throw new IllegalArgumentException("Identifier is null or empty.");
            }
            doiRow = null;
            String doi = null;
            if (identifier.matches("[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[34][0-9a-fA-F]{3}-[89ab][0-9a-fA-F]{3}-[0-9a-fA-F]{12}")) {
                Object dso = this.itemService.find(this.context, UUID.fromString(identifier));
                if (null != dso) {
                    doiRow = this.doiService.findDOIByDSpaceObject(this.context, (DSpaceObject)dso);
                    if (null == doiRow) {
                        doi = this.provider.mint(this.context, (DSpaceObject)dso, this.filter);
                        doiRow = this.doiService.findByDoi(this.context, doi.substring("doi:".length()));
                        return doiRow;
                    }
                    return doiRow;
                }
                throw new IllegalStateException("You specified an ItemID, that is not stored in our database.");
            }
            DSpaceObject dso = this.handleService.resolveToObject(this.context, identifier);
            if (null != dso) {
                if (dso.getType() != 2) {
                    throw new IllegalArgumentException("Currently DSpace supports DOIs for Items only. Cannot process specified handle as it does not identify an Item.");
                }
                doiRow = this.doiService.findDOIByDSpaceObject(this.context, dso);
                if (null == doiRow) {
                    doi = this.provider.mint(this.context, dso, this.filter);
                    doiRow = this.doiService.findByDoi(this.context, doi.substring("doi:".length()));
                }
                return doiRow;
            }
            try {
                doi = this.doiService.formatIdentifier(identifier);
                doiRow = this.doiService.findByDoi(this.context, doi.substring("doi:".length()));
                if (null == doiRow) {
                    throw new IllegalStateException("You specified a valid DOI, that is not stored in our database.");
                }
            }
            catch (DOIIdentifierException ex) {
                LOG.error("It wasn't possible to detect this identifier:  " + identifier + " Exceptions code:  " + DOIIdentifierException.codeToString(ex.getCode()), (Throwable)ex);
                if (this.quiet) break block10;
                System.err.println("It wasn't possible to detect this DOI identifier: " + identifier);
            }
        }
        return doiRow;
    }

    private void sendAlertMail(String action, DSpaceObject dso, String doi, String reason) throws IOException {
        block4: {
            String recipient = this.configurationService.getProperty("alert.recipient");
            try {
                if (recipient != null) {
                    Email email = Email.getEmail(I18nUtil.getEmailFilename(Locale.getDefault(), "doi_maintenance_error"));
                    email.addRecipient(recipient);
                    email.addArgument(action);
                    email.addArgument(Instant.now());
                    email.addArgument(ContentServiceFactory.getInstance().getDSpaceObjectService(dso).getTypeText(dso));
                    email.addArgument(dso.getID().toString());
                    email.addArgument(doi);
                    email.addArgument(reason);
                    email.send();
                    if (!this.quiet) {
                        System.err.println("Email alert is sent.");
                    }
                }
            }
            catch (MessagingException | IOException e) {
                LOG.warn("Unable to send email alert", e);
                if (this.quiet) break block4;
                System.err.println("Unable to send email alert.");
            }
        }
    }

    private void setQuiet() {
        this.quiet = true;
    }
}

