/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.harvest;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.time.Instant;
import org.dspace.content.Item;
import org.dspace.core.ReloadableEntity;

@Entity
@Table(name="harvested_item")
public class HarvestedItem
implements ReloadableEntity<Integer> {
    @Id
    @Column(name="id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="harvested_item_seq")
    @SequenceGenerator(name="harvested_item_seq", sequenceName="harvested_item_seq", allocationSize=1)
    private Integer id;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="item_id", unique=true)
    private Item item;
    @Column(name="last_harvested", columnDefinition="timestamp with time zone")
    private Instant lastHarvested;
    @Column(name="oai_id")
    private String oaiId;

    protected HarvestedItem() {
    }

    @Override
    public Integer getID() {
        return this.id;
    }

    void setItem(Item item) {
        this.item = item;
    }

    public Item getItem() {
        return this.item;
    }

    void setOaiId(String oaiId) {
        this.oaiId = oaiId;
    }

    public String getOaiID() {
        return this.oaiId;
    }

    public void setOaiID(String itemOaiID) {
        this.oaiId = itemOaiID;
    }

    public void setHarvestDate(Instant date) {
        if (date == null) {
            date = Instant.now();
        }
        this.lastHarvested = date;
    }

    public Instant getHarvestDate() {
        return this.lastHarvested;
    }
}

