/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.external.provider.impl;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.dspace.content.dto.MetadataValueDTO;
import org.dspace.external.model.ExternalDataObject;
import org.dspace.external.provider.AbstractExternalDataProvider;
import org.dspace.importer.external.datamodel.ImportRecord;
import org.dspace.importer.external.exception.MetadataSourceException;
import org.dspace.importer.external.metadatamapping.MetadatumDTO;
import org.dspace.importer.external.service.components.QuerySource;

public class LiveImportDataProvider
extends AbstractExternalDataProvider {
    private QuerySource querySource;
    private String sourceIdentifier;
    private String recordIdMetadata;
    private String displayMetadata = "dc.title";

    @Override
    public String getSourceIdentifier() {
        return this.sourceIdentifier;
    }

    public void setSourceIdentifier(String sourceIdentifier) {
        this.sourceIdentifier = sourceIdentifier;
    }

    public void setMetadataSource(QuerySource querySource) {
        this.querySource = querySource;
    }

    public void setRecordIdMetadata(String recordIdMetadata) {
        this.recordIdMetadata = recordIdMetadata;
    }

    public void setDisplayMetadata(String displayMetadata) {
        this.displayMetadata = displayMetadata;
    }

    @Override
    public Optional<ExternalDataObject> getExternalDataObject(String id) {
        try {
            ExternalDataObject externalDataObject = this.getExternalDataObject(this.querySource.getRecord(id));
            return Optional.of(externalDataObject);
        }
        catch (MetadataSourceException e) {
            throw new RuntimeException("The live import provider " + this.querySource.getImportSource() + " throws an exception", e);
        }
    }

    @Override
    public List<ExternalDataObject> searchExternalDataObjects(String query, int start, int limit) {
        try {
            Collection<ImportRecord> records = this.querySource.getRecords(query, start, limit);
            return records.stream().map(r -> this.getExternalDataObject((ImportRecord)r)).collect(Collectors.toList());
        }
        catch (MetadataSourceException e) {
            throw new RuntimeException("The live import provider " + this.querySource.getImportSource() + " throws an exception", e);
        }
    }

    @Override
    public boolean supports(String source) {
        return StringUtils.equalsIgnoreCase((CharSequence)this.sourceIdentifier, (CharSequence)source);
    }

    @Override
    public int getNumberOfResults(String query) {
        try {
            return this.querySource.getRecordsCount(query);
        }
        catch (MetadataSourceException e) {
            throw new RuntimeException("The live import provider " + this.querySource.getImportSource() + " throws an exception", e);
        }
    }

    private ExternalDataObject getExternalDataObject(ImportRecord record) {
        if (record == null) {
            throw new IllegalArgumentException("No record found for query or id");
        }
        ExternalDataObject externalDataObject = new ExternalDataObject(this.sourceIdentifier);
        String id = this.getFirstValue(record, this.recordIdMetadata);
        String display = this.getFirstValue(record, this.displayMetadata);
        externalDataObject.setId(id);
        externalDataObject.setDisplayValue(display);
        externalDataObject.setValue(display);
        for (MetadatumDTO dto : record.getValueList()) {
            MetadataValueDTO mvDTO = new MetadataValueDTO();
            mvDTO.setSchema(dto.getSchema());
            mvDTO.setElement(dto.getElement());
            mvDTO.setQualifier(dto.getQualifier());
            mvDTO.setValue(dto.getValue());
            externalDataObject.addMetadata(mvDTO);
        }
        return externalDataObject;
    }

    private String getFirstValue(ImportRecord record, String metadata) {
        String id = null;
        String[] split = StringUtils.split((String)metadata, (String)".", (int)3);
        Collection<MetadatumDTO> values = record.getValue(split[0], split[1], split.length == 3 ? split[2] : null);
        if (!values.isEmpty()) {
            id = values.iterator().next().getValue();
        }
        return id;
    }
}

