/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson.dao.impl;

import jakarta.persistence.Query;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.tuple.Pair;
import org.dspace.core.AbstractHibernateDAO;
import org.dspace.core.Context;
import org.dspace.eperson.Group;
import org.dspace.eperson.Group2GroupCache;
import org.dspace.eperson.Group2GroupCache_;
import org.dspace.eperson.dao.Group2GroupCacheDAO;
import org.hibernate.query.NativeQuery;

public class Group2GroupCacheDAOImpl
extends AbstractHibernateDAO<Group2GroupCache>
implements Group2GroupCacheDAO {
    protected Group2GroupCacheDAOImpl() {
    }

    @Override
    public Set<Pair<UUID, UUID>> getCache(Context context) throws SQLException {
        Query query = this.createQuery(context, "SELECT new org.apache.commons.lang3.tuple.ImmutablePair(g.parent.id, g.child.id) FROM Group2GroupCache g");
        List results = query.getResultList();
        return new HashSet<Pair<UUID, UUID>>(results);
    }

    @Override
    public List<Group2GroupCache> findByParent(Context context, Group group) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Group2GroupCache> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Group2GroupCache.class);
        Root group2GroupCacheRoot = criteriaQuery.from(Group2GroupCache.class);
        criteriaQuery.select((Selection)group2GroupCacheRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)group2GroupCacheRoot.get(Group2GroupCache_.parent), (Object)group));
        return this.list(context, criteriaQuery, true, Group2GroupCache.class, -1, -1);
    }

    @Override
    public List<Group2GroupCache> findByChildren(Context context, Iterable<Group> groups) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Group2GroupCache> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Group2GroupCache.class);
        Root group2GroupCacheRoot = criteriaQuery.from(Group2GroupCache.class);
        LinkedList<Predicate> eqPredicates = new LinkedList<Predicate>();
        for (Group group : groups) {
            eqPredicates.add(criteriaBuilder.equal((Expression)group2GroupCacheRoot.get(Group2GroupCache_.child), (Object)group));
        }
        Predicate orPredicate = criteriaBuilder.or(eqPredicates.toArray(new Predicate[0]));
        criteriaQuery.select((Selection)group2GroupCacheRoot);
        criteriaQuery.where((Expression)orPredicate);
        return this.list(context, criteriaQuery, true, Group2GroupCache.class, -1, -1);
    }

    @Override
    public Group2GroupCache findByParentAndChild(Context context, Group parent, Group child) throws SQLException {
        Query query = this.createQuery(context, "FROM Group2GroupCache g WHERE g.parent = :parentGroup AND g.child = :childGroup");
        query.setParameter("parentGroup", (Object)parent);
        query.setParameter("childGroup", (Object)child);
        query.setHint("org.hibernate.cacheable", (Object)Boolean.TRUE);
        return (Group2GroupCache)this.singleResult(query);
    }

    @Override
    public Group2GroupCache find(Context context, Group parent, Group child) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Group2GroupCache> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Group2GroupCache.class);
        Root group2GroupCacheRoot = criteriaQuery.from(Group2GroupCache.class);
        criteriaQuery.select((Selection)group2GroupCacheRoot);
        criteriaQuery.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)group2GroupCacheRoot.get(Group2GroupCache_.parent), (Object)parent), (Expression)criteriaBuilder.equal((Expression)group2GroupCacheRoot.get(Group2GroupCache_.child), (Object)child)));
        return this.uniqueResult(context, criteriaQuery, true, Group2GroupCache.class);
    }

    @Override
    public void deleteAll(Context context) throws SQLException {
        this.createQuery(context, "delete from Group2GroupCache").executeUpdate();
    }

    @Override
    public void deleteFromCache(Context context, UUID parent, UUID child) throws SQLException {
        NativeQuery query = this.getHibernateSession(context).createNativeQuery("delete from group2groupcache g WHERE g.parent_id = :parent AND g.child_id = :child");
        query.setParameter("parent", (Object)parent);
        query.setParameter("child", (Object)child);
        query.executeUpdate();
    }

    @Override
    public void addToCache(Context context, UUID parent, UUID child) throws SQLException {
        NativeQuery query = this.getHibernateSession(context).createNativeQuery("insert into group2groupcache (parent_id, child_id) VALUES (:parent, :child)");
        query.setParameter("parent", (Object)parent);
        query.setParameter("child", (Object)child);
        query.executeUpdate();
    }
}

