/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson;

import jakarta.annotation.PostConstruct;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.HmacUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.eperson.InvalidReCaptchaException;
import org.dspace.eperson.service.CaptchaService;
import org.dspace.services.ConfigurationService;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;

public class AltchaCaptchaServiceImpl
implements CaptchaService {
    private static final Logger log = LogManager.getLogger(AltchaCaptchaServiceImpl.class);
    @Autowired
    private ConfigurationService configurationService;

    @PostConstruct
    public void init() {
    }

    @Override
    public void processResponse(String captchaPayloadHeader, String action) throws InvalidReCaptchaException {
        if (!this.validateAltchaCaptcha(captchaPayloadHeader)) {
            throw new InvalidReCaptchaException("ALTCHA captcha validation failed");
        }
    }

    private boolean validateAltchaCaptcha(String captchaPayloadHeader) throws InvalidReCaptchaException {
        String captchaPayloadJson = new String(Base64.decodeBase64((byte[])captchaPayloadHeader.getBytes(StandardCharsets.UTF_8)));
        JSONObject captchaPayload = new JSONObject(captchaPayloadJson);
        try {
            if (captchaPayload.has("challenge") && captchaPayload.has("salt") && captchaPayload.has("number") && captchaPayload.has("signature") && captchaPayload.has("algorithm")) {
                String algorithm = captchaPayload.getString("algorithm");
                if (!"SHA-256".equals(algorithm)) {
                    throw new InvalidReCaptchaException("ALTCHA algorithm must be SHA-256, check config and payload");
                }
                String challenge = captchaPayload.getString("challenge");
                String salt = captchaPayload.getString("salt");
                String number = String.valueOf(captchaPayload.getNumber("number"));
                String signature = captchaPayload.getString("signature");
                String hash = CaptchaService.calculateHash(salt + number, captchaPayload.getString("algorithm"));
                String hmacKey = this.configurationService.getProperty("altcha.hmac.key");
                if (hmacKey == null) {
                    log.error("hmac key not found, see: altcha.hmac.key in altcha.cfg");
                    throw new InvalidReCaptchaException("hmac key not found");
                }
                String hmac = new HmacUtils("HmacSHA256", hmacKey).hmacHex(challenge);
                if (StringUtils.isBlank((CharSequence)hmac)) {
                    log.error("Error generating HMAC signature");
                    throw new InvalidReCaptchaException("error generating hmac signature");
                }
                boolean challengeVerified = challenge.equals(hash);
                boolean signatureVerified = signature.equals(hmac);
                return challengeVerified && signatureVerified;
            }
        }
        catch (Exception e) {
            throw new InvalidReCaptchaException("Failed to validate ALTCHA captcha: " + e.getMessage());
        }
        return false;
    }
}

