/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson;

import jakarta.mail.MessagingException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authenticate.service.AuthenticationService;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.MetadataValue;
import org.dspace.content.service.MetadataValueService;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.I18nUtil;
import org.dspace.core.Utils;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.RegistrationData;
import org.dspace.eperson.RegistrationDataMetadata;
import org.dspace.eperson.RegistrationTypeEnum;
import org.dspace.eperson.dto.RegistrationDataPatch;
import org.dspace.eperson.service.AccountService;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.GroupService;
import org.dspace.eperson.service.RegistrationDataService;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.log.LogMessage;

public class AccountServiceImpl
implements AccountService {
    private static final Logger log = LogManager.getLogger(AccountServiceImpl.class);
    private static final Map<String, BiConsumer<RegistrationData, EPerson>> allowedMergeArguments = Map.of("email", (registrationData, eperson) -> eperson.setEmail(registrationData.getEmail()));
    @Autowired(required=true)
    protected EPersonService ePersonService;
    @Autowired(required=true)
    protected RegistrationDataService registrationDataService;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private GroupService groupService;
    @Autowired
    private AuthenticationService authenticationService;
    @Autowired
    private MetadataValueService metadataValueService;

    protected AccountServiceImpl() {
    }

    @Override
    public void sendRegistrationInfo(Context context, String email) throws SQLException, IOException, MessagingException, AuthorizeException {
        if (!this.configurationService.getBooleanProperty("user.registration", true)) {
            throw new IllegalStateException("The user.registration parameter was set to false");
        }
        if (!this.authenticationService.canSelfRegister(context, null, email)) {
            throw new IllegalStateException("self registration is not allowed with this email address");
        }
        this.sendInfo(context, email, RegistrationTypeEnum.REGISTER, true);
    }

    @Override
    public void sendForgotPasswordInfo(Context context, String email) throws SQLException, IOException, MessagingException, AuthorizeException {
        this.sendInfo(context, email, RegistrationTypeEnum.FORGOT, true);
    }

    @Override
    public boolean existsAccountFor(Context context, String token) throws SQLException, AuthorizeException {
        return this.getEPerson(context, token) != null;
    }

    @Override
    public boolean existsAccountWithEmail(Context context, String email) throws SQLException {
        return this.ePersonService.findByEmail(context, email) != null;
    }

    @Override
    public EPerson getEPerson(Context context, String token) throws SQLException, AuthorizeException {
        String email = this.getEmail(context, token);
        if (email == null) {
            return null;
        }
        return this.ePersonService.findByEmail(context, email);
    }

    @Override
    public String getEmail(Context context, String token) throws SQLException {
        RegistrationData registrationData = this.registrationDataService.findByToken(context, token);
        if (registrationData == null) {
            return null;
        }
        return registrationData.getEmail();
    }

    @Override
    public void deleteToken(Context context, String token) throws SQLException {
        this.registrationDataService.deleteByToken(context, token);
    }

    @Override
    public EPerson mergeRegistration(Context context, UUID personId, String token, List<String> overrides) throws AuthorizeException, SQLException {
        RegistrationData registrationData = this.getRegistrationData(context, token);
        EPerson eperson = null;
        if (personId != null) {
            eperson = (EPerson)this.ePersonService.findByIdOrLegacyId(context, personId.toString());
        }
        if (!this.canCreateUserBy(context, registrationData.getRegistrationType())) {
            throw new AuthorizeException("Token type invalid for the current user.");
        }
        if (this.hasLoggedEPerson(context) && !this.isSameContextEPerson(context, eperson)) {
            throw new AuthorizeException("Only the user with id: " + personId + " can make this action.");
        }
        context.turnOffAuthorisationSystem();
        eperson = Optional.ofNullable(eperson).orElseGet(() -> this.createEPerson(context, registrationData));
        this.updateValuesFromRegistration(context, eperson, registrationData, overrides);
        this.deleteToken(context, token);
        this.ePersonService.update(context, eperson);
        context.commit();
        context.restoreAuthSystemState();
        return eperson;
    }

    private EPerson createEPerson(Context context, RegistrationData registrationData) {
        EPerson eperson;
        try {
            RegistrationDataMetadata lastName;
            eperson = this.ePersonService.create(context);
            eperson.setNetid(registrationData.getNetId());
            eperson.setEmail(registrationData.getEmail());
            RegistrationDataMetadata firstName = this.registrationDataService.getMetadataByMetadataString(registrationData, "eperson.firstname");
            if (firstName != null) {
                eperson.setFirstName(context, firstName.getValue());
            }
            if ((lastName = this.registrationDataService.getMetadataByMetadataString(registrationData, "eperson.lastname")) != null) {
                eperson.setLastName(context, lastName.getValue());
            }
            eperson.setCanLogIn(true);
            eperson.setSelfRegistered(true);
        }
        catch (SQLException | AuthorizeException e) {
            throw new RuntimeException("Cannote create the eperson linked to the token: " + registrationData.getToken(), e);
        }
        return eperson;
    }

    private boolean hasLoggedEPerson(Context context) {
        return context.getCurrentUser() != null;
    }

    private boolean isSameContextEPerson(Context context, EPerson eperson) {
        return context.getCurrentUser().equals(eperson);
    }

    @Override
    public RegistrationData renewRegistrationForEmail(Context context, RegistrationDataPatch registrationDataPatch) throws AuthorizeException {
        try {
            RegistrationData newRegistration = this.registrationDataService.clone(context, registrationDataPatch);
            this.registrationDataService.delete(context, registrationDataPatch.getOldRegistration());
            this.sendRegistationLinkByEmail(context, newRegistration);
            return newRegistration;
        }
        catch (MessagingException | IOException | SQLException e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    private boolean isEmailConfirmed(RegistrationData oldRegistration, String email) {
        return email.equals(oldRegistration.getEmail());
    }

    @Override
    public boolean isTokenValidForCreation(RegistrationData registrationData) {
        return (AccountServiceImpl.isExternalRegistrationToken(registrationData.getRegistrationType()) || AccountServiceImpl.isValidationToken(registrationData.getRegistrationType())) && StringUtils.isNotBlank((String)registrationData.getNetId());
    }

    private boolean canCreateUserBy(Context context, RegistrationTypeEnum registrationTypeEnum) {
        return AccountServiceImpl.isValidationToken(registrationTypeEnum) || AccountServiceImpl.canCreateUserFromExternalRegistrationToken(context, registrationTypeEnum);
    }

    private static boolean canCreateUserFromExternalRegistrationToken(Context context, RegistrationTypeEnum registrationTypeEnum) {
        return context.getCurrentUser() != null && AccountServiceImpl.isExternalRegistrationToken(registrationTypeEnum);
    }

    private static boolean isExternalRegistrationToken(RegistrationTypeEnum registrationTypeEnum) {
        return RegistrationTypeEnum.ORCID.equals((Object)registrationTypeEnum);
    }

    private static boolean isValidationToken(RegistrationTypeEnum registrationTypeEnum) {
        return RegistrationTypeEnum.VALIDATION_ORCID.equals((Object)registrationTypeEnum);
    }

    protected void updateValuesFromRegistration(Context context, EPerson eperson, RegistrationData registrationData, List<String> overrides) {
        Stream.concat(this.getMergeActions(registrationData, overrides), this.getUpdateActions(context, eperson, registrationData)).forEach(c -> c.accept(eperson));
    }

    private Stream<Consumer<EPerson>> getMergeActions(RegistrationData registrationData, List<String> overrides) {
        if (overrides == null || overrides.isEmpty()) {
            return Stream.empty();
        }
        return overrides.stream().map(f -> this.mergeField((String)f, registrationData));
    }

    protected Stream<Consumer<EPerson>> getUpdateActions(Context context, EPerson eperson, RegistrationData registrationData) {
        Stream.Builder<Consumer<EPerson>> actions = Stream.builder();
        if (eperson.getNetid() == null) {
            actions.add(p -> p.setNetid(registrationData.getNetId()));
        }
        if (eperson.getEmail() == null) {
            actions.add(p -> p.setEmail(registrationData.getEmail()));
        }
        for (RegistrationDataMetadata metadatum : registrationData.getMetadata()) {
            Optional<List> epersonMetadata = Optional.ofNullable(this.ePersonService.getMetadataByMetadataString(eperson, metadatum.getMetadataField().toString('.'))).filter(l -> !l.isEmpty());
            if (!epersonMetadata.isEmpty()) continue;
            actions.add(p -> this.addMetadataValue(context, metadatum, (EPerson)p));
        }
        return actions.build();
    }

    private List<MetadataValue> addMetadataValue(Context context, RegistrationDataMetadata metadatum, EPerson p) {
        try {
            return this.ePersonService.addMetadata(context, p, metadatum.getMetadataField(), "*", List.of(metadatum.getValue()));
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not add metadata" + metadatum.getMetadataField() + " to eperson with uuid: " + p.getID(), e);
        }
    }

    protected Consumer<EPerson> mergeField(String field, RegistrationData registrationData) {
        return person -> allowedMergeArguments.getOrDefault(field, this.mergeRegistrationMetadata(field)).accept(registrationData, (EPerson)person);
    }

    protected BiConsumer<RegistrationData, EPerson> mergeRegistrationMetadata(String field) {
        return (registrationData, person) -> {
            RegistrationDataMetadata registrationMetadata = this.getMetadataOrThrow((RegistrationData)registrationData, field);
            MetadataValue metadata = this.getMetadataOrThrow((EPerson)person, field);
            metadata.setValue(registrationMetadata.getValue());
            this.ePersonService.setMetadataModified(person);
        };
    }

    private RegistrationDataMetadata getMetadataOrThrow(RegistrationData registrationData, String field) {
        return this.registrationDataService.getMetadataByMetadataString(registrationData, field);
    }

    private MetadataValue getMetadataOrThrow(EPerson eperson, String field) {
        return (MetadataValue)this.ePersonService.getMetadataByMetadataString(eperson, field).stream().findFirst().orElseThrow(() -> new IllegalArgumentException("Could not find the metadata field: " + field + " for eperson: " + eperson.getID()));
    }

    private RegistrationData getRegistrationData(Context context, String token) throws SQLException, AuthorizeException {
        return Optional.ofNullable(this.registrationDataService.findByToken(context, token)).filter(rd -> this.isValid((RegistrationData)rd) || !AccountServiceImpl.isValidationToken(rd.getRegistrationType())).orElseThrow(() -> new AuthorizeException("The registration token: " + token + " is not valid!"));
    }

    private boolean isValid(RegistrationData rd) {
        return this.registrationDataService.isValid(rd);
    }

    protected RegistrationData sendInfo(Context context, String email, RegistrationTypeEnum type, boolean send) throws SQLException, IOException, MessagingException, AuthorizeException {
        RegistrationData rd = this.registrationDataService.findBy(context, email, type);
        boolean isRegister = RegistrationTypeEnum.REGISTER.equals((Object)type);
        if (rd == null) {
            rd = this.registrationDataService.create(context);
            rd.setRegistrationType(type);
            rd.setToken(Utils.generateHexKey());
            rd.setEmail(email);
            this.registrationDataService.update(context, rd);
            if (log.isDebugEnabled()) {
                log.debug("Created callback " + rd.getID() + " with token " + rd.getToken() + " with email \"" + email + "\"");
            }
        }
        if (send) {
            this.fillAndSendEmail(context, email, isRegister, rd);
        }
        return rd;
    }

    protected void fillAndSendEmail(Context context, String email, boolean isRegister, RegistrationData rd) throws MessagingException, IOException, SQLException {
        String base = this.configurationService.getProperty("dspace.ui.url");
        String specialLink = new StringBuffer().append(base).append(base.endsWith("/") ? "" : "/").append(isRegister ? "register" : "forgot").append("/").append(rd.getToken()).toString();
        Locale locale = context.getCurrentLocale();
        String emailFilename = I18nUtil.getEmailFilename(locale, isRegister ? "register" : "change_password");
        this.fillAndSendEmail(email, emailFilename, specialLink);
        if (log.isInfoEnabled()) {
            log.info("Sent " + (isRegister ? "registration" : "account") + " information to " + email);
        }
    }

    private static String getSpecialLink(String base, RegistrationData rd, String subPath) {
        return new StringBuffer(base).append(base.endsWith("/") ? "" : "/").append(subPath).append("/").append(rd.getToken()).toString();
    }

    protected void sendRegistationLinkByEmail(Context context, RegistrationData rd) throws MessagingException, IOException {
        String base = this.configurationService.getProperty("dspace.ui.url");
        String specialLink = AccountServiceImpl.getSpecialLink(base, rd, rd.getRegistrationType().getLink());
        String emailFilename = I18nUtil.getEmailFilename(context.getCurrentLocale(), rd.getRegistrationType().toString().toLowerCase());
        this.fillAndSendEmail(rd.getEmail(), emailFilename, specialLink);
        log.info((CharSequence)LogMessage.of(() -> "Sent " + rd.getRegistrationType().getLink() + " link to " + rd.getEmail()));
    }

    protected void fillAndSendEmail(String email, String emailFilename, String specialLink) throws IOException, MessagingException {
        Email bean = Email.getEmail(emailFilename);
        bean.addRecipient(email);
        bean.addArgument(specialLink);
        bean.send();
    }
}

