/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.solr.common.SolrInputDocument;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.SolrServiceIndexPlugin;
import org.dspace.discovery.indexobject.IndexableInProgressSubmission;
import org.dspace.discovery.indexobject.IndexableWorkflowItem;
import org.dspace.discovery.indexobject.IndexableWorkspaceItem;
import org.dspace.supervision.SupervisionOrder;
import org.dspace.supervision.service.SupervisionOrderService;
import org.springframework.beans.factory.annotation.Autowired;

public class SolrServiceSupervisionOrderIndexingPlugin
implements SolrServiceIndexPlugin {
    @Autowired(required=true)
    private SupervisionOrderService supervisionOrderService;

    @Override
    public void additionalIndex(Context context, IndexableObject indexableObject, SolrInputDocument document) {
        try {
            if (!(indexableObject instanceof IndexableWorkspaceItem) && !(indexableObject instanceof IndexableWorkflowItem)) {
                return;
            }
            Item item = ((IndexableInProgressSubmission)indexableObject).getIndexedObject().getItem();
            if (Objects.isNull(item)) {
                return;
            }
            this.addSupervisedField(context, item, document);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void addSupervisedField(Context context, Item item, SolrInputDocument document) throws SQLException {
        List<SupervisionOrder> supervisionOrders = this.supervisionOrderService.findByItem(context, item);
        if (CollectionUtils.isNotEmpty(supervisionOrders)) {
            document.addField("supervised", (Object)true);
        } else {
            document.addField("supervised", (Object)false);
        }
    }
}

