/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.SolrQuery;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.core.Context;
import org.dspace.core.LogHelper;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SolrServiceSearchPlugin;
import org.springframework.beans.factory.annotation.Autowired;

public class SolrServicePrivateItemPlugin
implements SolrServiceSearchPlugin {
    private static final Logger log = LogManager.getLogger((String)SolrServicePrivateItemPlugin.class.getSimpleName());
    @Autowired(required=true)
    protected AuthorizeService authorizeService;
    @Autowired(required=true)
    protected SearchService searchService;

    @Override
    public void additionalSearchParameters(Context context, DiscoverQuery discoveryQuery, SolrQuery solrQuery) {
        try {
            if (this.authorizeService.isAdmin(context)) {
                return;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)discoveryQuery.getDiscoveryConfigurationName(), (CharSequence)"administrativeView")) {
                solrQuery.addFilterQuery(new String[]{"NOT(discoverable:false)"});
                return;
            }
            if (!this.authorizeService.isCommunityAdmin(context) && !this.authorizeService.isCollectionAdmin(context)) {
                solrQuery.addFilterQuery(new String[]{"NOT(discoverable:false)"});
            }
        }
        catch (SQLException ex) {
            log.error(LogHelper.getHeader(context, "Error looking up authorization rights of current user", ""), (Throwable)ex);
        }
    }
}

