/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.common.SolrInputDocument;
import org.apache.tika.utils.StringUtils;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.service.DuplicateDetectionService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.SolrServiceIndexPlugin;
import org.dspace.discovery.indexobject.IndexableItem;
import org.dspace.discovery.indexobject.IndexableWorkflowItem;
import org.dspace.discovery.indexobject.IndexableWorkspaceItem;
import org.dspace.services.ConfigurationService;
import org.dspace.workflow.WorkflowItem;
import org.springframework.beans.factory.annotation.Autowired;

public class SolrServiceIndexComparisonPlugin
implements SolrServiceIndexPlugin {
    @Autowired
    ConfigurationService configurationService;
    @Autowired
    ItemService itemService;
    @Autowired
    DuplicateDetectionService duplicateDetectionService;
    private static final Logger log = LogManager.getLogger(SolrServiceIndexComparisonPlugin.class);

    @Override
    public void additionalIndex(Context context, IndexableObject idxObj, SolrInputDocument document) {
        Item item;
        WorkflowItem workflowItem;
        if (!this.configurationService.getBooleanProperty("duplicate.enable", false)) {
            return;
        }
        if (idxObj instanceof IndexableItem) {
            this.indexItemComparisonValue(context, (Item)((IndexableItem)idxObj).getIndexedObject(), document);
        } else if (idxObj instanceof IndexableWorkspaceItem) {
            Item item2;
            WorkspaceItem workspaceItem = (WorkspaceItem)((IndexableWorkspaceItem)idxObj).getIndexedObject();
            if (workspaceItem != null && (item2 = workspaceItem.getItem()) != null) {
                this.indexItemComparisonValue(context, item2, document);
            }
        } else if (idxObj instanceof IndexableWorkflowItem && (workflowItem = (WorkflowItem)((IndexableWorkflowItem)idxObj).getIndexedObject()) != null && (item = workflowItem.getItem()) != null) {
            this.indexItemComparisonValue(context, item, document);
        }
    }

    private void indexItemComparisonValue(Context context, Item item, SolrInputDocument document) {
        String comparisonValue;
        if (item != null && !StringUtils.isBlank((String)(comparisonValue = this.duplicateDetectionService.buildComparisonValue(context, item)))) {
            document.addField(this.configurationService.getProperty("duplicate.comparison.solr.field", "deduplication_keyword"), (Object)comparisonValue);
        }
    }
}

