/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.curate;

import java.util.Arrays;
import java.util.List;

public final class TaskQueueEntry {
    private final String epersonId;
    private final String submitTime;
    private final String tasks;
    private final String objId;

    public TaskQueueEntry(String epersonId, long submitTime, List<String> taskNames, String objId) {
        this.epersonId = epersonId;
        this.submitTime = Long.toString(submitTime);
        StringBuilder sb = new StringBuilder();
        for (String tName : taskNames) {
            sb.append(tName).append(",");
        }
        this.tasks = sb.substring(0, sb.length() - 1);
        this.objId = objId;
    }

    public TaskQueueEntry(String entry) {
        String[] tokens = entry.split("\\|");
        this.epersonId = tokens[0];
        this.submitTime = tokens[1];
        this.tasks = tokens[2];
        this.objId = tokens[3];
    }

    public String getEpersonId() {
        return this.epersonId;
    }

    public long getSubmitTime() {
        return Long.valueOf(this.submitTime);
    }

    public List<String> getTaskNames() {
        return Arrays.asList(this.tasks.split(","));
    }

    public String getObjectId() {
        return this.objId;
    }

    public String toString() {
        return this.epersonId + "|" + this.submitTime + "|" + this.tasks + "|" + this.objId;
    }
}

