/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.ctask.general;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.curate.AbstractCurationTask;
import org.dspace.curate.Curator;
import org.dspace.curate.Distributive;

@Distributive
public class ProfileFormats
extends AbstractCurationTask {
    protected Map<String, Integer> fmtTable = new HashMap<String, Integer>();
    protected BitstreamFormatService bitstreamFormatService = ContentServiceFactory.getInstance().getBitstreamFormatService();

    @Override
    public int perform(DSpaceObject dso) throws IOException {
        this.fmtTable.clear();
        this.distribute(dso);
        this.formatResults();
        return 0;
    }

    @Override
    protected void performItem(Item item) throws SQLException, IOException {
        for (Bundle bundle : item.getBundles()) {
            for (Bitstream bs : bundle.getBitstreams()) {
                String fmt = bs.getFormat(Curator.curationContext()).getShortDescription();
                Integer count = this.fmtTable.get(fmt);
                count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
                this.fmtTable.put(fmt, count);
            }
        }
    }

    private void formatResults() throws IOException {
        try {
            StringBuilder sb = new StringBuilder();
            for (String fmt : this.fmtTable.keySet()) {
                BitstreamFormat bsf = this.bitstreamFormatService.findByShortDescription(Curator.curationContext(), fmt);
                sb.append(String.format("%6d", this.fmtTable.get(fmt))).append(" (").append(this.bitstreamFormatService.getSupportLevelText(bsf).charAt(0)).append(") ").append(bsf.getDescription()).append("\n");
            }
            this.report(sb.toString());
            this.setResult(sb.toString());
        }
        catch (SQLException sqlE) {
            throw new IOException(sqlE.getMessage(), sqlE);
        }
    }
}

