/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.packager;

import jakarta.servlet.ServletRequest;
import java.util.Enumeration;
import java.util.Properties;

public class PackageParameters
extends Properties {
    protected static final String SEPARATOR = "\u001c";
    protected static final String SEPARATOR_REGEX = "\\034";

    public PackageParameters() {
    }

    public PackageParameters(Properties defaults) {
        super(defaults);
    }

    public static PackageParameters create(ServletRequest request) {
        PackageParameters result = new PackageParameters();
        Enumeration pe = request.getParameterNames();
        while (pe.hasMoreElements()) {
            String name = (String)pe.nextElement();
            String[] v = request.getParameterValues(name);
            if (v.length == 0) {
                result.setProperty(name, "");
                continue;
            }
            if (v.length == 1) {
                result.setProperty(name, v[0]);
                continue;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < v.length; ++i) {
                if (i > 0) {
                    sb.append(SEPARATOR);
                }
                sb.append(v[i]);
            }
            result.setProperty(name, sb.toString());
        }
        return result;
    }

    public Object addProperty(String key, String value) {
        String oldVal = this.getProperty(key);
        if (oldVal == null) {
            this.setProperty(key, value);
        } else {
            this.setProperty(key, oldVal + SEPARATOR + value);
        }
        return oldVal;
    }

    public String[] getProperties(String key) {
        String val = this.getProperty(key);
        if (val == null) {
            return null;
        }
        return val.split(SEPARATOR_REGEX);
    }

    public boolean getBooleanProperty(String key, boolean defaultAnswer) {
        String stringValue = this.getProperty(key);
        if (stringValue == null) {
            return defaultAnswer;
        }
        return stringValue.equalsIgnoreCase("true") || stringValue.equalsIgnoreCase("on") || stringValue.equalsIgnoreCase("yes");
    }

    public boolean workflowEnabled() {
        return this.getBooleanProperty("useWorkflow", true);
    }

    public void setWorkflowEnabled(boolean value) {
        this.addProperty("useWorkflow", String.valueOf(value));
    }

    public boolean restoreModeEnabled() {
        return this.getBooleanProperty("restoreMode", false) || this.replaceModeEnabled() || this.keepExistingModeEnabled();
    }

    public void setRestoreModeEnabled(boolean value) {
        this.addProperty("restoreMode", String.valueOf(value));
    }

    public boolean replaceModeEnabled() {
        return this.getBooleanProperty("replaceMode", false);
    }

    public void setReplaceModeEnabled(boolean value) {
        this.addProperty("replaceMode", String.valueOf(value));
    }

    public boolean keepExistingModeEnabled() {
        return this.getBooleanProperty("keepExistingMode", false);
    }

    public void setKeepExistingModeEnabled(boolean value) {
        this.addProperty("keepExistingMode", String.valueOf(value));
    }

    public boolean useCollectionTemplate() {
        return this.getBooleanProperty("useCollectionTemplate", false);
    }

    public void setUseCollectionTemplate(boolean value) {
        this.addProperty("useCollectionTemplate", String.valueOf(value));
    }

    public boolean recursiveModeEnabled() {
        return this.getBooleanProperty("recursiveMode", false);
    }

    public void setRecursiveModeEnabled(boolean value) {
        this.addProperty("recursiveMode", String.valueOf(value));
    }
}

