/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.logic;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.logic.Filter;
import org.dspace.content.logic.LogicalStatementException;
import org.dspace.content.service.ItemService;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.kernel.ServiceManager;
import org.dspace.services.factory.DSpaceServicesFactory;

public class TestLogicRunner {
    private static Logger log = LogManager.getLogger(TestLogicRunner.class);

    private TestLogicRunner() {
    }

    public static void main(String[] argv) {
        block17: {
            System.out.println("Starting impl of main() test spring logic item filter");
            Options options = new Options();
            options.addOption("h", "help", false, "Help");
            options.addOption("l", "list", false, "List filters");
            options.addOption("f", "filter", true, "Use filter <filter>");
            options.addOption("i", "item", true, "Run filter over item <handle>");
            options.addOption("a", "all", false, "Run filter over all items");
            PosixParser parser = new PosixParser();
            CommandLine line = null;
            HelpFormatter helpformater = new HelpFormatter();
            try {
                line = parser.parse(options, argv);
            }
            catch (ParseException ex) {
                System.out.println(ex.getMessage());
                System.exit(1);
            }
            if (line.hasOption("help")) {
                helpformater.printHelp("\nTest the DSpace logical item filters\n", options);
                System.exit(0);
            }
            Context c = new Context(Context.Mode.READ_ONLY);
            ServiceManager manager = DSpaceServicesFactory.getInstance().getServiceManager();
            if (line.hasOption("list")) {
                List filters = manager.getServicesByType(Filter.class);
                for (Filter filter : filters) {
                    System.out.println(filter.getClass().toString());
                }
                System.out.println("See item-filters.xml spring config for filter names");
                System.exit(0);
            }
            if (line.hasOption("filter")) {
                String filterName = line.getOptionValue("filter");
                Filter filter = (Filter)manager.getServiceByName(filterName, Filter.class);
                if (filter == null) {
                    System.out.println("Error loading filter: " + filterName);
                    System.exit(1);
                }
                if (line.hasOption("item")) {
                    String handle = line.getOptionValue("item");
                    HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
                    try {
                        DSpaceObject dso = handleService.resolveToObject(c, handle);
                        if (Constants.typeText[dso.getType()].equals("ITEM")) {
                            Item item = (Item)dso;
                            System.out.println(filter.getResult(c, item));
                            break block17;
                        }
                        System.out.println(handle + " is not an ITEM");
                    }
                    catch (SQLException | LogicalStatementException e) {
                        System.out.println("Error encountered processing item " + handle + ": " + e.getMessage());
                    }
                } else if (line.hasOption("all")) {
                    ItemService itemService = ContentServiceFactory.getInstance().getItemService();
                    try {
                        Iterator<Item> itemIterator = itemService.findAll(c);
                        while (itemIterator.hasNext()) {
                            Item i = itemIterator.next();
                            System.out.println("Testing '" + filter + "' on item " + i.getHandle() + " ('" + i.getName() + "')");
                            System.out.println(filter.getResult(c, i));
                        }
                    }
                    catch (SQLException | LogicalStatementException e) {
                        System.out.println("Error encountered processing items: " + e.getMessage());
                    }
                } else {
                    helpformater.printHelp("\nTest the DSpace logical item filters\n", options);
                }
            }
        }
    }
}

