/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.dao.impl;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import org.dspace.content.EntityType;
import org.dspace.content.EntityType_;
import org.dspace.content.dao.EntityTypeDAO;
import org.dspace.core.AbstractHibernateDAO;
import org.dspace.core.Context;

public class EntityTypeDAOImpl
extends AbstractHibernateDAO<EntityType>
implements EntityTypeDAO {
    @Override
    public EntityType findByEntityType(Context context, String entityType) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<EntityType> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, EntityType.class);
        Root entityTypeRoot = criteriaQuery.from(EntityType.class);
        criteriaQuery.select((Selection)entityTypeRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal(criteriaBuilder.upper((Expression)entityTypeRoot.get(EntityType_.label)), (Object)entityType.toUpperCase()));
        return this.uniqueResult(context, criteriaQuery, true, EntityType.class);
    }

    @Override
    public List<EntityType> getEntityTypesByNames(Context context, List<String> names, Integer limit, Integer offset) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<EntityType> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, EntityType.class);
        Root entityTypeRoot = criteriaQuery.from(EntityType.class);
        LinkedList<Order> orderList = new LinkedList<Order>();
        orderList.add(criteriaBuilder.desc((Expression)entityTypeRoot.get(EntityType_.label)));
        criteriaQuery.select((Selection)entityTypeRoot).orderBy(orderList);
        criteriaQuery.where((Expression)entityTypeRoot.get("label").in(names));
        return this.list(context, criteriaQuery, false, EntityType.class, limit, offset);
    }

    @Override
    public int countEntityTypesByNames(Context context, List<String> names) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Long.class);
        Root entityTypeRoot = criteriaQuery.from(EntityType.class);
        criteriaQuery.select((Selection)criteriaBuilder.count((Expression)entityTypeRoot));
        criteriaQuery.where((Expression)entityTypeRoot.get("label").in(names));
        return this.count(context, criteriaQuery, criteriaBuilder, entityTypeRoot);
    }
}

