/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import org.dspace.content.Item;
import org.dspace.content.RelationshipType;
import org.dspace.core.ReloadableEntity;
import org.hibernate.annotations.JdbcTypeCode;

@Entity
@Table(name="relationship")
public class Relationship
implements ReloadableEntity<Integer> {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="relationship_id_seq")
    @SequenceGenerator(name="relationship_id_seq", sequenceName="relationship_id_seq", allocationSize=1)
    @Column(name="id", unique=true, nullable=false, insertable=true, updatable=false)
    protected Integer id;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="left_id", nullable=false)
    private Item leftItem;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="type_id", nullable=false)
    private RelationshipType relationshipType;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="right_id", nullable=false)
    private Item rightItem;
    @Column(name="left_place")
    private int leftPlace;
    @Column(name="right_place")
    private int rightPlace;
    @Column(name="leftward_value")
    private String leftwardValue;
    @Column(name="rightward_value")
    private String rightwardValue;
    @Column(name="latest_version_status")
    @JdbcTypeCode(value=4)
    private LatestVersionStatus latestVersionStatus = LatestVersionStatus.BOTH;

    protected Relationship() {
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Item getLeftItem() {
        return this.leftItem;
    }

    public void setLeftItem(Item leftItem) {
        this.leftItem = leftItem;
    }

    public RelationshipType getRelationshipType() {
        return this.relationshipType;
    }

    public void setRelationshipType(RelationshipType relationshipType) {
        this.relationshipType = relationshipType;
    }

    public Item getRightItem() {
        return this.rightItem;
    }

    public void setRightItem(Item rightItem) {
        this.rightItem = rightItem;
    }

    public int getLeftPlace() {
        return this.leftPlace;
    }

    public void setLeftPlace(int leftPlace) {
        this.leftPlace = leftPlace;
        this.leftItem.setMetadataModified();
    }

    public int getRightPlace() {
        return this.rightPlace;
    }

    public void setRightPlace(int rightPlace) {
        this.rightPlace = rightPlace;
        this.rightItem.setMetadataModified();
    }

    public String getLeftwardValue() {
        return this.leftwardValue;
    }

    public void setLeftwardValue(String leftwardValue) {
        this.leftwardValue = leftwardValue;
    }

    public String getRightwardValue() {
        return this.rightwardValue;
    }

    public void setRightwardValue(String rightwardValue) {
        this.rightwardValue = rightwardValue;
    }

    public LatestVersionStatus getLatestVersionStatus() {
        return this.latestVersionStatus;
    }

    public void setLatestVersionStatus(LatestVersionStatus latestVersionStatus) {
        if (this.latestVersionStatus == latestVersionStatus) {
            return;
        }
        this.latestVersionStatus = latestVersionStatus;
        this.leftItem.setMetadataModified();
        this.rightItem.setMetadataModified();
    }

    @Override
    public Integer getID() {
        return this.id;
    }

    public static enum LatestVersionStatus {
        BOTH,
        LEFT_ONLY,
        RIGHT_ONLY;

    }
}

