/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authorize;

import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.GroupService;

public class PolicySet {
    private static final AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    private static final ResourcePolicyService resourcePolicyService = AuthorizeServiceFactory.getInstance().getResourcePolicyService();
    private static final ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    private static final CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    private static final GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();

    private PolicySet() {
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length < 6) {
            System.out.println("Args: containerType containerID contentType actionID groupID command [filter]");
            System.out.println("container=COLLECTION command = ADD|REPLACE");
            return;
        }
        int containertype = Integer.parseInt(argv[0]);
        UUID containerID = UUID.fromString(argv[1]);
        int contenttype = Integer.parseInt(argv[2]);
        int actionID = Integer.parseInt(argv[3]);
        UUID groupID = UUID.fromString(argv[4]);
        boolean isReplace = false;
        String command = argv[5];
        String filter = null;
        if (argv.length == 7) {
            filter = argv[6];
        }
        if (command.equals("REPLACE")) {
            isReplace = true;
        }
        Context c = new Context();
        c.turnOffAuthorisationSystem();
        PolicySet.setPoliciesFilter(c, containertype, containerID, contenttype, actionID, groupID, isReplace, false, filter);
        c.complete();
        System.exit(0);
    }

    public static void setPolicies(Context c, int containerType, UUID containerID, int contentType, int actionID, UUID groupID, boolean isReplace, boolean clearOnly) throws SQLException, AuthorizeException {
        PolicySet.setPoliciesFilter(c, containerType, containerID, contentType, actionID, groupID, isReplace, clearOnly, null, null, null, null, null);
    }

    public static void setPolicies(Context c, int containerType, UUID containerID, int contentType, int actionID, UUID groupID, boolean isReplace, boolean clearOnly, String name, String description, LocalDate startDate, LocalDate endDate) throws SQLException, AuthorizeException {
        PolicySet.setPoliciesFilter(c, containerType, containerID, contentType, actionID, groupID, isReplace, clearOnly, null, name, description, startDate, endDate);
    }

    public static void setPoliciesFilter(Context c, int containerType, UUID containerID, int contentType, int actionID, UUID groupID, boolean isReplace, boolean clearOnly, String filter) throws SQLException, AuthorizeException {
        PolicySet.setPoliciesFilter(c, containerType, containerID, contentType, actionID, groupID, isReplace, clearOnly, filter, null, null, null, null);
    }

    public static void setPoliciesFilter(Context c, int containerType, UUID containerID, int contentType, int actionID, UUID groupID, boolean isReplace, boolean clearOnly, String filter, String name, String description, LocalDate startDate, LocalDate endDate) throws SQLException, AuthorizeException {
        block9: {
            Iterator<Item> i;
            Group group;
            block11: {
                block10: {
                    if (containerType != 3) break block9;
                    Collection collection = (Collection)collectionService.find(c, containerID);
                    group = (Group)groupService.find(c, groupID);
                    i = itemService.findAllByCollection(c, collection);
                    if (contentType != 2) break block10;
                    while (i.hasNext()) {
                        Item myitem = i.next();
                        if (isReplace || clearOnly) {
                            authorizeService.removeAllPolicies(c, myitem);
                        }
                        if (clearOnly || authorizeService.isAnIdenticalPolicyAlreadyInPlace(c, myitem, group, actionID, -1)) continue;
                        ResourcePolicy rp = resourcePolicyService.create(c, null, group);
                        rp.setdSpaceObject(myitem);
                        rp.setAction(actionID);
                        rp.setRpName(name);
                        rp.setRpDescription(description);
                        rp.setStartDate(startDate);
                        rp.setEndDate(endDate);
                        resourcePolicyService.update(c, rp);
                    }
                    break block9;
                }
                if (contentType != 1) break block11;
                while (i.hasNext()) {
                    Item myitem = i.next();
                    List<Bundle> bundles = myitem.getBundles();
                    for (Bundle bundle : bundles) {
                        if (isReplace || clearOnly) {
                            authorizeService.removeAllPolicies(c, bundle);
                        }
                        if (clearOnly || authorizeService.isAnIdenticalPolicyAlreadyInPlace(c, bundle, group, actionID, -1)) continue;
                        ResourcePolicy rp = resourcePolicyService.create(c, null, group);
                        rp.setdSpaceObject(bundle);
                        rp.setAction(actionID);
                        rp.setRpName(name);
                        rp.setRpDescription(description);
                        rp.setStartDate(startDate);
                        rp.setEndDate(endDate);
                        resourcePolicyService.update(c, rp);
                    }
                }
                break block9;
            }
            if (contentType != 0) break block9;
            while (i.hasNext()) {
                Item myitem = i.next();
                System.out.println("Item " + myitem.getID());
                List<Bundle> bundles = myitem.getBundles();
                for (Bundle bundle : bundles) {
                    System.out.println("Bundle " + bundle.getID());
                    List<Bitstream> bitstreams = bundle.getBitstreams();
                    for (Bitstream bitstream : bitstreams) {
                        if (filter != null && bitstream.getName().indexOf(filter) == -1) continue;
                        if (isReplace || clearOnly) {
                            authorizeService.removeAllPolicies(c, bitstream);
                        }
                        if (clearOnly || authorizeService.isAnIdenticalPolicyAlreadyInPlace(c, bitstream, group, actionID, -1)) continue;
                        ResourcePolicy rp = resourcePolicyService.create(c, null, group);
                        rp.setdSpaceObject(bitstream);
                        rp.setAction(actionID);
                        rp.setRpName(name);
                        rp.setRpDescription(description);
                        rp.setStartDate(startDate);
                        rp.setEndDate(endDate);
                        resourcePolicyService.update(c, rp);
                    }
                }
            }
        }
    }
}

