/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.suggestion;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.solr.client.solrj.SolrServerException;
import org.dspace.app.suggestion.Suggestion;
import org.dspace.app.suggestion.SuggestionTarget;
import org.dspace.core.Context;

public interface SolrSuggestionStorageService {
    public static final String SOURCE = "source";
    public static final String SUGGESTION_FULLID = "suggestion_fullid";
    public static final String SUGGESTION_ID = "suggestion_id";
    public static final String TARGET_ID = "target_id";
    public static final String TITLE = "title";
    public static final String DATE = "date";
    public static final String DISPLAY = "display";
    public static final String CONTRIBUTORS = "contributors";
    public static final String ABSTRACT = "abstract";
    public static final String CATEGORY = "category";
    public static final String EXTERNAL_URI = "external-uri";
    public static final String PROCESSED = "processed";
    public static final String SCORE = "trust";
    public static final String EVIDENCES = "evidences";

    public void addSuggestion(Suggestion var1, boolean var2, boolean var3) throws SolrServerException, IOException;

    public boolean exist(Suggestion var1) throws SolrServerException, IOException;

    public void deleteSuggestion(Suggestion var1) throws SolrServerException, IOException;

    public void flagSuggestionAsProcessed(Suggestion var1) throws SolrServerException, IOException;

    public void deleteTarget(SuggestionTarget var1) throws SolrServerException, IOException;

    public void commit() throws SolrServerException, IOException;

    public void flagAllSuggestionAsProcessed(String var1, String var2) throws SolrServerException, IOException;

    public long countAllTargets(Context var1, String var2) throws SolrServerException, IOException;

    public long countUnprocessedSuggestionByTarget(Context var1, String var2, UUID var3) throws SolrServerException, IOException;

    public List<Suggestion> findAllUnprocessedSuggestions(Context var1, String var2, UUID var3, int var4, long var5, boolean var7) throws SolrServerException, IOException;

    public List<SuggestionTarget> findAllTargets(Context var1, String var2, int var3, long var4) throws SolrServerException, IOException;

    public Suggestion findUnprocessedSuggestion(Context var1, String var2, UUID var3, String var4) throws SolrServerException, IOException;

    public SuggestionTarget findTarget(Context var1, String var2, UUID var3) throws SolrServerException, IOException;
}

