/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.ldn.utility;

import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LDNUtils {
    private static final Pattern UUID_REGEX_PATTERN = Pattern.compile("\\p{XDigit}{8}-\\p{XDigit}{4}-\\p{XDigit}{4}-\\p{XDigit}{4}-\\p{XDigit}{12}");
    private static final String SIMPLE_PROTOCOL_REGEX = "^(http[s]?://www\\.|http[s]?://|www\\.)";

    private LDNUtils() {
    }

    public static boolean hasUUIDInURL(String url) {
        Matcher matcher = UUID_REGEX_PATTERN.matcher(url);
        return matcher.find();
    }

    public static UUID getUUIDFromURL(String url) {
        Matcher matcher = UUID_REGEX_PATTERN.matcher(url);
        StringBuilder handle = new StringBuilder();
        if (matcher.find()) {
            handle.append(matcher.group(0));
        }
        return UUID.fromString(handle.toString());
    }

    public static String removedProtocol(String url) {
        return url.replaceFirst(SIMPLE_PROTOCOL_REGEX, "");
    }

    public static String processContextResolverId(String value) {
        String resolverId = value;
        resolverId = resolverId.replace("https://doi.org/", "doi:");
        return resolverId;
    }

    public static String getNotifyType(String coarNotifyType) {
        String justNotifyType = coarNotifyType;
        justNotifyType = justNotifyType.substring(justNotifyType.lastIndexOf(":") + 1);
        justNotifyType = justNotifyType.replace("Action", "");
        return justNotifyType;
    }
}

