/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.ldn.processor;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.http.client.HttpResponseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.ldn.LDNMessageEntity;
import org.dspace.app.ldn.action.LDNAction;
import org.dspace.app.ldn.action.LDNActionStatus;
import org.dspace.app.ldn.model.Notification;
import org.dspace.app.ldn.processor.LDNContextRepeater;
import org.dspace.app.ldn.processor.LDNProcessor;
import org.dspace.app.ldn.service.LDNMessageService;
import org.dspace.app.ldn.utility.LDNUtils;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.handle.service.HandleService;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;

public class LDNMetadataProcessor
implements LDNProcessor {
    private static final Logger log = LogManager.getLogger(LDNMetadataProcessor.class);
    @Autowired
    private ItemService itemService;
    @Autowired
    private LDNMessageService ldnMessageService;
    @Autowired
    private ConfigurationService configurationService;
    private static final Set<String> OBJECT_SUBJECT_ITEM_TYPES = Set.of("Announce", "coar-notify:RelationshipAction");
    private static final Set<String> CONTEXT_ID_ITEM_TYPES = Set.of("Announce", "TentativeReject", "Accept", "TentativeAccept", "Reject", "coar-notify:ReviewAction", "coar-notify:IngestAction", "coar-notify:EndorsementAction");
    private static final Set<String> OBJECT_ID_ITEM_TYPES = Set.of("Offer", "coar-notify:ReviewAction", "coar-notify:EndorsementAction", "coar-notify:IngestAction");
    @Autowired
    private HandleService handleService;
    private LDNContextRepeater repeater = new LDNContextRepeater();
    private List<LDNAction> actions = new ArrayList<LDNAction>();

    private LDNMetadataProcessor() {
    }

    @Override
    public void process(Context context, Notification notification) throws Exception {
        Item item = this.lookupItem(context, notification);
        this.runActions(context, notification, item);
    }

    private LDNActionStatus runActions(Context context, Notification notification, Item item) throws Exception {
        LDNActionStatus operation = LDNActionStatus.CONTINUE;
        for (LDNAction action : this.actions) {
            log.info("Running action {} for notification {} {}", (Object)action.getClass().getSimpleName(), (Object)notification.getId(), notification.getType());
            operation = action.execute(context, notification, item);
            if (operation != LDNActionStatus.ABORT) continue;
            break;
        }
        return operation;
    }

    public LDNContextRepeater getRepeater() {
        return this.repeater;
    }

    public void setRepeater(LDNContextRepeater repeater) {
        this.repeater = repeater;
    }

    public List<LDNAction> getActions() {
        return this.actions;
    }

    public void setActions(List<LDNAction> actions) {
        this.actions = actions;
    }

    private Item lookupItem(Context context, Notification notification) throws SQLException, HttpResponseException {
        Item item = null;
        Object url = null;
        if (CONTEXT_ID_ITEM_TYPES.containsAll(notification.getType())) {
            LDNMessageEntity inReplyToldnMessageEntity;
            if (notification.getContext() != null) {
                url = notification.getContext().getId();
            } else if (notification.getInReplyTo() != null && (inReplyToldnMessageEntity = this.ldnMessageService.find(context, notification.getInReplyTo())) != null) {
                String dspaceUrl = this.configurationService.getProperty("dspace.ui.url") + "/handle/";
                url = dspaceUrl + inReplyToldnMessageEntity.getObject().getHandle();
                LDNMessageEntity ldnMessageEntity = this.ldnMessageService.find(context, notification.getId());
                ldnMessageEntity.setContext(inReplyToldnMessageEntity.getObject());
                this.ldnMessageService.update(context, ldnMessageEntity);
            }
        } else if (OBJECT_ID_ITEM_TYPES.containsAll(notification.getType())) {
            url = notification.getObject().getId();
        } else if (OBJECT_SUBJECT_ITEM_TYPES.containsAll(notification.getType())) {
            url = this.ldnMessageService.isTargetCurrent(notification) ? notification.getObject().getAsObject() : notification.getObject().getAsSubject();
        }
        log.info("Looking up item {}", url);
        item = this.resolveItemByUrl(context, (String)url, notification);
        return item;
    }

    private Item resolveItemByUrl(Context context, String url, Notification notification) throws SQLException, HttpResponseException {
        Item item = null;
        if (LDNUtils.hasUUIDInURL(url)) {
            UUID uuid = LDNUtils.getUUIDFromURL(url);
            item = (Item)this.itemService.find(context, uuid);
            if (Objects.isNull(item)) {
                throw new HttpResponseException(404, String.format("Item with uuid %s not found", uuid));
            }
            return item;
        }
        String handle = this.handleService.resolveUrlToHandle(context, url);
        if (Objects.isNull(handle)) {
            throw new HttpResponseException(404, String.format("Handle not found for %s", url));
        }
        DSpaceObject object = this.handleService.resolveToObject(context, handle);
        if (Objects.isNull(object)) {
            throw new HttpResponseException(404, String.format("Item with handle %s not found", handle));
        }
        if (object.getType() != 2) {
            throw new HttpResponseException(422, String.format("Handle %s does not resolve to an item", handle));
        }
        item = (Item)object;
        return item;
    }
}

