/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.ldn.processor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.ldn.model.Context;
import org.dspace.app.ldn.model.Notification;

public class LDNContextRepeater {
    private static final Logger log = LogManager.getLogger(LDNContextRepeater.class);
    private static final String CONTEXT = "context";
    private String repeatOver;

    public String getRepeatOver() {
        return this.repeatOver;
    }

    public void setRepeatOver(String repeatOver) {
        this.repeatOver = repeatOver;
    }

    public Iterator<Notification> iterator(Notification notification) {
        return new NotificationIterator(notification, this.repeatOver);
    }

    private class NotificationIterator
    implements Iterator<Notification> {
        private final List<Notification> notifications = new ArrayList<Notification>();

        private NotificationIterator(Notification notification, String repeatOver) {
            if (Objects.nonNull(repeatOver)) {
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode notificationNode = objectMapper.valueToTree((Object)notification);
                log.debug("Notification {}", (Object)notificationNode);
                JsonNode topContextNode = notificationNode.get(LDNContextRepeater.CONTEXT);
                if (topContextNode.isNull()) {
                    log.warn("Notification is missing context");
                    return;
                }
                JsonNode contextArrayNode = topContextNode.get(repeatOver);
                if (contextArrayNode == null || contextArrayNode.isNull()) {
                    log.error("Notification context {} is not defined", (Object)repeatOver);
                    return;
                }
                if (contextArrayNode.isArray()) {
                    for (JsonNode contextNode : (ArrayNode)contextArrayNode) {
                        try {
                            Context context = (Context)objectMapper.treeToValue((TreeNode)contextNode, Context.class);
                            Notification copy = (Notification)objectMapper.treeToValue((TreeNode)notificationNode, Notification.class);
                            copy.setContext(context);
                            this.notifications.add(copy);
                        }
                        catch (JsonProcessingException e) {
                            log.error("Failed to copy notification");
                        }
                    }
                } else {
                    log.error("Notification context {} is not an array", (Object)repeatOver);
                }
            } else {
                this.notifications.add(notification);
            }
        }

        @Override
        public boolean hasNext() {
            return !this.notifications.isEmpty();
        }

        @Override
        public Notification next() {
            return this.notifications.remove(0);
        }
    }
}

