/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.administer;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dspace.administer.RegistryExportException;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.content.service.MetadataSchemaService;
import org.dspace.core.Context;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class MetadataExporter {
    protected static MetadataSchemaService metadataSchemaService = ContentServiceFactory.getInstance().getMetadataSchemaService();
    protected static MetadataFieldService metadataFieldService = ContentServiceFactory.getInstance().getMetadataFieldService();
    static Map<Integer, String> schemaMap = new HashMap<Integer, String>();

    private MetadataExporter() {
    }

    public static void main(String[] args) throws ParseException, SQLException, IOException, RegistryExportException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        DefaultParser parser = new DefaultParser();
        Options options = new Options();
        options.addOption("f", "file", true, "output xml file for registry");
        options.addOption("s", "schema", true, "the name of the schema to export");
        CommandLine line = parser.parse(options, args);
        String file = null;
        String schema = null;
        if (line.hasOption('f')) {
            file = line.getOptionValue('f');
        } else {
            MetadataExporter.usage();
            System.exit(0);
        }
        if (line.hasOption('s')) {
            schema = line.getOptionValue('s');
        }
        MetadataExporter.saveRegistry(file, schema);
    }

    public static void saveRegistry(String file, String schema) throws SQLException, IOException, RegistryExportException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Context context = new Context();
        context.turnOffAuthorisationSystem();
        Document document = DOMImplementationRegistry.newInstance().getDOMImplementation("XML 3.0").createDocument(null, "dspace-dc-types", null);
        MetadataExporter.saveSchema(context, document, schema);
        List<MetadataField> mdFields = null;
        if (schema != null && !"".equals(schema)) {
            MetadataSchema mdSchema = metadataSchemaService.find(context, schema);
            if (mdSchema == null) {
                throw new RegistryExportException("no schema to export");
            }
            mdFields = metadataFieldService.findAllInSchema(context, mdSchema);
        } else {
            mdFields = metadataFieldService.findAll(context);
        }
        for (MetadataField mdField : mdFields) {
            MetadataExporter.saveType(context, document, mdField);
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            DOMImplementationLS lsImplementation = (DOMImplementationLS)((Object)DOMImplementationRegistry.newInstance().getDOMImplementation("LS"));
            LSSerializer serializer = lsImplementation.createLSSerializer();
            DOMConfiguration configuration = serializer.getDomConfig();
            configuration.setParameter("format-pretty-print", true);
            LSOutput lsOutput = lsImplementation.createLSOutput();
            lsOutput.setEncoding("UTF-8");
            lsOutput.setCharacterStream(writer);
            serializer.write(document, lsOutput);
        }
        context.abort();
    }

    public static void saveSchema(Context context, Document document, String schema) throws SQLException, RegistryExportException {
        if (schema != null && !"".equals(schema)) {
            MetadataSchema mdSchema = metadataSchemaService.find(context, schema);
            MetadataExporter.saveSchema(document, mdSchema);
        } else {
            List<MetadataSchema> mdSchemas = metadataSchemaService.findAll(context);
            for (MetadataSchema mdSchema : mdSchemas) {
                MetadataExporter.saveSchema(document, mdSchema);
            }
        }
    }

    private static void saveSchema(Document document, MetadataSchema mdSchema) throws RegistryExportException {
        if (mdSchema == null) {
            throw new RegistryExportException("no schema to export");
        }
        String name = mdSchema.getName();
        String namespace = mdSchema.getNamespace();
        if (name == null || "".equals(name)) {
            System.out.println("name is null, skipping");
            return;
        }
        if (namespace == null || "".equals(namespace)) {
            System.out.println("namespace is null, skipping");
            return;
        }
        Element document_element = document.getDocumentElement();
        Element schema_element = document.createElement("dc-schema");
        document_element.appendChild(schema_element);
        Element name_element = document.createElement("name");
        schema_element.appendChild(name_element);
        name_element.setTextContent(name);
        Element namespace_element = document.createElement("namespace");
        schema_element.appendChild(namespace_element);
        namespace_element.setTextContent(namespace);
    }

    private static void saveType(Context context, Document document, MetadataField mdField) throws RegistryExportException, SQLException {
        if (mdField == null) {
            throw new RegistryExportException("no field to export");
        }
        String schemaName = MetadataExporter.getSchemaName(context, mdField);
        String element = mdField.getElement();
        String qualifier = mdField.getQualifier();
        String scopeNote = mdField.getScopeNote();
        if (schemaName == null || element == null) {
            throw new RegistryExportException("incomplete field information");
        }
        Element document_element = document.getDocumentElement();
        Element dc_type = document.createElement("dc-type");
        document_element.appendChild(dc_type);
        Element schema_element = document.createElement("schema");
        dc_type.appendChild(schema_element);
        schema_element.setTextContent(schemaName);
        Element element_element = document.createElement("element");
        dc_type.appendChild(element_element);
        element_element.setTextContent(element);
        if (qualifier != null) {
            Element qualifier_element = document.createElement("qualifier");
            dc_type.appendChild(qualifier_element);
            qualifier_element.setTextContent(qualifier);
        } else {
            dc_type.appendChild(document.createComment("unqualified"));
        }
        if (scopeNote != null) {
            Element scope_element = document.createElement("scope_note");
            dc_type.appendChild(scope_element);
            scope_element.setTextContent(scopeNote);
        } else {
            dc_type.appendChild(document.createComment("no scope note"));
        }
    }

    private static String getSchemaName(Context context, MetadataField mdField) throws SQLException, RegistryExportException {
        String name = schemaMap.get(mdField.getMetadataSchema().getID());
        if (name == null) {
            MetadataSchema mdSchema = metadataSchemaService.find(context, mdField.getMetadataSchema().getID());
            if (mdSchema != null) {
                name = mdSchema.getName();
                schemaMap.put(mdSchema.getID(), name);
            } else {
                throw new RegistryExportException("Can't get schema name for field");
            }
        }
        return name;
    }

    public static void usage() {
        String usage = "Use this class with the following options:\n -f <xml output file> : specify the output file for the schemas\n -s <schema> : name of the schema to export\n";
        System.out.println(usage);
    }
}

