/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.orcid.service.impl;

import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.EnumUtils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.indexobject.IndexableItem;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.service.EPersonService;
import org.dspace.orcid.OrcidToken;
import org.dspace.orcid.client.OrcidClient;
import org.dspace.orcid.model.OrcidEntityType;
import org.dspace.orcid.model.OrcidTokenResponseDTO;
import org.dspace.orcid.service.OrcidSynchronizationService;
import org.dspace.orcid.service.OrcidTokenService;
import org.dspace.profile.OrcidEntitySyncPreference;
import org.dspace.profile.OrcidProfileDisconnectionMode;
import org.dspace.profile.OrcidProfileSyncPreference;
import org.dspace.profile.OrcidSynchronizationMode;
import org.dspace.profile.service.ResearcherProfileService;
import org.dspace.services.ConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class OrcidSynchronizationServiceImpl
implements OrcidSynchronizationService {
    private static final Logger log = LoggerFactory.getLogger(OrcidSynchronizationServiceImpl.class);
    @Autowired
    private ItemService itemService;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private EPersonService ePersonService;
    @Autowired
    private SearchService searchService;
    @Autowired
    private OrcidTokenService orcidTokenService;
    @Autowired
    private ResearcherProfileService researcherProfileService;
    @Autowired
    private OrcidClient orcidClient;

    @Override
    public void linkProfile(Context context, Item profile, OrcidTokenResponseDTO token) throws SQLException {
        EPerson ePerson = this.ePersonService.findByProfileItem(context, profile);
        if (ePerson == null) {
            throw new IllegalArgumentException("The given profile item is not related to any eperson. Item id: " + profile.getID());
        }
        String orcid = token.getOrcid();
        String accessToken = token.getAccessToken();
        String[] scopes = token.getScopeAsArray();
        this.itemService.setMetadataSingleValue(context, profile, "person", "identifier", "orcid", null, orcid);
        this.itemService.clearMetadata(context, profile, "dspace", "orcid", "scope", "*");
        for (String scope : scopes) {
            this.itemService.addMetadata(context, profile, "dspace", "orcid", "scope", null, scope);
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.itemService.getMetadataFirstValue(profile, "dspace", "orcid", "authenticated", "*"))) {
            String currentDate = DateTimeFormatter.ISO_DATE_TIME.format(LocalDateTime.now());
            this.itemService.setMetadataSingleValue(context, profile, "dspace", "orcid", "authenticated", null, currentDate);
        }
        this.setAccessToken(context, profile, ePerson, accessToken);
        EPerson ePersonByOrcid = this.ePersonService.findByNetid(context, orcid);
        if (ePersonByOrcid == null && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)ePerson.getNetid())) {
            ePerson.setNetid(orcid);
            this.updateEPerson(context, ePerson);
        }
        this.updateItem(context, profile);
    }

    @Override
    public void unlinkProfile(Context context, Item profile) throws SQLException {
        this.clearOrcidProfileMetadata(context, profile);
        this.clearSynchronizationSettings(context, profile);
        this.clearOrcidToken(context, profile);
        this.updateItem(context, profile);
    }

    private void clearOrcidToken(Context context, Item profile) {
        OrcidToken profileToken = this.orcidTokenService.findByProfileItem(context, profile);
        if (profileToken == null) {
            log.warn("Cannot find any token related to the user profile: {}", (Object)profile.getID());
            return;
        }
        this.orcidTokenService.deleteByProfileItem(context, profile);
        this.orcidClient.revokeToken(profileToken);
    }

    private void clearOrcidProfileMetadata(Context context, Item profile) throws SQLException {
        this.itemService.clearMetadata(context, profile, "person", "identifier", "orcid", "*");
        this.itemService.clearMetadata(context, profile, "dspace", "orcid", "scope", "*");
        this.itemService.clearMetadata(context, profile, "dspace", "orcid", "authenticated", "*");
    }

    @Override
    public boolean setEntityPreference(Context context, Item profile, OrcidEntityType type, OrcidEntitySyncPreference value) throws SQLException {
        String metadataQualifier = "sync-" + type.name().toLowerCase() + "s";
        return this.updatePreferenceForSynchronizingWithOrcid(context, profile, metadataQualifier, List.of(value.name()));
    }

    @Override
    public boolean setProfilePreference(Context context, Item profile, List<OrcidProfileSyncPreference> values) throws SQLException {
        List<String> valuesAsString = values.stream().map(Enum::name).collect(Collectors.toList());
        return this.updatePreferenceForSynchronizingWithOrcid(context, profile, "sync-profile", valuesAsString);
    }

    @Override
    public boolean setSynchronizationMode(Context context, Item profile, OrcidSynchronizationMode value) throws SQLException {
        if (!this.isLinkedToOrcid(context, profile)) {
            throw new IllegalArgumentException("The given profile cannot be configured for the ORCID synchronization because it is not linked to any ORCID account: " + profile.getID());
        }
        String newValue = value.name();
        String oldValue = this.itemService.getMetadataFirstValue(profile, "dspace", "orcid", "sync-mode", "*");
        if (StringUtils.equals((CharSequence)oldValue, (CharSequence)newValue)) {
            return false;
        }
        this.itemService.setMetadataSingleValue(context, profile, "dspace", "orcid", "sync-mode", null, value.name());
        return true;
    }

    @Override
    public boolean isSynchronizationAllowed(Item profile, Item item) {
        if (this.isOrcidSynchronizationDisabled()) {
            return false;
        }
        String entityType = this.itemService.getEntityTypeLabel(item);
        if (entityType == null) {
            return false;
        }
        if (OrcidEntityType.isValidEntityType(entityType)) {
            return this.getEntityPreference(profile, OrcidEntityType.fromEntityType(entityType)).filter(pref -> pref != OrcidEntitySyncPreference.DISABLED).isPresent();
        }
        if (entityType.equals(this.researcherProfileService.getProfileType())) {
            return profile.equals(item) && !CollectionUtils.isEmpty(this.getProfilePreferences(profile));
        }
        return false;
    }

    @Override
    public Optional<OrcidSynchronizationMode> getSynchronizationMode(Item item) {
        return this.getMetadataValue(item, "dspace.orcid.sync-mode").map(metadataValue -> metadataValue.getValue()).filter(value -> EnumUtils.isValidEnum(OrcidSynchronizationMode.class, (String)value)).map(value -> OrcidSynchronizationMode.valueOf(value));
    }

    @Override
    public Optional<OrcidEntitySyncPreference> getEntityPreference(Item item, OrcidEntityType entityType) {
        return this.getMetadataValue(item, "dspace.orcid.sync-" + entityType.name().toLowerCase() + "s").map(metadataValue -> metadataValue.getValue()).filter(value -> EnumUtils.isValidEnum(OrcidEntitySyncPreference.class, (String)value)).map(value -> OrcidEntitySyncPreference.valueOf(value));
    }

    @Override
    public List<OrcidProfileSyncPreference> getProfilePreferences(Item item) {
        return this.getMetadataValues(item, "dspace.orcid.sync-profile").map(MetadataValue::getValue).filter(value -> EnumUtils.isValidEnum(OrcidProfileSyncPreference.class, (String)value)).map(value -> OrcidProfileSyncPreference.valueOf(value)).collect(Collectors.toList());
    }

    @Override
    public boolean isLinkedToOrcid(Context context, Item item) {
        return this.getOrcidAccessToken(context, item).isPresent() && this.getOrcid(item).isPresent();
    }

    @Override
    public OrcidProfileDisconnectionMode getDisconnectionMode() {
        String value = this.configurationService.getProperty("orcid.disconnection.allowed-users");
        if (!OrcidProfileDisconnectionMode.isValid(value)) {
            return OrcidProfileDisconnectionMode.DISABLED;
        }
        return OrcidProfileDisconnectionMode.fromString(value);
    }

    private void setAccessToken(Context context, Item profile, EPerson ePerson, String accessToken) {
        OrcidToken orcidToken = this.orcidTokenService.findByEPerson(context, ePerson);
        if (orcidToken == null) {
            this.orcidTokenService.create(context, ePerson, profile, accessToken);
        } else {
            orcidToken.setProfileItem(profile);
            orcidToken.setAccessToken(accessToken);
        }
    }

    private boolean updatePreferenceForSynchronizingWithOrcid(Context context, Item profile, String metadataQualifier, List<String> values) throws SQLException {
        if (!this.isLinkedToOrcid(context, profile)) {
            throw new IllegalArgumentException("The given profile cannot be configured for the ORCID synchronization because it is not linked to any ORCID account: " + profile.getID());
        }
        List<String> oldValues = this.itemService.getMetadata(profile, "dspace", "orcid", metadataQualifier, "*").stream().map(metadataValue -> metadataValue.getValue()).collect(Collectors.toList());
        if (this.containsSameValues(oldValues, values)) {
            return false;
        }
        this.itemService.clearMetadata(context, profile, "dspace", "orcid", metadataQualifier, "*");
        for (String value : values) {
            this.itemService.addMetadata(context, profile, "dspace", "orcid", metadataQualifier, null, value);
        }
        return true;
    }

    private void clearSynchronizationSettings(Context context, Item profile) throws SQLException {
        if (this.configurationService.getBooleanProperty("orcid.disconnection.remain-sync", false)) {
            return;
        }
        this.itemService.clearMetadata(context, profile, "dspace", "orcid", "sync-mode", "*");
        this.itemService.clearMetadata(context, profile, "dspace", "orcid", "sync-profile", "*");
        for (OrcidEntityType entityType : OrcidEntityType.values()) {
            this.itemService.clearMetadata(context, profile, "dspace", "orcid", "sync-" + entityType.name().toLowerCase() + "s", "*");
        }
    }

    private boolean containsSameValues(List<String> firstList, List<String> secondList) {
        return new HashSet<String>(firstList).equals(new HashSet<String>(secondList));
    }

    private Optional<String> getOrcidAccessToken(Context context, Item item) {
        return Optional.ofNullable(this.orcidTokenService.findByProfileItem(context, item)).map(orcidToken -> orcidToken.getAccessToken());
    }

    public Optional<String> getOrcid(Item item) {
        return this.getMetadataValue(item, "person.identifier.orcid").map(metadataValue -> metadataValue.getValue());
    }

    private Optional<MetadataValue> getMetadataValue(Item item, String metadataField) {
        return this.getMetadataValues(item, metadataField).findFirst();
    }

    private Stream<MetadataValue> getMetadataValues(Item item, String metadataField) {
        return item.getMetadata().stream().filter(metadata -> metadataField.equals(metadata.getMetadataField().toString('.')));
    }

    private boolean isOrcidSynchronizationDisabled() {
        return !this.configurationService.getBooleanProperty("orcid.synchronization-enabled", true);
    }

    private void updateItem(Context context, Item item) throws SQLException {
        try {
            context.turnOffAuthorisationSystem();
            this.itemService.update(context, item);
        }
        catch (AuthorizeException e) {
            throw new RuntimeException(e);
        }
        finally {
            context.restoreAuthSystemState();
        }
    }

    private void updateEPerson(Context context, EPerson ePerson) throws SQLException {
        try {
            this.ePersonService.update(context, ePerson);
        }
        catch (AuthorizeException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<Item> findProfilesByOrcid(Context context, String orcid) {
        DiscoverQuery discoverQuery = new DiscoverQuery();
        discoverQuery.setDSpaceObjectFilter(IndexableItem.TYPE);
        discoverQuery.addFilterQueries("search.entitytype:" + this.researcherProfileService.getProfileType());
        discoverQuery.addFilterQueries("person.identifier.orcid:" + orcid);
        try {
            return this.searchService.search(context, discoverQuery).getIndexableObjects().stream().map(object -> (Item)((IndexableItem)object).getIndexedObject()).collect(Collectors.toList());
        }
        catch (SearchServiceException ex) {
            throw new RuntimeException(ex);
        }
    }
}

