/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.orcid.model.factory;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.client.DSpaceHttpClientFactory;
import org.json.JSONObject;
import org.json.JSONTokener;

public final class OrcidFactoryUtils {
    private static final Logger log = LogManager.getLogger(OrcidFactoryUtils.class);

    private OrcidFactoryUtils() {
    }

    public static Map<String, String> parseConfigurations(String configurations) {
        HashMap<String, String> configurationMap = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)configurations)) {
            return configurationMap;
        }
        for (String configuration : configurations.split(",")) {
            String[] configurationSections = OrcidFactoryUtils.parseConfiguration(configuration);
            configurationMap.put(configurationSections[0], configurationSections[1]);
        }
        return configurationMap;
    }

    private static String[] parseConfiguration(String configuration) {
        String[] configurations = configuration.split("::");
        if (configurations.length != 2) {
            throw new IllegalStateException("The configuration '" + configuration + "' is not valid. Expected field::type");
        }
        return configurations;
    }

    public static Optional<String> retrieveAccessToken(String clientId, String clientSecret, String oauthUrl) throws IOException {
        if (StringUtils.isBlank((CharSequence)clientSecret) || StringUtils.isBlank((CharSequence)clientId) || StringUtils.isBlank((CharSequence)oauthUrl)) {
            String missingParams = (StringUtils.isBlank((CharSequence)clientId) ? "clientId " : "") + (StringUtils.isBlank((CharSequence)clientSecret) ? "clientSecret " : "") + (StringUtils.isBlank((CharSequence)oauthUrl) ? "oauthUrl" : "");
            log.error("Cannot retrieve ORCID access token: missing required parameters:{} ", (Object)missingParams.trim());
            return Optional.empty();
        }
        HttpPost httpPost = new HttpPost(oauthUrl);
        String auth = clientId + ":" + clientSecret;
        String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes(StandardCharsets.UTF_8));
        OrcidFactoryUtils.addHeaders(httpPost, encodedAuth);
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("grant_type", "client_credentials"));
        params.add(new BasicNameValuePair("scope", "/read-public"));
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, StandardCharsets.UTF_8));
        try (CloseableHttpClient httpClient = DSpaceHttpClientFactory.getInstance().build();){
            Optional<String> optional;
            block19: {
                JSONObject responseObject;
                InputStream is;
                block17: {
                    Optional<String> optional2;
                    block18: {
                        log.debug("Sending ORCID token request to {}", (Object)oauthUrl);
                        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                        if (!OrcidFactoryUtils.isSuccessful((HttpResponse)response)) {
                            log.error("Failed to retrieve ORCID access token");
                            Optional<String> optional3 = Optional.empty();
                            return optional3;
                        }
                        is = response.getEntity().getContent();
                        try {
                            responseObject = new JSONObject(new JSONTokener(is));
                            if (!responseObject.has("access_token")) break block17;
                            String token = responseObject.getString("access_token");
                            log.debug("Successfully retrieved ORCID access token");
                            optional2 = Optional.of(token);
                            if (is == null) break block18;
                        }
                        catch (Throwable throwable) {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        is.close();
                    }
                    return optional2;
                }
                log.error("ORCID response missing access_token field:{} ", (Object)responseObject);
                optional = Optional.empty();
                if (is == null) break block19;
                is.close();
            }
            return optional;
        }
    }

    private static void addHeaders(HttpPost httpPost, String encodedAuth) {
        httpPost.addHeader("Authorization", "Basic " + encodedAuth);
        httpPost.addHeader("Accept", "application/json");
        httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    private static boolean isSuccessful(HttpResponse response) {
        if (response == null) {
            log.error("ORCID API request failed: null response received");
            return false;
        }
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            String errorMsg = "ORCID API request failed with status code {}: {}";
            log.error(errorMsg, (Object)statusCode, (Object)response.getStatusLine().getReasonPhrase());
            return false;
        }
        return true;
    }
}

