/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.identifier;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.DisseminationCrosswalk;
import org.dspace.content.crosswalk.ParameterizedDisseminationCrosswalk;
import org.dspace.core.Context;
import org.dspace.core.factory.CoreServiceFactory;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.services.ConfigurationService;
import org.dspace.utils.DSpace;
import org.jdom2.Element;
import org.jdom2.output.XMLOutputter;

public class DataCiteXMLCreator {
    private static final Logger LOG = LogManager.getLogger();
    protected String CROSSWALK_NAME = "DataCite";
    private static final String CFG_PREFIX = "identifier.doi.prefix";
    private static final String CFG_PUBLISHER = "crosswalk.dissemination.DataCite.publisher";
    private static final String CFG_DATAMANAGER = "crosswalk.dissemination.DataCite.dataManager";
    private static final String CFG_HOSTINGINSTITUTION = "crosswalk.dissemination.DataCite.hostingInstitution";
    protected ParameterizedDisseminationCrosswalk xwalk;

    public String getXMLString(Context context, DSpaceObject dso) {
        Element root;
        if (dso == null) {
            LOG.info("Invalid object: {}", (Object)dso);
            return null;
        }
        this.prepareXwalk();
        if (!this.xwalk.canDisseminate(dso)) {
            LOG.error("Crosswalk {} cannot disseminate DSO with type {} and ID {}.", (Object)this.CROSSWALK_NAME, (Object)dso.getType(), (Object)dso.getID());
            return null;
        }
        ConfigurationService cfg = new DSpace().getConfigurationService();
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (cfg.hasProperty(CFG_PREFIX)) {
            parameters.put("prefix", cfg.getProperty(CFG_PREFIX));
        }
        if (cfg.hasProperty(CFG_PUBLISHER)) {
            parameters.put("publisher", cfg.getProperty(CFG_PUBLISHER));
        }
        if (cfg.hasProperty(CFG_DATAMANAGER)) {
            parameters.put("datamanager", cfg.getProperty(CFG_DATAMANAGER));
        }
        if (cfg.hasProperty(CFG_HOSTINGINSTITUTION)) {
            parameters.put("hostinginstitution", cfg.getProperty(CFG_HOSTINGINSTITUTION));
        }
        try {
            root = this.xwalk.disseminateElement(context, dso, parameters);
        }
        catch (IOException | SQLException | AuthorizeException | CrosswalkException e) {
            LOG.error("Exception while crosswalking DSO with type {} and ID {}.", (Object)dso.getType(), (Object)dso.getID(), (Object)e);
            return null;
        }
        XMLOutputter xOut = new XMLOutputter();
        return xOut.outputString(root);
    }

    public void setDisseminationCrosswalkName(String CROSSWALK_NAME) {
        this.CROSSWALK_NAME = CROSSWALK_NAME;
    }

    protected void prepareXwalk() {
        if (null != this.xwalk) {
            return;
        }
        this.xwalk = (ParameterizedDisseminationCrosswalk)CoreServiceFactory.getInstance().getPluginService().getNamedPlugin(DisseminationCrosswalk.class, this.CROSSWALK_NAME);
        if (this.xwalk == null) {
            throw new RuntimeException("Can't find crosswalk '" + this.CROSSWALK_NAME + "'!");
        }
    }

    public static void main(String[] argv) throws Exception {
        String handle = argv[0];
        DataCiteXMLCreator instance = new DataCiteXMLCreator();
        Context context = new Context();
        DSpaceObject dso = HandleServiceFactory.getInstance().getHandleService().resolveToObject(context, handle);
        System.out.println(instance.getXMLString(context, dso));
    }
}

