/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.correctiontype;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.sql.SQLException;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Item;
import org.dspace.content.QAEvent;
import org.dspace.core.Context;
import org.dspace.correctiontype.CorrectionType;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.GroupService;
import org.dspace.qaevent.service.QAEventService;
import org.dspace.qaevent.service.dto.CorrectionTypeMessageDTO;
import org.dspace.qaevent.service.dto.QAMessageDTO;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class WithdrawnCorrectionType
implements CorrectionType,
InitializingBean {
    public static final String WITHDRAWAL_REINSTATE_GROUP = "qaevents.withdraw-reinstate.group";
    private String id;
    private String topic;
    private String creationForm;
    @Autowired
    private GroupService groupService;
    @Autowired
    private QAEventService qaEventService;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private ConfigurationService configurationService;

    @Override
    public boolean isAllowed(Context context, Item targetItem) throws SQLException {
        if (targetItem.isWithdrawn() || !targetItem.isArchived()) {
            return false;
        }
        try {
            this.authorizeService.authorizeAction(context, targetItem, 0);
        }
        catch (AuthorizeException e) {
            return false;
        }
        boolean isAdmin = this.authorizeService.isAdmin(context);
        if (!this.currentUserIsMemberOfwithdrawalReinstateGroup(context) && !isAdmin) {
            return false;
        }
        long tot = this.qaEventService.countSourcesByTarget(context, targetItem.getID());
        return tot == 0L;
    }

    private boolean currentUserIsMemberOfwithdrawalReinstateGroup(Context context) throws SQLException {
        String groupName = this.configurationService.getProperty(WITHDRAWAL_REINSTATE_GROUP);
        if (StringUtils.isBlank((CharSequence)groupName)) {
            return false;
        }
        Group withdrawalReinstateGroup = this.groupService.findByName(context, groupName);
        return withdrawalReinstateGroup != null && this.groupService.isMember(context, withdrawalReinstateGroup);
    }

    @Override
    public QAEvent createCorrection(Context context, Item targetItem, QAMessageDTO reason) {
        ObjectNode reasonJson = this.createReasonJson(reason);
        QAEvent qaEvent = new QAEvent("DSpaceUsers", context.getCurrentUser().getID().toString(), targetItem.getID().toString(), targetItem.getName(), this.getTopic(), 1.0, reasonJson.toString(), new Date());
        this.qaEventService.store(context, qaEvent);
        return qaEvent;
    }

    private ObjectNode createReasonJson(QAMessageDTO reason) {
        CorrectionTypeMessageDTO mesasge = (CorrectionTypeMessageDTO)reason;
        ObjectNode jsonNode = new ObjectMapper().createObjectNode();
        jsonNode.put("reason", mesasge.getReason());
        return jsonNode;
    }

    @Override
    public boolean isAllowed(Context context, Item targetItem, Item relatedItem) throws AuthorizeException, SQLException {
        return this.isAllowed(context, targetItem);
    }

    @Override
    public QAEvent createCorrection(Context context, Item targetItem, Item relatedItem, QAMessageDTO reason) {
        return this.createCorrection(context, targetItem, reason);
    }

    @Override
    public boolean isRequiredRelatedItem() {
        return false;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void afterPropertiesSet() throws Exception {
    }

    public void setCreationForm(String creationForm) {
        this.creationForm = creationForm;
    }
}

