/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.dspace.core.service.NewsService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class NewsServiceImpl
implements NewsService {
    private final Logger log = LogManager.getLogger();
    private List<String> acceptableFilenames;
    @Autowired(required=true)
    private ConfigurationService configurationService;

    public void setAcceptableFilenames(List<String> acceptableFilenames) {
        this.acceptableFilenames = this.addLocalesToAcceptableFilenames(acceptableFilenames);
    }

    protected List<String> addLocalesToAcceptableFilenames(List<String> acceptableFilenames) {
        String[] locales = this.configurationService.getArrayProperty("webui.supported.locales");
        ArrayList<String> newAcceptableFilenames = new ArrayList<String>();
        newAcceptableFilenames.addAll(acceptableFilenames);
        for (String local : locales) {
            for (String acceptableFilename : acceptableFilenames) {
                int lastPoint = acceptableFilename.lastIndexOf(".");
                newAcceptableFilenames.add(acceptableFilename.substring(0, lastPoint) + "_" + local + acceptableFilename.substring(lastPoint));
            }
        }
        return newAcceptableFilenames;
    }

    protected NewsServiceImpl() {
    }

    @Override
    public String readNewsFile(String newsFile) {
        if (!this.validate(newsFile)) {
            throw new IllegalArgumentException("The file " + newsFile + " is not a valid news file");
        }
        Object fileName = this.getNewsFilePath();
        fileName = (String)fileName + newsFile;
        StringBuilder text = new StringBuilder();
        try {
            String lineIn;
            FileInputStream fir = new FileInputStream((String)fileName);
            InputStreamReader ir = new InputStreamReader((InputStream)fir, "UTF-8");
            BufferedReader br = new BufferedReader(ir);
            while ((lineIn = br.readLine()) != null) {
                text.append(lineIn);
            }
            br.close();
            ir.close();
            fir.close();
        }
        catch (IOException e) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = e::getLocalizedMessage;
            this.log.warn("news_read: {}", supplierArray);
        }
        return text.toString();
    }

    @Override
    public String writeNewsFile(String newsFile, String news) {
        if (!this.validate(newsFile)) {
            throw new IllegalArgumentException("The file " + newsFile + " is not a valid news file");
        }
        Object fileName = this.getNewsFilePath();
        fileName = (String)fileName + newsFile;
        try {
            FileOutputStream fos = new FileOutputStream((String)fileName);
            OutputStreamWriter osr = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            PrintWriter out = new PrintWriter(osr);
            out.print(news);
            out.close();
        }
        catch (IOException e) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = e::getLocalizedMessage;
            this.log.warn("news_write: {}", supplierArray);
        }
        return news;
    }

    @Override
    public String getNewsFilePath() {
        String filePath = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("dspace.dir") + File.separator + "config" + File.separator;
        return filePath;
    }

    @Override
    public boolean validate(String newsName) {
        if (this.acceptableFilenames != null) {
            return this.acceptableFilenames.contains(newsName);
        }
        return false;
    }
}

