/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.dspace.app.itemupdate.MetadataUtilities;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.service.DuplicateDetectionService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.content.service.MetadataValueService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.content.virtual.PotentialDuplicate;
import org.dspace.core.Context;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.SearchUtils;
import org.dspace.discovery.indexobject.IndexableItem;
import org.dspace.discovery.indexobject.IndexableWorkflowItem;
import org.dspace.discovery.indexobject.IndexableWorkspaceItem;
import org.dspace.eperson.service.GroupService;
import org.dspace.services.ConfigurationService;
import org.dspace.versioning.VersionHistory;
import org.dspace.versioning.service.VersionHistoryService;
import org.dspace.workflow.WorkflowItem;
import org.dspace.xmlworkflow.storedcomponents.service.XmlWorkflowItemService;
import org.springframework.beans.factory.annotation.Autowired;

public class DuplicateDetectionServiceImpl
implements DuplicateDetectionService {
    @Autowired
    ConfigurationService configurationService;
    @Autowired
    VersionHistoryService versionHistoryService;
    @Autowired
    AuthorizeService authorizeService;
    @Autowired
    GroupService groupService;
    @Autowired
    MetadataFieldService metadataFieldService;
    @Autowired
    MetadataValueService metadataValueService;
    @Autowired
    XmlWorkflowItemService workflowItemService;
    @Autowired
    WorkspaceItemService workspaceItemService;
    @Autowired
    ItemService itemService;

    @Override
    public List<PotentialDuplicate> getPotentialDuplicates(Context context, Item item) throws SearchServiceException {
        LinkedList<PotentialDuplicate> potentialDuplicates = new LinkedList<PotentialDuplicate>();
        if (!this.configurationService.getBooleanProperty("duplicate.enable", false)) {
            return potentialDuplicates;
        }
        DiscoverResult discoverResult = this.searchDuplicates(context, item);
        if (discoverResult != null) {
            for (IndexableObject result : discoverResult.getIndexableObjects()) {
                if (result == null) continue;
                try {
                    Optional<PotentialDuplicate> potentialDuplicateOptional = this.validateDuplicateResult(context, result, item);
                    if (!potentialDuplicateOptional.isPresent()) continue;
                    potentialDuplicates.add(potentialDuplicateOptional.get());
                }
                catch (SQLException e) {
                    log.error("SQL Error obtaining duplicate result: " + e.getMessage());
                }
                catch (AuthorizeException e) {
                    log.error("Authorize Error obtaining duplicate result: " + e.getMessage());
                }
            }
        }
        return potentialDuplicates;
    }

    @Override
    public Optional<PotentialDuplicate> validateDuplicateResult(Context context, IndexableObject indexableObject, Item original) throws SQLException, AuthorizeException {
        Item resultItem = null;
        PotentialDuplicate potentialDuplicate = null;
        WorkspaceItem workspaceItem = null;
        WorkflowItem workflowItem = null;
        if (indexableObject instanceof IndexableWorkspaceItem && (workspaceItem = (WorkspaceItem)((IndexableWorkspaceItem)indexableObject).getIndexedObject()) != null && workspaceItem.getSubmitter() != null && workspaceItem.getSubmitter().equals(context.getCurrentUser())) {
            resultItem = workspaceItem.getItem();
        }
        if (indexableObject instanceof IndexableWorkflowItem && (workflowItem = (WorkflowItem)((IndexableWorkflowItem)indexableObject).getIndexedObject()) != null) {
            resultItem = workflowItem.getItem();
        }
        if (indexableObject instanceof IndexableItem) {
            resultItem = (Item)((IndexableItem)indexableObject).getIndexedObject();
            workflowItem = this.workflowItemService.findByItem(context, resultItem);
            workspaceItem = this.workspaceItemService.findByItem(context, resultItem);
        }
        if (resultItem == null) {
            log.warn("skipping null item in duplicate search results");
            return Optional.empty();
        }
        if (resultItem.getTemplateItemOf() != null) {
            log.info("skipping template item in duplicate search results, item={}", (Object)resultItem.getID());
            return Optional.empty();
        }
        if (resultItem.getID().equals(original.getID())) {
            log.info("skipping a duplicate search result for the original item", (Object)resultItem.getID());
            return Optional.empty();
        }
        VersionHistory versionHistory = this.versionHistoryService.findByItem(context, original);
        VersionHistory candiateVersionHistory = this.versionHistoryService.findByItem(context, resultItem);
        if (versionHistory != null && versionHistory.equals(candiateVersionHistory)) {
            log.warn("skipping item that is just another version of this item");
            return Optional.empty();
        }
        potentialDuplicate = new PotentialDuplicate(resultItem);
        ArrayList<String> fields = new ArrayList<String>(Arrays.asList(this.configurationService.getArrayProperty("duplicate.preview.metadata.field", new String[0])));
        List<MetadataValue> metadata = resultItem.getCachedMetadata();
        for (MetadataValue metadatum : metadata) {
            String fieldName = metadatum.getMetadataField().toString('.');
            if (!fields.contains(fieldName)) continue;
            potentialDuplicate.getMetadataValueList().add(metadatum);
        }
        if (workspaceItem != null && workspaceItem.getSubmitter() != null && workspaceItem.getSubmitter().equals(context.getCurrentUser())) {
            potentialDuplicate.setWorkspaceItemId(workspaceItem.getID());
            return Optional.of(potentialDuplicate);
        }
        if (workflowItem != null) {
            Collection c = workflowItem.getCollection();
            if (this.groupService.isMember(context, context.getCurrentUser(), c.getWorkflowStep1(context)) || this.groupService.isMember(context, context.getCurrentUser(), c.getWorkflowStep2(context)) || this.groupService.isMember(context, context.getCurrentUser(), c.getWorkflowStep3(context))) {
                potentialDuplicate.setWorkflowItemId(workflowItem.getID());
                return Optional.of(potentialDuplicate);
            }
        } else if (resultItem.isArchived() && !resultItem.isWithdrawn() && resultItem.isDiscoverable()) {
            if (this.authorizeService.authorizeActionBoolean(context, resultItem, 0)) {
                return Optional.of(potentialDuplicate);
            }
        } else {
            if (this.authorizeService.isAdmin(context, resultItem)) {
                return Optional.of(potentialDuplicate);
            }
            log.info("Potential duplicate result is not readable by the current user, skipping item={}", (Object)potentialDuplicate.getUuid());
        }
        return Optional.empty();
    }

    @Override
    public DiscoverResult searchDuplicates(Context context, Item item) throws SearchServiceException {
        if (item == null) {
            throw new ResourceNotFoundException("Duplicate search error: item is null");
        }
        if (item.getTemplateItemOf() != null) {
            throw new IllegalArgumentException("Cannot get duplicates for template item");
        }
        String comparisonValue = this.buildComparisonValue(context, item);
        if (StringUtils.isNotBlank((CharSequence)comparisonValue)) {
            SearchService searchService = SearchUtils.getSearchService();
            comparisonValue = searchService.escapeQueryChars(comparisonValue);
            DiscoverQuery discoverQuery = new DiscoverQuery();
            discoverQuery.setQuery("(" + this.configurationService.getProperty("duplicate.comparison.solr.field", "deduplication_keyword") + ":" + comparisonValue + "~" + this.configurationService.getIntProperty("duplicate.comparison.distance", 0) + ")");
            discoverQuery.addFilterQueries("(search.resourcetype:Item OR search.resourcetype:WorkspaceItem OR search.resourcetype:XmlWorkflowItem OR search.resourcetype:WorkflowItem)");
            discoverQuery.addFilterQueries("-search.resourceid:" + item.getID());
            return searchService.search(context, discoverQuery);
        }
        log.warn("empty item comparison value, ignoring for duplicate search");
        return null;
    }

    @Override
    public String buildComparisonValue(Context context, Item item) {
        String[] comparisonFields = this.configurationService.getArrayProperty("duplicate.comparison.metadata.field", new String[]{"dc.title"});
        StringBuilder comparisonValueBuilder = new StringBuilder();
        String comparisonValue = null;
        for (String field : comparisonFields) {
            try {
                String[] fieldParts = MetadataUtilities.parseCompoundForm(field);
                List<MetadataValue> metadataValues = this.itemService.getMetadata(item, fieldParts[0], fieldParts[1], fieldParts.length > 2 ? fieldParts[2] : null, "*");
                metadataValues.sort(Comparator.comparing(MetadataValue::getValue, Comparator.naturalOrder()));
                for (MetadataValue metadataValue : metadataValues) {
                    if (metadataValue == null) continue;
                    comparisonValueBuilder.append(metadataValue.getValue());
                }
            }
            catch (ParseException e) {
                log.error("Error parsing configured field for deduplication comparison: item={}, field={}", (Object)item.getID(), (Object)field);
            }
            catch (NullPointerException e) {
                log.error("Null pointer encountered, probably during metadata value sort, when deduping:item={}, field={}", (Object)item.getID(), (Object)field);
            }
        }
        comparisonValue = comparisonValueBuilder.toString();
        if (!StringUtils.isBlank((CharSequence)comparisonValue)) {
            if (this.configurationService.getBooleanProperty("duplicate.comparison.normalise.lowercase")) {
                comparisonValue = comparisonValue.toLowerCase(context.getCurrentLocale());
            }
            if (this.configurationService.getBooleanProperty("duplicate.comparison.normalise.whitespace")) {
                comparisonValue = comparisonValue.replaceAll("\\s+", "");
            }
        }
        return comparisonValue;
    }
}

