/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.checker;

import jakarta.mail.MessagingException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.SQLException;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.checker.factory.CheckerServiceFactory;
import org.dspace.checker.service.SimpleReporterService;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.Utils;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class DailyReportEmailer {
    private static final Logger log = LogManager.getLogger(DailyReportEmailer.class);

    public void sendReport(File attachment, int numberOfBitstreams) throws IOException, MessagingException {
        if (numberOfBitstreams > 0) {
            ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
            String hostname = Utils.getHostName(configurationService.getProperty("dspace.ui.url"));
            Email email = new Email();
            email.setSubject(String.format("Checksum checker Report - %d Bitstreams found with POSSIBLE issues on %s", numberOfBitstreams, hostname));
            email.setContent("Checker Report", "report is attached ...");
            email.addAttachment(attachment, "checksum_checker_report.txt");
            email.addRecipient(configurationService.getProperty("mail.admin"));
            log.info("Sending checker report email to " + configurationService.getProperty("mail.admin"));
            email.send();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        DefaultParser parser = new DefaultParser();
        CommandLine line = null;
        Options options = new Options();
        options.addOption("h", "help", false, "Help");
        options.addOption("d", "deleted", false, "Send email report for all bitstreams set as deleted for today");
        options.addOption("m", "missing", false, "Send email report for all bitstreams not found in assetstore for today");
        options.addOption("c", "changed", false, "Send email report for all bitstreams where checksum has been changed for today");
        options.addOption("a", "all", false, "Send all email reports (used by default)");
        options.addOption("u", "unchecked", false, "Send the unchecked (i.e. recently added) bitstream email report");
        options.addOption("n", "not-processed", false, "Send email report for all bitstreams set to no longer be processed for today (includes bitstreams marked as deleted or not found)");
        try {
            line = parser.parse(options, args);
        }
        catch (ParseException e) {
            log.fatal((Object)e);
            System.exit(1);
        }
        if (line.hasOption('h')) {
            HelpFormatter myhelp = new HelpFormatter();
            myhelp.printHelp("checker-emailer\n", options);
            System.out.println("\nChecksum Checker Reporter usage examples:\n");
            System.out.println(" - Send all email reports: checker-emailer -a");
            System.out.println(" - Send deleted bitstream email report: checker-emailer -d");
            System.out.println(" - Send missing bitstreams email report: checker-emailer -m");
            System.out.println(" - Send checksum changed email report: checker-emailer -c");
            System.out.println(" - Send bitstream not to be processed email report: checker-emailer -n");
            System.out.println(" - Send unchecked bitstream email report: checker-emailer -u");
            System.out.println("\nDefault (no arguments) is equivalent to 'checker-emailer -a'\n");
            System.exit(0);
        }
        SimpleReporterService reporter = CheckerServiceFactory.getInstance().getSimpleReporterService();
        DailyReportEmailer emailer = new DailyReportEmailer();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.add(6, -1);
        Date yesterday = calendar.getTime();
        calendar.add(6, 2);
        Date tomorrow = calendar.getTime();
        File report = null;
        OutputStreamWriter writer = null;
        Context context = null;
        try {
            context = new Context(Context.Mode.READ_ONLY);
            int numBitstreams = 0;
            ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
            String dirLocation = configurationService.getProperty("log.report.dir");
            File directory = new File(dirLocation);
            if (!directory.exists() || !directory.isDirectory()) {
                throw new IllegalStateException("directory :" + dirLocation + " does not exist");
            }
            report = File.createTempFile("checker_report", ".txt", directory);
            writer = new FileWriter(report);
            if (line.hasOption("a") || line.getOptions().length == 0) {
                writer.write("\n--------------------------------- Begin Reporting ------------------------\n\n");
                numBitstreams += reporter.getDeletedBitstreamReport(context, yesterday, tomorrow, writer);
                writer.write("\n--------------------------------- Report Spacer ---------------------------\n\n");
                numBitstreams += reporter.getChangedChecksumReport(context, yesterday, tomorrow, writer);
                writer.write("\n--------------------------------- Report Spacer ---------------------------\n\n");
                numBitstreams += reporter.getBitstreamNotFoundReport(context, yesterday, tomorrow, writer);
                writer.write("\n--------------------------------- Report Spacer ---------------------------\n\n");
                reporter.getNotToBeProcessedReport(context, yesterday, tomorrow, writer);
                writer.write("\n--------------------------------- Report Spacer ---------------------------\n\n");
                writer.write("\n--------------------------------- End Report ---------------------------\n\n");
                writer.flush();
                writer.close();
                emailer.sendReport(report, numBitstreams += reporter.getUncheckedBitstreamsReport(context, writer));
            } else {
                if (line.hasOption("d")) {
                    writer.write("\n--------------------------------- Begin Reporting ------------------------\n\n");
                    writer.flush();
                    writer.close();
                    emailer.sendReport(report, numBitstreams += reporter.getDeletedBitstreamReport(context, yesterday, tomorrow, writer));
                }
                if (line.hasOption("m")) {
                    writer.write("\n--------------------------------- Begin Reporting ------------------------\n\n");
                    writer.flush();
                    writer.close();
                    emailer.sendReport(report, numBitstreams += reporter.getBitstreamNotFoundReport(context, yesterday, tomorrow, writer));
                }
                if (line.hasOption("c")) {
                    writer.write("\n--------------------------------- Begin Reporting ------------------------\n\n");
                    writer.flush();
                    writer.close();
                    emailer.sendReport(report, numBitstreams += reporter.getChangedChecksumReport(context, yesterday, tomorrow, writer));
                }
                if (line.hasOption("n")) {
                    writer.write("\n--------------------------------- Begin Reporting ------------------------\n\n");
                    writer.flush();
                    writer.close();
                    emailer.sendReport(report, numBitstreams += reporter.getNotToBeProcessedReport(context, yesterday, tomorrow, writer));
                }
                if (line.hasOption("u")) {
                    writer.write("\n--------------------------------- Begin Reporting ------------------------\n\n");
                    writer.flush();
                    writer.close();
                    emailer.sendReport(report, numBitstreams += reporter.getUncheckedBitstreamsReport(context, writer));
                }
            }
        }
        catch (MessagingException | IOException | SQLException e) {
            log.fatal((Object)e);
        }
        finally {
            if (context != null && context.isValid()) {
                context.abort();
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    log.fatal("Could not close writer", (Throwable)e);
                }
            }
            if (report != null && report.exists() && !report.delete()) {
                log.error("Unable to delete report file");
            }
        }
    }
}

