/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.mediafilter;

import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.ExifIFD0Directory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.mediafilter.Brand;
import org.dspace.app.mediafilter.MediaFilter;
import org.dspace.app.mediafilter.SelfRegisterInputFormats;
import org.dspace.content.Item;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class JPEGFilter
extends MediaFilter
implements SelfRegisterInputFormats {
    private static final Logger log = LogManager.getLogger(JPEGFilter.class);

    @Override
    public String getFilteredName(String oldFilename) {
        return oldFilename + ".jpg";
    }

    @Override
    public String getBundleName() {
        return "THUMBNAIL";
    }

    @Override
    public String getFormatString() {
        return "JPEG";
    }

    @Override
    public String getDescription() {
        return "Generated Thumbnail";
    }

    public static int getImageRotationUsingImageReader(InputStream buf) {
        try {
            Metadata metadata = ImageMetadataReader.readMetadata((InputStream)buf);
            ExifIFD0Directory directory = (ExifIFD0Directory)metadata.getFirstDirectoryOfType(ExifIFD0Directory.class);
            if (directory != null && directory.containsTag(274)) {
                return JPEGFilter.convertRotationToDegrees(directory.getInt(274));
            }
        }
        catch (ImageProcessingException | MetadataException | IOException e) {
            log.error("Error reading image metadata", e);
        }
        return 0;
    }

    public static int convertRotationToDegrees(int valueNode) {
        switch (valueNode) {
            case 6: {
                return 90;
            }
            case 3: {
                return 180;
            }
            case 8: {
                return 270;
            }
        }
        return 0;
    }

    public static BufferedImage rotateImage(BufferedImage image, int angle) {
        if (angle == 0) {
            return image;
        }
        double radians = Math.toRadians(angle);
        double sin = Math.abs(Math.sin(radians));
        double cos = Math.abs(Math.cos(radians));
        int newWidth = (int)Math.round((double)image.getWidth() * cos + (double)image.getHeight() * sin);
        int newHeight = (int)Math.round((double)image.getWidth() * sin + (double)image.getHeight() * cos);
        BufferedImage rotated = new BufferedImage(newWidth, newHeight, image.getType());
        Graphics2D g2d = rotated.createGraphics();
        AffineTransform at = new AffineTransform();
        at.translate(newWidth / 2, newHeight / 2);
        at.rotate(radians);
        at.translate(-image.getWidth() / 2, -image.getHeight() / 2);
        g2d.setTransform(at);
        g2d.drawImage((Image)image, 0, 0, null);
        g2d.dispose();
        return rotated;
    }

    private Dimension getScaledDimension(Dimension imgSize, Dimension boundary) {
        int originalWidth = imgSize.width;
        int originalHeight = imgSize.height;
        int boundWidth = boundary.width;
        int boundHeight = boundary.height;
        int newWidth = originalWidth;
        int newHeight = originalHeight;
        if (originalWidth > boundWidth) {
            newWidth = boundWidth;
            newHeight = newWidth * originalHeight / originalWidth;
        }
        if (newHeight > boundHeight) {
            newHeight = boundHeight;
            newWidth = newHeight * originalWidth / originalHeight;
        }
        return new Dimension(newWidth, newHeight);
    }

    @Override
    public InputStream getDestinationStream(Item currentItem, InputStream source, boolean verbose) throws Exception {
        return this.getThumb(currentItem, source, verbose);
    }

    public InputStream getThumb(Item currentItem, InputStream source, boolean verbose) throws Exception {
        ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        int xmax = configurationService.getIntProperty("thumbnail.maxwidth");
        int ymax = configurationService.getIntProperty("thumbnail.maxheight");
        boolean blurring = configurationService.getBooleanProperty("thumbnail.blurring");
        boolean hqscaling = configurationService.getBooleanProperty("thumbnail.hqscaling");
        return this.getThumb(currentItem, source, verbose, xmax, ymax, blurring, hqscaling, 0, 0, null);
    }

    protected InputStream getThumb(Item currentItem, InputStream source, boolean verbose, int xmax, int ymax, boolean blurring, boolean hqscaling, int brandHeight, int brandFontPoint, String brandFont) throws Exception {
        File tempFile = File.createTempFile("temp", ".tmp");
        tempFile.deleteOnExit();
        try (FileOutputStream fos = new FileOutputStream(tempFile);){
            int len;
            byte[] buffer = new byte[4096];
            while ((len = source.read(buffer)) != -1) {
                fos.write(buffer, 0, len);
            }
        }
        int rotation = 0;
        try (FileInputStream fis = new FileInputStream(tempFile);){
            rotation = JPEGFilter.getImageRotationUsingImageReader(fis);
        }
        fis = new FileInputStream(tempFile);
        try {
            BufferedImage buf = ImageIO.read(fis);
            InputStream inputStream = this.getThumbDim(currentItem, buf, verbose, xmax, ymax, blurring, hqscaling, brandHeight, brandFontPoint, rotation, brandFont);
            return inputStream;
        }
        finally {
            fis.close();
        }
    }

    public InputStream getThumb(Item currentItem, BufferedImage buf, boolean verbose) throws Exception {
        ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        int xmax = configurationService.getIntProperty("thumbnail.maxwidth");
        int ymax = configurationService.getIntProperty("thumbnail.maxheight");
        boolean blurring = configurationService.getBooleanProperty("thumbnail.blurring");
        boolean hqscaling = configurationService.getBooleanProperty("thumbnail.hqscaling");
        return this.getThumbDim(currentItem, buf, verbose, xmax, ymax, blurring, hqscaling, 0, 0, 0, null);
    }

    public InputStream getThumbDim(Item currentItem, BufferedImage buf, boolean verbose, int xmax, int ymax, boolean blurring, boolean hqscaling, int brandHeight, int brandFontPoint, int rotation, String brandFont) throws Exception {
        ByteArrayInputStream bais;
        BufferedImage correctedImage = JPEGFilter.rotateImage(buf, rotation);
        int xsize = correctedImage.getWidth();
        int ysize = correctedImage.getHeight();
        if (verbose) {
            System.out.println("original size: " + xsize + "," + ysize);
        }
        Dimension newDimension = this.getScaledDimension(new Dimension(xsize, ysize), new Dimension(xmax, ymax));
        if (verbose) {
            System.out.println("size after fitting to maximum height: " + newDimension.width + ", " + newDimension.height);
        }
        xsize = newDimension.width;
        ysize = newDimension.height;
        BufferedImage thumbnail = new BufferedImage(xsize, ysize, 1);
        if (blurring) {
            correctedImage = this.getBlurredInstance(correctedImage);
        }
        if (hqscaling) {
            correctedImage = this.getScaledInstance(correctedImage, xsize, ysize, RenderingHints.VALUE_INTERPOLATION_BICUBIC, true);
        }
        Graphics2D g2d = thumbnail.createGraphics();
        g2d.drawImage(correctedImage, 0, 0, xsize, ysize, null);
        if (brandHeight != 0) {
            ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
            Brand brand = new Brand(xsize, brandHeight, new Font(brandFont, 0, brandFontPoint), 5);
            BufferedImage brandImage = brand.create(configurationService.getProperty("webui.preview.brand"), configurationService.getProperty("webui.preview.brand.abbrev"), (String)(currentItem == null ? "" : "hdl:" + currentItem.getHandle()));
            g2d.drawImage(brandImage, 0, ysize, xsize, 20, null);
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)thumbnail, "jpeg", baos);
            bais = new ByteArrayInputStream(baos.toByteArray());
        }
        return bais;
    }

    @Override
    public String[] getInputMIMETypes() {
        return ImageIO.getReaderMIMETypes();
    }

    @Override
    public String[] getInputDescriptions() {
        return null;
    }

    @Override
    public String[] getInputExtensions() {
        return null;
    }

    public BufferedImage getNormalizedInstance(BufferedImage buf) {
        int type = buf.getTransparency() == 1 ? 1 : 3;
        int w = buf.getWidth();
        int h = buf.getHeight();
        BufferedImage normal = new BufferedImage(w, h, type);
        Graphics2D g2d = normal.createGraphics();
        g2d.drawImage(buf, 0, 0, w, h, Color.WHITE, null);
        g2d.dispose();
        return normal;
    }

    public BufferedImage getBlurredInstance(BufferedImage buf) {
        buf = this.getNormalizedInstance(buf);
        float[] matrix = new float[]{0.111f, 0.111f, 0.111f, 0.111f, 0.111f, 0.111f, 0.111f, 0.111f, 0.111f};
        ConvolveOp blur = new ConvolveOp(new Kernel(3, 3, matrix));
        BufferedImage blurbuf = blur.filter(buf, null);
        return blurbuf;
    }

    public BufferedImage getScaledInstance(BufferedImage buf, int targetWidth, int targetHeight, Object hint, boolean higherQuality) {
        int h;
        int w;
        int type = buf.getTransparency() == 1 ? 1 : 2;
        BufferedImage scalebuf = buf;
        if (higherQuality) {
            w = buf.getWidth();
            h = buf.getHeight();
        } else {
            w = targetWidth;
            h = targetHeight;
        }
        do {
            if (higherQuality && w > targetWidth && (w /= 2) < targetWidth) {
                w = targetWidth;
            }
            if (higherQuality && h > targetHeight && (h /= 2) < targetHeight) {
                h = targetHeight;
            }
            BufferedImage tmp = new BufferedImage(w, h, type);
            Graphics2D g2d = tmp.createGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
            g2d.drawImage(scalebuf, 0, 0, w, h, Color.WHITE, null);
            g2d.dispose();
            scalebuf = tmp;
        } while (w != targetWidth || h != targetHeight);
        return scalebuf;
    }
}

