/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.access.status;

import java.sql.SQLException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import org.dspace.access.status.AccessStatusHelper;
import org.dspace.access.status.service.AccessStatusService;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.core.service.PluginService;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;

public class AccessStatusServiceImpl
implements AccessStatusService {
    protected AccessStatusHelper helper = null;
    protected Date forever_date = null;
    @Autowired(required=true)
    protected ConfigurationService configurationService;
    @Autowired(required=true)
    protected PluginService pluginService;

    public void init() throws Exception {
        if (this.helper == null) {
            this.helper = (AccessStatusHelper)this.pluginService.getSinglePlugin(AccessStatusHelper.class);
            if (this.helper == null) {
                throw new IllegalStateException("The AccessStatusHelper plugin was not defined in DSpace configuration.");
            }
            int year = this.configurationService.getIntProperty("access.status.embargo.forever.year");
            int month = this.configurationService.getIntProperty("access.status.embargo.forever.month");
            int day = this.configurationService.getIntProperty("access.status.embargo.forever.day");
            this.forever_date = Date.from(LocalDate.of(year, month, day).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
        }
    }

    @Override
    public String getAccessStatus(Context context, Item item) throws SQLException {
        return this.helper.getAccessStatusFromItem(context, item, this.forever_date);
    }

    @Override
    public String getEmbargoFromItem(Context context, Item item) throws SQLException {
        return this.helper.getEmbargoFromItem(context, item, this.forever_date);
    }
}

