/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow.storedcomponents;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.eperson.EPerson;
import org.dspace.workflow.WorkflowItem;

@Entity
@Table(name="cwf_workflowitem")
public class XmlWorkflowItem
implements WorkflowItem {
    @Id
    @Column(name="workflowitem_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="cwf_workflowitem_seq")
    @SequenceGenerator(name="cwf_workflowitem_seq", sequenceName="cwf_workflowitem_seq", allocationSize=1)
    private Integer id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="collection_id")
    private Collection collection;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="item_id", unique=true)
    private Item item;
    @Column(name="multiple_titles")
    private boolean multipleTitles = false;
    @Column(name="published_before")
    private boolean publishedBefore = false;
    @Column(name="multiple_files")
    private boolean multipleFiles = false;

    protected XmlWorkflowItem() {
    }

    @Override
    public Integer getID() {
        return this.id;
    }

    @Override
    public Collection getCollection() {
        return this.collection;
    }

    public void setCollection(Collection collection) {
        this.collection = collection;
    }

    @Override
    public Item getItem() {
        return this.item;
    }

    public void setItem(Item item) {
        this.item = item;
    }

    @Override
    public EPerson getSubmitter() {
        return this.item.getSubmitter();
    }

    @Override
    public boolean hasMultipleFiles() {
        return this.multipleFiles;
    }

    @Override
    public void setMultipleFiles(boolean b) {
        this.multipleFiles = b;
    }

    @Override
    public boolean hasMultipleTitles() {
        return this.multipleTitles;
    }

    @Override
    public void setMultipleTitles(boolean b) {
        this.multipleTitles = b;
    }

    @Override
    public boolean isPublishedBefore() {
        return this.publishedBefore;
    }

    @Override
    public void setPublishedBefore(boolean b) {
        this.publishedBefore = b;
    }
}

