/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics;

import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.exception.GeoIp2Exception;
import com.maxmind.geoip2.model.CityResponse;
import com.opencsv.CSVReader;
import com.opencsv.CSVWriter;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URI;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.ContentStreamUpdateRequest;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.request.LukeRequest;
import org.apache.solr.client.solrj.response.CoreAdminResponse;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.LukeResponse;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.RangeFacet;
import org.apache.solr.client.solrj.response.SolrPingResponse;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.luke.FieldFlag;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.dspace.app.client.DSpaceHttpClientFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Community;
import org.dspace.content.DCDate;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.DSpaceObjectLegacySupportService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.service.ClientInfoService;
import org.dspace.services.ConfigurationService;
import org.dspace.statistics.GeoIpService;
import org.dspace.statistics.ObjectCount;
import org.dspace.statistics.SolrStatisticsCore;
import org.dspace.statistics.service.SolrLoggerService;
import org.dspace.statistics.util.LocationUtils;
import org.dspace.statistics.util.SpiderDetector;
import org.dspace.usage.UsageWorkflowEvent;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class SolrLoggerServiceImpl
implements SolrLoggerService,
InitializingBean {
    private static final Logger log = LogManager.getLogger();
    private static final String MULTIPLE_VALUES_SPLITTER = "|";
    public static final String DATE_FORMAT_8601 = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final String DATE_FORMAT_DCDATE = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    protected DatabaseReader locationService;
    protected boolean useProxies;
    private static final List<String> statisticYearCores = new ArrayList<String>();
    private static boolean statisticYearCoresInit = false;
    private static final String IP_V4_REGEX = "^((?:\\d{1,3}\\.){3})\\d{1,3}$";
    private static final String IP_V6_REGEX = "^(.*):.*:.*$";
    @Autowired(required=true)
    protected BitstreamService bitstreamService;
    @Autowired(required=true)
    protected ContentServiceFactory contentServiceFactory;
    @Autowired(required=true)
    protected ConfigurationService configurationService;
    @Autowired(required=true)
    protected ClientInfoService clientInfoService;
    @Autowired
    protected SolrStatisticsCore solrStatisticsCore;
    @Autowired
    protected GeoIpService geoIpService;
    @Autowired
    private AuthorizeService authorizeService;
    protected SolrClient solr;
    private String statisticsCoreBase;

    protected SolrLoggerServiceImpl() {
    }

    public void afterPropertiesSet() throws Exception {
        String statisticsCoreURL = this.configurationService.getProperty("solr-statistics.server");
        if (null != statisticsCoreURL) {
            Path statisticsPath = Paths.get(new URI(statisticsCoreURL).getPath(), new String[0]);
            this.statisticsCoreBase = statisticsPath.getName(statisticsPath.getNameCount() - 1).toString();
        } else {
            log.warn("Unable to find solr-statistics.server parameter in DSpace configuration. This is required for sharding statistics.");
            this.statisticsCoreBase = null;
        }
        this.solr = this.solrStatisticsCore.getSolr();
        DatabaseReader service = null;
        try {
            service = this.geoIpService.getDatabaseReader();
        }
        catch (IllegalStateException ex) {
            log.error((Object)ex);
        }
        this.locationService = service;
    }

    @Override
    public void post(DSpaceObject dspaceObject, HttpServletRequest request, EPerson currentUser) {
        this.postView(dspaceObject, request, currentUser);
    }

    @Override
    public void postView(DSpaceObject dspaceObject, HttpServletRequest request, EPerson currentUser) {
        this.postView(dspaceObject, request, currentUser, null);
    }

    @Override
    public void postView(DSpaceObject dspaceObject, HttpServletRequest request, EPerson currentUser, String referrer) {
        Context context = new Context();
        try {
            if (this.authorizeService.isAdmin(context, currentUser)) {
                return;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        if (this.solr == null) {
            return;
        }
        this.initSolrYearCores();
        try {
            SolrInputDocument doc1 = this.getCommonSolrDoc(dspaceObject, request, currentUser, referrer);
            if (doc1 == null) {
                return;
            }
            if (dspaceObject instanceof Bitstream) {
                Bitstream bit = (Bitstream)dspaceObject;
                List<Bundle> bundles = bit.getBundles();
                for (Bundle bundle : bundles) {
                    doc1.addField("bundleName", (Object)bundle.getName());
                }
            }
            doc1.addField("statistics_type", (Object)StatisticsType.VIEW.text());
            this.solr.add(doc1);
            boolean useAutoCommit = this.configurationService.getBooleanProperty("solr-statistics.autoCommit", true);
            if (!useAutoCommit) {
                this.solr.commit(false, false);
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            String email = null == currentUser ? "[anonymous]" : currentUser.getEmail();
            log.error("Error saving VIEW event to Solr for DSpaceObject {} by EPerson {}", (Object)dspaceObject.getID(), (Object)email, (Object)e);
        }
    }

    @Override
    public void postView(DSpaceObject dspaceObject, String ip, String userAgent, String xforwardedfor, EPerson currentUser) {
        this.postView(dspaceObject, ip, userAgent, xforwardedfor, currentUser, null);
    }

    @Override
    public void postView(DSpaceObject dspaceObject, String ip, String userAgent, String xforwardedfor, EPerson currentUser, String referrer) {
        if (this.solr == null) {
            return;
        }
        this.initSolrYearCores();
        try {
            SolrInputDocument doc1 = this.getCommonSolrDoc(dspaceObject, ip, userAgent, xforwardedfor, currentUser, referrer);
            if (doc1 == null) {
                return;
            }
            if (dspaceObject instanceof Bitstream) {
                Bitstream bit = (Bitstream)dspaceObject;
                List<Bundle> bundles = bit.getBundles();
                for (Bundle bundle : bundles) {
                    doc1.addField("bundleName", (Object)bundle.getName());
                }
            }
            doc1.addField("statistics_type", (Object)StatisticsType.VIEW.text());
            this.solr.add(doc1);
            boolean useAutoCommit = this.configurationService.getBooleanProperty("solr-statistics.autoCommit", true);
            if (!useAutoCommit) {
                this.solr.commit(false, false);
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            log.error("Error saving VIEW event to Solr for DSpaceObject {} by EPerson {}", (Object)dspaceObject.getID(), (Object)currentUser.getEmail(), (Object)e);
        }
    }

    protected SolrInputDocument getCommonSolrDoc(DSpaceObject dspaceObject, HttpServletRequest request, EPerson currentUser) throws SQLException {
        return this.getCommonSolrDoc(dspaceObject, request, currentUser, null);
    }

    protected SolrInputDocument getCommonSolrDoc(DSpaceObject dspaceObject, HttpServletRequest request, EPerson currentUser, String referrer) throws SQLException {
        SolrInputDocument doc1;
        block22: {
            boolean isSpiderBot;
            boolean bl = isSpiderBot = request != null && SpiderDetector.isSpider(request);
            if (isSpiderBot && !this.configurationService.getBooleanProperty("usage-statistics.logBots", true)) {
                return null;
            }
            doc1 = new SolrInputDocument(new String[0]);
            if (request != null) {
                String ip = this.clientInfoService.getClientIp(request);
                if (this.configurationService.getBooleanProperty("anonymize_statistics.anonymize_on_log", false)) {
                    try {
                        doc1.addField("ip", this.anonymizeIp(ip));
                    }
                    catch (UnknownHostException e) {
                        log.warn(e.getMessage(), (Throwable)e);
                    }
                } else {
                    doc1.addField("ip", (Object)ip);
                }
                if (referrer != null) {
                    doc1.addField("referrer", (Object)referrer);
                } else if (request.getHeader("referer") != null) {
                    doc1.addField("referrer", (Object)request.getHeader("referer"));
                }
                InetAddress ipAddress = null;
                try {
                    String dns;
                    if (!this.configurationService.getBooleanProperty("anonymize_statistics.anonymize_on_log", false)) {
                        ipAddress = InetAddress.getByName(ip);
                        dns = ipAddress.getHostName();
                    } else {
                        dns = this.configurationService.getProperty("anonymize_statistics.dns_mask", "anonymized");
                    }
                    doc1.addField("dns", (Object)dns.toLowerCase(Locale.ROOT));
                }
                catch (UnknownHostException e) {
                    log.info("Failed DNS Lookup for IP:  {}", (Object)ip);
                    log.debug(e.getMessage(), (Throwable)e);
                }
                if (request.getHeader("User-Agent") != null) {
                    doc1.addField("userAgent", (Object)request.getHeader("User-Agent"));
                }
                doc1.addField("isBot", (Object)isSpiderBot);
                if (this.locationService != null && ipAddress != null) {
                    try {
                        CityResponse location = this.locationService.city(ipAddress);
                        String countryCode = location.getCountry().getIsoCode();
                        double latitude = location.getLocation().getLatitude();
                        double longitude = location.getLocation().getLongitude();
                        if ("--".equals(countryCode) && latitude == -180.0 && longitude == -180.0) break block22;
                        try {
                            doc1.addField("continent", (Object)LocationUtils.getContinentCode(countryCode));
                        }
                        catch (Exception e) {
                            log.warn("Failed to load country/continent table: {}", (Object)countryCode);
                        }
                        doc1.addField("countryCode", (Object)countryCode);
                        doc1.addField("city", (Object)location.getCity().getName());
                        doc1.addField("latitude", (Object)latitude);
                        doc1.addField("longitude", (Object)longitude);
                    }
                    catch (IOException e) {
                        log.warn("GeoIP lookup failed.", (Throwable)e);
                    }
                    catch (GeoIp2Exception e) {
                        log.info("Unable to get location of request: {}", (Object)e.getMessage());
                    }
                }
            }
        }
        if (dspaceObject != null) {
            doc1.addField("id", (Object)dspaceObject.getID().toString());
            doc1.addField("type", (Object)dspaceObject.getType());
            this.storeParents(doc1, dspaceObject);
        }
        doc1.addField("time", (Object)DateFormatUtils.format((Date)new Date(), (String)DATE_FORMAT_8601));
        if (currentUser != null) {
            doc1.addField("epersonid", (Object)currentUser.getID().toString());
        }
        return doc1;
    }

    protected SolrInputDocument getCommonSolrDoc(DSpaceObject dspaceObject, String ip, String userAgent, String xforwardedfor, EPerson currentUser, String referrer) throws SQLException {
        SolrInputDocument doc1;
        block19: {
            boolean isSpiderBot = SpiderDetector.isSpider(ip);
            if (isSpiderBot && !this.configurationService.getBooleanProperty("usage-statistics.logBots", true)) {
                return null;
            }
            doc1 = new SolrInputDocument(new String[0]);
            ip = this.clientInfoService.getClientIp(ip, xforwardedfor);
            if (this.configurationService.getBooleanProperty("anonymize_statistics.anonymize_on_log", false)) {
                try {
                    doc1.addField("ip", this.anonymizeIp(ip));
                }
                catch (UnknownHostException e) {
                    log.warn(e.getMessage(), (Throwable)e);
                }
            } else {
                doc1.addField("ip", (Object)ip);
            }
            if (referrer != null) {
                doc1.addField("referrer", (Object)referrer);
            }
            InetAddress ipAddress = null;
            try {
                String dns;
                if (!this.configurationService.getBooleanProperty("anonymize_statistics.anonymize_on_log", false)) {
                    ipAddress = InetAddress.getByName(ip);
                    dns = ipAddress.getHostName();
                } else {
                    dns = this.configurationService.getProperty("anonymize_statistics.dns_mask", "anonymized");
                }
                doc1.addField("dns", (Object)dns.toLowerCase(Locale.ROOT));
            }
            catch (UnknownHostException e) {
                log.info("Failed DNS Lookup for IP:  {}", (Object)ip);
                log.debug(e.getMessage(), (Throwable)e);
            }
            if (userAgent != null) {
                doc1.addField("userAgent", (Object)userAgent);
            }
            doc1.addField("isBot", (Object)isSpiderBot);
            if (this.locationService != null) {
                try {
                    CityResponse location = this.locationService.city(ipAddress);
                    String countryCode = location.getCountry().getIsoCode();
                    double latitude = location.getLocation().getLatitude();
                    double longitude = location.getLocation().getLongitude();
                    if ("--".equals(countryCode) && latitude == -180.0 && longitude == -180.0) break block19;
                    try {
                        doc1.addField("continent", (Object)LocationUtils.getContinentCode(countryCode));
                    }
                    catch (Exception e) {
                        System.out.println("COUNTRY ERROR: " + countryCode);
                    }
                    doc1.addField("countryCode", (Object)countryCode);
                    doc1.addField("city", (Object)location.getCity().getName());
                    doc1.addField("latitude", (Object)latitude);
                    doc1.addField("longitude", (Object)longitude);
                }
                catch (IOException e) {
                    log.warn("GeoIP lookup failed.", (Throwable)e);
                }
                catch (GeoIp2Exception e) {
                    log.info("Unable to get location of request: {}", (Object)e.getMessage());
                }
            }
        }
        if (dspaceObject != null) {
            doc1.addField("id", (Object)dspaceObject.getID().toString());
            doc1.addField("type", (Object)dspaceObject.getType());
            this.storeParents(doc1, dspaceObject);
        }
        doc1.addField("time", (Object)DateFormatUtils.format((Date)new Date(), (String)DATE_FORMAT_8601));
        if (currentUser != null) {
            doc1.addField("epersonid", (Object)currentUser.getID().toString());
        }
        return doc1;
    }

    @Override
    public void postSearch(DSpaceObject resultObject, HttpServletRequest request, EPerson currentUser, List<String> queries, int rpp, String sortBy, String order, int page, DSpaceObject scope) {
        try {
            SolrInputDocument solrDoc = this.getCommonSolrDoc(resultObject, request, currentUser);
            if (solrDoc == null) {
                return;
            }
            this.initSolrYearCores();
            for (String query : queries) {
                solrDoc.addField("query", (Object)query);
            }
            if (resultObject != null) {
                solrDoc.addField("statistics_type", (Object)StatisticsType.SEARCH_RESULT.text());
            } else {
                solrDoc.addField("statistics_type", (Object)StatisticsType.SEARCH.text());
            }
            if (scope != null) {
                solrDoc.addField("scopeId", (Object)scope.getID().toString());
                solrDoc.addField("scopeType", (Object)scope.getType());
            }
            if (rpp != -1) {
                solrDoc.addField("rpp", (Object)rpp);
            }
            if (sortBy != null) {
                solrDoc.addField("sortBy", (Object)sortBy);
                if (order != null) {
                    solrDoc.addField("sortOrder", (Object)order);
                }
            }
            if (page != -1) {
                solrDoc.addField("page", (Object)page);
            }
            this.solr.add(solrDoc);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            log.error("Error saving SEARCH event to Solr by EPerson {}", (Object)currentUser.getEmail(), (Object)e);
        }
    }

    @Override
    public void postWorkflow(UsageWorkflowEvent usageWorkflowEvent) throws SQLException {
        this.initSolrYearCores();
        try {
            int i;
            SolrInputDocument solrDoc = this.getCommonSolrDoc(usageWorkflowEvent.getObject(), null, null);
            solrDoc.addField("owningColl", (Object)usageWorkflowEvent.getScope().getID().toString());
            this.storeParents(solrDoc, usageWorkflowEvent.getScope());
            if (usageWorkflowEvent.getWorkflowStep() != null) {
                solrDoc.addField("workflowStep", (Object)usageWorkflowEvent.getWorkflowStep());
            }
            if (usageWorkflowEvent.getOldState() != null) {
                solrDoc.addField("previousWorkflowStep", (Object)usageWorkflowEvent.getOldState());
            }
            if (usageWorkflowEvent.getGroupOwners() != null) {
                for (i = 0; i < usageWorkflowEvent.getGroupOwners().length; ++i) {
                    Group group = usageWorkflowEvent.getGroupOwners()[i];
                    solrDoc.addField("owner", (Object)("g" + group.getID().toString()));
                }
            }
            if (usageWorkflowEvent.getEpersonOwners() != null) {
                for (i = 0; i < usageWorkflowEvent.getEpersonOwners().length; ++i) {
                    EPerson ePerson = usageWorkflowEvent.getEpersonOwners()[i];
                    solrDoc.addField("owner", (Object)("e" + ePerson.getID().toString()));
                }
            }
            solrDoc.addField("workflowItemId", (Object)usageWorkflowEvent.getWorkflowItem().getID().toString());
            EPerson submitter = ((Item)usageWorkflowEvent.getObject()).getSubmitter();
            if (submitter != null) {
                solrDoc.addField("submitter", (Object)submitter.getID().toString());
            }
            solrDoc.addField("statistics_type", (Object)StatisticsType.WORKFLOW.text());
            if (usageWorkflowEvent.getActor() != null) {
                solrDoc.addField("actor", (Object)usageWorkflowEvent.getActor().getID().toString());
            }
            this.solr.add(solrDoc);
        }
        catch (Exception e) {
            log.error("Error saving WORKFLOW event to Solr", (Throwable)e);
        }
    }

    @Override
    public void storeParents(SolrInputDocument doc1, DSpaceObject dso) throws SQLException {
        block6: {
            block8: {
                block7: {
                    block5: {
                        if (!(dso instanceof Community)) break block5;
                        Community comm = (Community)dso;
                        List<Community> parentCommunities = comm.getParentCommunities();
                        for (Community parent : parentCommunities) {
                            doc1.addField("owningComm", (Object)parent.getID().toString());
                            this.storeParents(doc1, parent);
                        }
                        break block6;
                    }
                    if (!(dso instanceof org.dspace.content.Collection)) break block7;
                    org.dspace.content.Collection coll = (org.dspace.content.Collection)dso;
                    List<Community> communities = coll.getCommunities();
                    for (Community community : communities) {
                        doc1.addField("owningComm", (Object)community.getID().toString());
                        this.storeParents(doc1, community);
                    }
                    break block6;
                }
                if (!(dso instanceof Item)) break block8;
                Item item = (Item)dso;
                List<org.dspace.content.Collection> collections = item.getCollections();
                for (org.dspace.content.Collection collection : collections) {
                    doc1.addField("owningColl", (Object)collection.getID().toString());
                    this.storeParents(doc1, collection);
                }
                break block6;
            }
            if (!(dso instanceof Bitstream)) break block6;
            Bitstream bitstream = (Bitstream)dso;
            List<Bundle> bundles = bitstream.getBundles();
            for (Bundle bundle : bundles) {
                List<Item> items = bundle.getItems();
                for (Item item : items) {
                    doc1.addField("owningItem", (Object)item.getID().toString());
                    this.storeParents(doc1, item);
                }
            }
        }
    }

    @Override
    public boolean isUseProxies() {
        return this.clientInfoService.isUseProxiesEnabled();
    }

    @Override
    public void removeIndex(String query) throws IOException, SolrServerException {
        this.solr.deleteByQuery(query);
        this.solr.commit();
    }

    @Override
    public Map<String, List<String>> queryField(String query, List oldFieldVals, String field) throws IOException {
        HashMap<String, List<String>> currentValsStored = new HashMap<String, List<String>>();
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("q", query);
            params.put("rows", "1");
            MapSolrParams solrParams = new MapSolrParams(params);
            QueryResponse response = this.solr.query((SolrParams)solrParams);
            if (response.getResults().getNumFound() == 0L) {
                return currentValsStored;
            }
        }
        catch (SolrServerException e) {
            e.printStackTrace();
        }
        return currentValsStored;
    }

    @Override
    public void markRobots() {
        ResultProcessor processor = new ResultProcessor(){

            @Override
            public void process(SolrInputDocument doc) throws IOException, SolrServerException {
                String agent;
                String hostname;
                String clientIP = (String)doc.getFieldValue("ip");
                if (SpiderDetector.isSpider(clientIP, null, hostname = (String)doc.getFieldValue("dns"), agent = (String)doc.getFieldValue("userAgent"))) {
                    doc.removeField("isBot");
                    doc.addField("isBot", (Object)true);
                    SolrLoggerServiceImpl.this.solr.add(doc);
                    log.info("Marked {} / {} / {} as a robot in record {}.", (Object)clientIP, (Object)hostname, (Object)agent, doc.getField("uid").getValue());
                }
            }
        };
        try {
            processor.execute("-isBot:true");
            this.solr.commit();
        }
        catch (IOException | SolrServerException ex) {
            log.error("Failed while marking robot accesses.", ex);
        }
    }

    @Override
    public void deleteRobots() {
        try {
            this.solr.deleteByQuery("isBot:true");
        }
        catch (IOException | SolrServerException e) {
            log.error("Failed while deleting robot accesses.", e);
        }
    }

    @Override
    public void update(String query, String action, List<String> fieldNames, List<List<Object>> fieldValuesList) throws SolrServerException, IOException {
        this.update(query, action, fieldNames, fieldValuesList, true);
    }

    @Override
    public void update(String query, String action, List<String> fieldNames, List<List<Object>> fieldValuesList, boolean commit) throws SolrServerException, IOException {
        final ArrayList docsToUpdate = new ArrayList();
        ResultProcessor processor = new ResultProcessor(){

            @Override
            public void process(SolrInputDocument document) {
                docsToUpdate.add(document);
            }
        };
        processor.execute(query);
        for (int i = 0; i < docsToUpdate.size(); ++i) {
            SolrInputDocument solrDocument = (SolrInputDocument)docsToUpdate.get(i);
            this.solr.deleteByQuery("uid:" + solrDocument.getFieldValue("uid"));
            for (int j = 0; j < fieldNames.size(); ++j) {
                String fieldName = fieldNames.get(j);
                List<Object> fieldValues = fieldValuesList.get(j);
                if (action.equals("addOne") || action.equals("replace")) {
                    if (action.equals("replace")) {
                        solrDocument.removeField(fieldName);
                    }
                    for (Object fieldValue : fieldValues) {
                        solrDocument.addField(fieldName, fieldValue);
                    }
                    continue;
                }
                if (!action.equals("remOne")) continue;
                Collection values = solrDocument.getFieldValues(fieldName);
                solrDocument.removeField(fieldName);
                for (Object value : values) {
                    if (fieldValues.contains(value)) continue;
                    solrDocument.addField(fieldName, value);
                }
            }
            solrDocument.removeField("_version_");
            this.solr.add(solrDocument);
            if (!commit) continue;
            this.commit();
        }
    }

    @Override
    public void query(String query, int max, int facetMinCount) throws SolrServerException, IOException {
        this.query(query, null, null, 0, max, null, null, null, null, null, false, facetMinCount);
    }

    @Override
    public ObjectCount[] queryFacetField(String query, String filterQuery, String facetField, int max, boolean showTotal, List<String> facetQueries, int facetMinCount) throws SolrServerException, IOException {
        QueryResponse queryResponse = this.query(query, filterQuery, facetField, 0, max, null, null, null, facetQueries, null, false, facetMinCount);
        if (queryResponse == null) {
            return new ObjectCount[0];
        }
        FacetField field = queryResponse.getFacetField(facetField);
        if (0 < field.getValueCount()) {
            ObjectCount[] result = new ObjectCount[field.getValueCount() + (showTotal ? 1 : 0)];
            for (int i = 0; i < field.getValues().size(); ++i) {
                FacetField.Count fieldCount = (FacetField.Count)field.getValues().get(i);
                result[i] = new ObjectCount();
                result[i].setCount(fieldCount.getCount());
                result[i].setValue(fieldCount.getName());
            }
            if (showTotal) {
                result[result.length - 1] = new ObjectCount();
                result[result.length - 1].setCount(queryResponse.getResults().getNumFound());
                result[result.length - 1].setValue("total");
            }
            return result;
        }
        return new ObjectCount[0];
    }

    @Override
    public ObjectCount[] queryFacetDate(String query, String filterQuery, int max, String dateType, String dateStart, String dateEnd, boolean showTotal, Context context, int facetMinCount) throws SolrServerException, IOException {
        QueryResponse queryResponse = this.query(query, filterQuery, null, 0, max, dateType, dateStart, dateEnd, null, null, false, facetMinCount);
        if (queryResponse == null) {
            return new ObjectCount[0];
        }
        List rangeFacets = queryResponse.getFacetRanges();
        for (RangeFacet rangeFacet : rangeFacets) {
            if (!rangeFacet.getName().equalsIgnoreCase("time")) continue;
            RangeFacet timeFacet = rangeFacet;
            ObjectCount[] result = new ObjectCount[timeFacet.getCounts().size() + (showTotal ? 1 : 0)];
            for (int i = 0; i < timeFacet.getCounts().size(); ++i) {
                RangeFacet.Count dateCount = (RangeFacet.Count)timeFacet.getCounts().get(i);
                result[i] = new ObjectCount();
                result[i].setCount(dateCount.getCount());
                result[i].setValue(this.getDateView(dateCount.getValue(), dateType, context));
            }
            if (showTotal) {
                result[result.length - 1] = new ObjectCount();
                result[result.length - 1].setCount(queryResponse.getResults().getNumFound());
                result[result.length - 1].setValue("total");
            }
            return result;
        }
        return new ObjectCount[0];
    }

    @Override
    public Map<String, Integer> queryFacetQuery(String query, String filterQuery, List<String> facetQueries, int facetMinCount) throws SolrServerException, IOException {
        QueryResponse response = this.query(query, filterQuery, null, 0, 1, null, null, null, facetQueries, null, false, facetMinCount);
        return response.getFacetQuery();
    }

    @Override
    public ObjectCount queryTotal(String query, String filterQuery, int facetMinCount) throws SolrServerException, IOException {
        QueryResponse queryResponse = this.query(query, filterQuery, null, 0, -1, null, null, null, null, null, false, facetMinCount);
        ObjectCount objCount = new ObjectCount();
        objCount.setCount(queryResponse.getResults().getNumFound());
        return objCount;
    }

    protected String getDateView(String name, String type, Context context) {
        if (name != null && name.matches("^[0-9]{4}\\-[0-9]{2}.*")) {
            Date date = null;
            try {
                SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT_8601, context.getCurrentLocale());
                date = format.parse(name);
            }
            catch (ParseException e) {
                try {
                    SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT_DCDATE, context.getCurrentLocale());
                    date = format.parse(name);
                }
                catch (ParseException e1) {
                    e1.printStackTrace();
                }
            }
            String dateformatString = "dd-MM-yyyy";
            if ("DAY".equals(type)) {
                dateformatString = "dd-MM-yyyy";
            } else if ("MONTH".equals(type)) {
                dateformatString = "MMMM yyyy";
            } else if ("YEAR".equals(type)) {
                dateformatString = "yyyy";
            }
            SimpleDateFormat simpleFormat = new SimpleDateFormat(dateformatString, context.getCurrentLocale());
            if (date != null) {
                name = simpleFormat.format(date);
            }
        }
        return name;
    }

    @Override
    public QueryResponse query(String query, String filterQuery, String facetField, int rows, int max, String dateType, String dateStart, String dateEnd, List<String> facetQueries, String sort, boolean ascending, int facetMinCount) throws SolrServerException, IOException {
        return this.query(query, filterQuery, facetField, rows, max, dateType, dateStart, dateEnd, facetQueries, sort, ascending, facetMinCount, true);
    }

    @Override
    public QueryResponse query(String query, String filterQuery, String facetField, int rows, int max, String dateType, String dateStart, String dateEnd, List<String> facetQueries, String sort, boolean ascending, int facetMinCount, boolean defaultFilterQueries) throws SolrServerException, IOException {
        QueryResponse response;
        if (this.solr == null) {
            return null;
        }
        SolrQuery solrQuery = new SolrQuery().setRows(Integer.valueOf(rows)).setQuery(query).setFacetMinCount(facetMinCount);
        this.addAdditionalSolrYearCores(solrQuery);
        if (dateType != null) {
            solrQuery.setParam("facet.range", new String[]{"time"}).setParam("f.time.facet.range.end", new String[]{"NOW/" + dateType + dateEnd + dateType}).setParam("f.time.facet.range.gap", new String[]{"+1" + dateType}).setParam("f.time.facet.range.start", new String[]{"NOW/" + dateType + dateStart + dateType + "S"}).setFacet(true);
        }
        if (facetQueries != null) {
            for (int i = 0; i < facetQueries.size(); ++i) {
                String facetQuery = facetQueries.get(i);
                solrQuery.addFacetQuery(facetQuery);
            }
            if (!facetQueries.isEmpty()) {
                solrQuery.setFacet(true);
            }
        }
        if (facetField != null) {
            solrQuery.addFacetField(new String[]{facetField});
        }
        if (max != -1) {
            solrQuery.setFacetLimit(max);
        }
        if (defaultFilterQueries && this.configurationService.getBooleanProperty("solr-statistics.query.filter.isBot", true)) {
            solrQuery.addFilterQuery(new String[]{"-isBot:true"});
        }
        if (sort != null) {
            solrQuery.addSort(sort, ascending ? SolrQuery.ORDER.asc : SolrQuery.ORDER.desc);
        }
        String[] bundles = this.configurationService.getArrayProperty("solr-statistics.query.filter.bundles");
        if (defaultFilterQueries && bundles != null && bundles.length > 0) {
            StringBuilder bundleQuery = new StringBuilder();
            bundleQuery.append("-(bundleName:[* TO *]");
            for (int i = 0; i < bundles.length; ++i) {
                String bundle = bundles[i].trim();
                bundleQuery.append("-bundleName:").append(bundle);
                if (i == bundles.length - 1) continue;
                bundleQuery.append(" AND ");
            }
            bundleQuery.append(")");
            solrQuery.addFilterQuery(new String[]{bundleQuery.toString()});
        }
        if (filterQuery != null) {
            solrQuery.addFilterQuery(new String[]{filterQuery});
        }
        try {
            response = this.solr.query((SolrParams)solrQuery);
        }
        catch (IOException | SolrServerException e) {
            log.error("Error searching Solr usage events using query {}", (Object)query, (Object)e);
            throw e;
        }
        return response;
    }

    @Override
    public void shardSolrIndex() throws IOException, SolrServerException {
        if (!(this.solr instanceof HttpSolrClient)) {
            return;
        }
        SolrQuery yearRangeQuery = new SolrQuery();
        yearRangeQuery.setQuery("*:*");
        yearRangeQuery.setRows(Integer.valueOf(0));
        yearRangeQuery.setFacet(true);
        yearRangeQuery.add("facet.range", new String[]{"time"});
        yearRangeQuery.add("facet.range.start", new String[]{"NOW/YEAR-" + (Calendar.getInstance().get(1) - 2000) + "YEARS"});
        yearRangeQuery.add("facet.range.end", new String[]{"NOW/YEAR+0YEARS"});
        yearRangeQuery.add("facet.range.gap", new String[]{"+1YEAR"});
        yearRangeQuery.add("facet.mincount", new String[]{String.valueOf(1)});
        File tempDirectory = new File(this.configurationService.getProperty("dspace.dir") + File.separator + "temp" + File.separator);
        tempDirectory.mkdirs();
        QueryResponse queryResponse = this.solr.query((SolrParams)yearRangeQuery);
        List yearResults = ((RangeFacet)queryResponse.getFacetRanges().get(0)).getCounts();
        for (RangeFacet.Count count : yearResults) {
            long totalRecords = count.getCount();
            DCDate dcStart = new DCDate(count.getValue());
            Calendar endDate = Calendar.getInstance();
            endDate.setTime(dcStart.toDate());
            endDate.add(1, 1);
            DCDate dcEndDate = new DCDate(endDate.getTime());
            StringBuilder filterQuery = new StringBuilder();
            filterQuery.append("time:([");
            filterQuery.append(ClientUtils.escapeQueryChars((String)dcStart.toString()));
            filterQuery.append(" TO ");
            filterQuery.append(ClientUtils.escapeQueryChars((String)dcEndDate.toString()));
            filterQuery.append("]");
            filterQuery.append(" NOT ").append(ClientUtils.escapeQueryChars((String)dcEndDate.toString()));
            filterQuery.append(")");
            HashMap<String, String> yearQueryParams = new HashMap<String, String>();
            yearQueryParams.put("q", "*:*");
            yearQueryParams.put("rows", String.valueOf(10000));
            yearQueryParams.put("fq", filterQuery.toString());
            yearQueryParams.put("wt", "csv");
            yearQueryParams.put("csv.escape", "\\");
            yearQueryParams.put("csv.mv.separator", MULTIPLE_VALUES_SPLITTER);
            String coreName = this.statisticsCoreBase + "-" + dcStart.getYearUTC();
            HttpSolrClient statisticsYearServer = this.createCore((HttpSolrClient)this.solr, coreName);
            System.out.println("Moving: " + totalRecords + " into core " + coreName);
            log.info("Moving: " + totalRecords + " records into core " + coreName);
            ArrayList<File> filesToUpload = new ArrayList<File>();
            int i = 0;
            while ((long)i < totalRecords) {
                Object solrRequestUrl = ((HttpSolrClient)this.solr).getBaseURL() + "/select";
                solrRequestUrl = this.generateURL((String)solrRequestUrl, yearQueryParams);
                HttpGet get = new HttpGet((String)solrRequestUrl);
                File csvFile = new File(tempDirectory.getPath() + File.separatorChar + "temp." + dcStart.getYearUTC() + "." + i + ".csv");
                try (CloseableHttpClient hc = DSpaceHttpClientFactory.getInstance().buildWithoutProxy();){
                    CloseableHttpResponse response = hc.execute((HttpUriRequest)get);
                    InputStream csvInputstream = response.getEntity().getContent();
                    FileUtils.copyInputStreamToFile((InputStream)csvInputstream, (File)csvFile);
                }
                filesToUpload.add(csvFile);
                yearQueryParams.put("start", String.valueOf(i + 10000));
                i += 10000;
            }
            Set<String> multivaluedFields = this.getMultivaluedFieldNames();
            for (File tempCsv : filesToUpload) {
                ContentStreamUpdateRequest contentStreamUpdateRequest = new ContentStreamUpdateRequest("/update");
                contentStreamUpdateRequest.setParam("stream.contentType", "text/csv;charset=utf-8");
                contentStreamUpdateRequest.setParam("escape", "\\");
                contentStreamUpdateRequest.setParam("skip", "_version_");
                contentStreamUpdateRequest.setAction(AbstractUpdateRequest.ACTION.COMMIT, true, true);
                contentStreamUpdateRequest.addFile(tempCsv, "text/csv;charset=utf-8");
                for (String multivaluedField : multivaluedFields) {
                    contentStreamUpdateRequest.setParam("f." + multivaluedField + ".split", Boolean.TRUE.toString());
                    contentStreamUpdateRequest.setParam("f." + multivaluedField + ".separator", MULTIPLE_VALUES_SPLITTER);
                }
                statisticsYearServer.request((SolrRequest)contentStreamUpdateRequest);
            }
            statisticsYearServer.commit(true, true);
            this.solr.deleteByQuery(filterQuery.toString());
            this.solr.commit(true, true);
            log.info("Moved {} records into core: {}", (Object)totalRecords, (Object)coreName);
        }
        FileUtils.deleteDirectory((File)tempDirectory);
    }

    protected HttpSolrClient createCore(HttpSolrClient solr, String coreName) throws IOException, SolrServerException {
        String baseSolrUrl = solr.getBaseURL().replace(this.statisticsCoreBase, "");
        HttpSolrClient returnServer = new HttpSolrClient.Builder(baseSolrUrl + coreName).build();
        try {
            SolrPingResponse ping = returnServer.ping();
            log.debug("Ping of Solr Core {} returned with Status {}", (Object)coreName, (Object)ping.getStatus());
            return returnServer;
        }
        catch (IOException | SolrServerException | HttpSolrClient.RemoteSolrException e) {
            log.debug("Ping of Solr Core {} failed with {}.  New Core Will be Created", (Object)coreName, (Object)e.getClass().getName());
            CoreAdminRequest.Create create = new CoreAdminRequest.Create();
            create.setCoreName(coreName);
            String configSetName = this.configurationService.getProperty("solr-statistics.configset", "statistics");
            create.setConfigSet(configSetName);
            create.setInstanceDir(coreName);
            HttpSolrClient solrServer = new HttpSolrClient.Builder(baseSolrUrl).build();
            create.process((SolrClient)solrServer);
            log.info("Created core with name: {} from configset {}", (Object)coreName, (Object)configSetName);
            return returnServer;
        }
    }

    public Set<String> getMultivaluedFieldNames() throws SolrServerException, IOException {
        HashSet<String> multivaluedFields = new HashSet<String>();
        LukeRequest lukeRequest = new LukeRequest();
        lukeRequest.setShowSchema(true);
        LukeResponse process = (LukeResponse)lukeRequest.process(this.solr);
        Map fields = process.getFieldInfo();
        for (String fieldName : fields.keySet()) {
            LukeResponse.FieldInfo fieldInfo = (LukeResponse.FieldInfo)fields.get(fieldName);
            EnumSet flags = fieldInfo.getFlags();
            for (FieldFlag fieldFlag : flags) {
                if (fieldFlag.getAbbreviation() != FieldFlag.MULTI_VALUED.getAbbreviation()) continue;
                multivaluedFields.add(fieldName);
            }
        }
        return multivaluedFields;
    }

    @Override
    public void reindexBitstreamHits(boolean removeDeletedBitstreams) throws Exception {
        if (!(this.solr instanceof HttpSolrClient)) {
            return;
        }
        Context context = new Context();
        try {
            SolrQuery query = new SolrQuery();
            query.setQuery("*:*");
            query.addFilterQuery(new String[]{"type:0"});
            query.addFilterQuery(new String[]{"-bundleName:[* TO *]"});
            query.setRows(Integer.valueOf(0));
            this.addAdditionalSolrYearCores(query);
            long totalRecords = this.solr.query((SolrParams)query).getResults().getNumFound();
            File tempDirectory = new File(this.configurationService.getProperty("dspace.dir") + File.separator + "temp" + File.separator);
            tempDirectory.mkdirs();
            ArrayList<File> tempCsvFiles = new ArrayList<File>();
            int i = 0;
            while ((long)i < totalRecords) {
                List rows;
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("q", "*:*");
                params.put("fq", "-bundleName:[* TO *] AND type:0");
                params.put("wt", "csv");
                params.put("rows", String.valueOf(10000));
                params.put("start", String.valueOf(i));
                Object solrRequestUrl = ((HttpSolrClient)this.solr).getBaseURL() + "/select";
                solrRequestUrl = this.generateURL((String)solrRequestUrl, params);
                HttpGet get = new HttpGet((String)solrRequestUrl);
                try (CloseableHttpClient hc = DSpaceHttpClientFactory.getInstance().buildWithoutProxy();){
                    CloseableHttpResponse response = hc.execute((HttpUriRequest)get);
                    InputStream csvOutput = response.getEntity().getContent();
                    InputStreamReader csvReader = new InputStreamReader(csvOutput);
                    rows = new CSVReader((Reader)csvReader).readAll();
                }
                String[][] csvParsed = (String[][])rows.toArray((T[])new String[rows.size()][]);
                Object[] header = csvParsed[0];
                int idIndex = 0;
                for (int j = 0; j < header.length; ++j) {
                    if (!header[j].equals("id")) continue;
                    idIndex = j;
                }
                File tempCsv = new File(tempDirectory.getPath() + File.separatorChar + "temp." + i + ".csv");
                tempCsvFiles.add(tempCsv);
                CSVWriter csvp = new CSVWriter((Writer)new FileWriter(tempCsv));
                csvp.writeNext((String[])ArrayUtils.add((Object[])header, (Object)"bundleName"));
                HashMap<String, String> bitBundleCache = new HashMap<String, String>();
                for (int j = 1; j < csvParsed.length; ++j) {
                    Object[] csvLine = csvParsed[j];
                    String bitstreamId = csvLine[idIndex];
                    String bundleName = (String)bitBundleCache.get(bitstreamId);
                    if (bundleName == null) {
                        Bitstream bitstream = (Bitstream)this.bitstreamService.findByIdOrLegacyId(context, bitstreamId);
                        if (bitstream != null) {
                            List<Bundle> bundles = bitstream.getBundles();
                            if (bundles != null && 0 < bundles.size()) {
                                Bundle bundle = bundles.get(0);
                                bundleName = bundle.getName();
                            } else {
                                DSpaceObject parentObject = this.bitstreamService.getParentObject(context, bitstream);
                                if (parentObject instanceof org.dspace.content.Collection) {
                                    bundleName = "LOGO-COLLECTION";
                                } else if (parentObject instanceof Community) {
                                    bundleName = "LOGO-COMMUNITY";
                                }
                            }
                            bitBundleCache.put(bitstream.getID().toString(), bundleName);
                        }
                        if (bundleName == null && !removeDeletedBitstreams) {
                            bundleName = "BITSTREAM_DELETED";
                        }
                    }
                    csvp.writeNext((String[])ArrayUtils.add((Object[])csvLine, (Object)bundleName));
                }
                csvp.flush();
                csvp.close();
                i += 10000;
            }
            for (File tempCsv : tempCsvFiles) {
                ContentStreamUpdateRequest contentStreamUpdateRequest = new ContentStreamUpdateRequest("/update");
                contentStreamUpdateRequest.setParam("stream.contentType", "text/csv;charset=utf-8");
                contentStreamUpdateRequest.setAction(AbstractUpdateRequest.ACTION.COMMIT, true, true);
                contentStreamUpdateRequest.addFile(tempCsv, "text/csv;charset=utf-8");
                this.solr.request((SolrRequest)contentStreamUpdateRequest);
            }
            this.solr.deleteByQuery("-bundleName:[* TO *] AND type:0");
            this.solr.commit(true, true);
            FileUtils.deleteDirectory((File)tempDirectory);
        }
        catch (Exception e) {
            log.error("Error while updating the bitstream statistics", (Throwable)e);
            throw e;
        }
        finally {
            context.abort();
        }
    }

    @Override
    public void exportHits() throws Exception {
        Context context = new Context();
        File tempDirectory = new File(this.configurationService.getProperty("dspace.dir") + File.separator + "temp" + File.separator);
        tempDirectory.mkdirs();
        try {
            SolrQuery query = new SolrQuery();
            query.setQuery("*:*");
            ModifiableSolrParams solrParams = new ModifiableSolrParams();
            solrParams.set("q", new String[]{"statistics_type:view OR (*:* AND -statistics_type:*)"});
            solrParams.set("wt", new String[]{"javabin"});
            solrParams.set("rows", new String[]{String.valueOf(10000)});
            this.addAdditionalSolrYearCores(query);
            long totalRecords = this.solr.query((SolrParams)query).getResults().getNumFound();
            System.out.println("There are " + totalRecords + " usage events in SOLR for download/view.");
            int i = 0;
            while ((long)i < totalRecords) {
                solrParams.set("start", new String[]{String.valueOf(i)});
                QueryResponse queryResponse = this.solr.query((SolrParams)solrParams);
                SolrDocumentList docs = queryResponse.getResults();
                File exportOutput = new File(tempDirectory.getPath() + File.separatorChar + "usagestats_" + i + ".csv");
                exportOutput.delete();
                this.addDocumentsToFile(context, docs, exportOutput);
                System.out.println("Export hits [" + i + " - " + String.valueOf(i + 9999) + "] to " + exportOutput.getCanonicalPath());
                i += 10000;
            }
        }
        catch (Exception e) {
            log.error("Error while exporting SOLR data", (Throwable)e);
            throw e;
        }
        finally {
            context.abort();
        }
    }

    @Override
    public void commit() throws IOException, SolrServerException {
        this.solr.commit();
    }

    protected void addDocumentsToFile(Context context, SolrDocumentList docs, File exportOutput) throws SQLException, ParseException, IOException {
        for (SolrDocument doc : docs) {
            String ip = doc.get((Object)"ip").toString();
            if (ip.equals("::1")) {
                ip = "127.0.0.1";
            }
            String id = doc.get((Object)"id").toString();
            String type = doc.get((Object)"type").toString();
            String time = doc.get((Object)"time").toString();
            DSpaceObjectLegacySupportService<? extends DSpaceObject> dsoService = this.contentServiceFactory.getDSpaceLegacyObjectService(Integer.parseInt(type));
            DSpaceObject dso = dsoService.findByIdOrLegacyId(context, id);
            if (dso == null) {
                log.debug("Document no longer exists in DB. type:" + type + " id:" + id);
                continue;
            }
            SimpleDateFormat inputDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy");
            Date solrDate = inputDateFormat.parse(time);
            SimpleDateFormat outputDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            String out = time + ",view_" + this.contentServiceFactory.getDSpaceObjectService(dso).getTypeText(dso).toLowerCase() + "," + id + "," + outputDateFormat.format(solrDate) + ",anonymous," + ip + "\n";
            FileUtils.writeStringToFile((File)exportOutput, (String)out, (Charset)StandardCharsets.UTF_8, (boolean)true);
        }
    }

    protected String generateURL(String baseURL, Map<String, String> parameters) throws UnsupportedEncodingException {
        boolean first = true;
        StringBuilder result = new StringBuilder(baseURL);
        for (String key : parameters.keySet()) {
            if (first) {
                result.append("?");
                first = false;
            } else {
                result.append("&");
            }
            result.append(key).append("=").append(URLEncoder.encode(parameters.get(key), "UTF-8"));
        }
        return result.toString();
    }

    protected void addAdditionalSolrYearCores(SolrQuery solrQuery) {
        this.initSolrYearCores();
        if (0 < statisticYearCores.size()) {
            solrQuery.add("shards", new String[]{StringUtils.join(statisticYearCores.iterator(), (String)",")});
        }
    }

    protected synchronized void initSolrYearCores() {
        if (statisticYearCoresInit || !(this.solr instanceof HttpSolrClient) || !this.configurationService.getBooleanProperty("usage-statistics.shardedByYear", false)) {
            return;
        }
        String baseSolrUrl = ((HttpSolrClient)this.solr).getBaseURL().replace(this.statisticsCoreBase, "");
        try (HttpSolrClient enumClient = new HttpSolrClient.Builder(baseSolrUrl).build();){
            CoreAdminRequest coresRequest = new CoreAdminRequest();
            coresRequest.setAction(CoreAdminParams.CoreAdminAction.STATUS);
            CoreAdminResponse coresResponse = (CoreAdminResponse)coresRequest.process((SolrClient)enumClient);
            NamedList response = coresResponse.getResponse();
            NamedList coreStatuses = (NamedList)response.get("status");
            ArrayList<String> statCoreNames = new ArrayList<String>(coreStatuses.size());
            for (Map.Entry coreStatus : coreStatuses) {
                String coreName = (String)coreStatus.getKey();
                if (!coreName.startsWith(this.statisticsCoreBase)) continue;
                statCoreNames.add(coreName);
            }
            for (String statCoreName : statCoreNames) {
                log.info("Loading core with name: " + statCoreName);
                this.createCore((HttpSolrClient)this.solr, statCoreName);
                statisticYearCores.add(baseSolrUrl.replace("http://", "").replace("https://", "") + statCoreName);
            }
            String baseCore = ((HttpSolrClient)this.solr).getBaseURL().replace("http://", "").replace("https://", "");
            if (!statisticYearCores.contains(baseCore)) {
                statisticYearCores.add(baseCore);
            }
        }
        catch (IOException | SolrServerException e) {
            log.error(e.getMessage(), e);
        }
        statisticYearCoresInit = true;
    }

    @Override
    public Object anonymizeIp(String ip) throws UnknownHostException {
        InetAddress address = InetAddress.getByName(ip);
        if (address instanceof Inet4Address) {
            return ip.replaceFirst(IP_V4_REGEX, "$1" + this.configurationService.getProperty("anonymize_statistics.ip_v4_mask", "255"));
        }
        if (address instanceof Inet6Address) {
            return ip.replaceFirst(IP_V6_REGEX, "$1:" + this.configurationService.getProperty("anonymize_statistics.ip_v6_mask", "FFFF:FFFF"));
        }
        throw new UnknownHostException("unknown ip format");
    }

    public static enum StatisticsType {
        VIEW("view"),
        SEARCH("search"),
        SEARCH_RESULT("search_result"),
        WORKFLOW("workflow");

        private final String text;

        private StatisticsType(String text) {
            this.text = text;
        }

        public String text() {
            return this.text;
        }
    }

    public class ResultProcessor {
        private SolrInputDocument toSolrInputDocument(SolrDocument d) {
            SolrInputDocument doc = new SolrInputDocument(new String[0]);
            for (String name : d.getFieldNames()) {
                doc.addField(name, d.getFieldValue(name));
            }
            return doc;
        }

        public void execute(String query) throws SolrServerException, IOException {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("q", query);
            params.put("rows", "10");
            if (0 < statisticYearCores.size()) {
                params.put("shards", StringUtils.join(statisticYearCores.iterator(), (char)','));
            }
            MapSolrParams solrParams = new MapSolrParams(params);
            QueryResponse response = SolrLoggerServiceImpl.this.solr.query((SolrParams)solrParams);
            SolrDocumentList results = response.getResults();
            long numbFound = results.getNumFound();
            for (SolrDocument result : results) {
                this.process(this.toSolrInputDocument(result));
            }
            int i = 10;
            while ((long)i < numbFound) {
                params.put("start", String.valueOf(i));
                solrParams = new MapSolrParams(params);
                response = SolrLoggerServiceImpl.this.solr.query((SolrParams)solrParams);
                results = response.getResults();
                for (SolrDocument result : results) {
                    this.process(this.toSolrInputDocument(result));
                }
                i += 10;
            }
        }

        public void commit() throws IOException, SolrServerException {
            SolrLoggerServiceImpl.this.solr.commit();
        }

        public void process(List<SolrInputDocument> docs) throws IOException, SolrServerException {
            for (SolrInputDocument doc : docs) {
                this.process(doc);
            }
        }

        public void process(SolrInputDocument doc) throws IOException, SolrServerException {
        }
    }
}

