/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.correctiontype.service.impl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.correctiontype.CorrectionType;
import org.dspace.correctiontype.service.CorrectionTypeService;
import org.springframework.beans.factory.annotation.Autowired;

public class CorrectionTypeServiceImpl
implements CorrectionTypeService {
    @Autowired
    private List<CorrectionType> correctionTypes;

    @Override
    public CorrectionType findOne(String id) {
        return this.findAll().stream().filter(correctionType -> correctionType.getId().equals(id)).findFirst().orElse(null);
    }

    @Override
    public List<CorrectionType> findAll() {
        return CollectionUtils.isNotEmpty(this.correctionTypes) ? this.correctionTypes : List.of();
    }

    @Override
    public List<CorrectionType> findByItem(Context context, Item item) throws AuthorizeException, SQLException {
        ArrayList<CorrectionType> correctionTypes = new ArrayList<CorrectionType>();
        for (CorrectionType correctionType : this.findAll()) {
            if (!correctionType.isAllowed(context, item)) continue;
            correctionTypes.add(correctionType);
        }
        return correctionTypes;
    }

    @Override
    public CorrectionType findByTopic(String topic) {
        return this.findAll().stream().filter(correctionType -> correctionType.getTopic().equals(topic)).findFirst().orElse(null);
    }
}

