/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.contentreport;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.services.factory.DSpaceServicesFactory;

public class ItemFilterUtil {
    protected static ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    private static final Logger log = LogManager.getLogger(ItemFilterUtil.class);
    public static final String[] MIMES_PDF = new String[]{"application/pdf"};
    public static final String[] MIMES_JPG = new String[]{"image/jpeg"};

    private ItemFilterUtil() {
    }

    static String[] getDocumentMimeTypes() {
        return DSpaceServicesFactory.getInstance().getConfigurationService().getArrayProperty("rest.report-mime-document");
    }

    static String[] getSupportedDocumentMimeTypes() {
        return DSpaceServicesFactory.getInstance().getConfigurationService().getArrayProperty("rest.report-mime-document-supported");
    }

    static String[] getSupportedImageMimeTypes() {
        return DSpaceServicesFactory.getInstance().getConfigurationService().getArrayProperty("rest.report-mime-document-image");
    }

    static int countOriginalBitstream(Item item) {
        return ItemFilterUtil.countBitstream(BundleName.ORIGINAL, item);
    }

    static int countBitstream(BundleName bundleName, Item item) {
        return item.getBundles().stream().filter(bundle -> bundle.getName().equals(bundleName.name())).mapToInt(bundle -> bundle.getBitstreams().size()).sum();
    }

    static List<String> getBitstreamNames(BundleName bundleName, Item item) {
        return item.getBundles().stream().filter(bundle -> bundle.getName().equals(bundleName.name())).map(Bundle::getBitstreams).flatMap(Collection::stream).map(Bitstream::getName).collect(Collectors.toList());
    }

    static int countOriginalBitstreamMime(Context context, Item item, String[] mimeList) {
        return ItemFilterUtil.countBitstreamMime(context, BundleName.ORIGINAL, item, mimeList);
    }

    static int countBitstreamMime(Context context, BundleName bundleName, Item item, String[] mimeList) {
        return item.getBundles().stream().filter(bundle -> bundle.getName().equals(bundleName.name())).map(Bundle::getBitstreams).flatMap(Collection::stream).mapToInt(bit -> {
            int count = 0;
            for (String mime : mimeList) {
                try {
                    if (!bit.getFormat(context).getMIMEType().equals(mime.trim())) continue;
                    ++count;
                }
                catch (SQLException e) {
                    log.error("Get format error for bitstream " + bit.getName());
                }
            }
            return count;
        }).sum();
    }

    static int countBitstreamByDesc(BundleName bundleName, Item item, String[] descList) {
        return item.getBundles().stream().filter(bundle -> bundle.getName().equals(bundleName.name())).map(Bundle::getBitstreams).flatMap(Collection::stream).filter(bit -> bit.getDescription() != null).mapToInt(bit -> {
            int count = 0;
            for (String desc : descList) {
                String bitDesc = bit.getDescription();
                if (!bitDesc.equals(desc.trim())) continue;
                ++count;
            }
            return count;
        }).sum();
    }

    static int countBitstreamSmallerThanMinSize(Context context, BundleName bundleName, Item item, String[] mimeList, String prop) {
        long size = DSpaceServicesFactory.getInstance().getConfigurationService().getLongProperty(prop);
        return item.getBundles().stream().filter(bundle -> bundle.getName().equals(bundleName.name())).map(Bundle::getBitstreams).flatMap(Collection::stream).mapToInt(bit -> {
            int count = 0;
            for (String mime : mimeList) {
                try {
                    if (!bit.getFormat(context).getMIMEType().equals(mime.trim()) || bit.getSizeBytes() >= size) continue;
                    ++count;
                }
                catch (SQLException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            return count;
        }).sum();
    }

    static int countBitstreamLargerThanMaxSize(Context context, BundleName bundleName, Item item, String[] mimeList, String prop) {
        long size = DSpaceServicesFactory.getInstance().getConfigurationService().getLongProperty(prop);
        return item.getBundles().stream().filter(bundle -> bundle.getName().equals(bundleName.name())).map(Bundle::getBitstreams).flatMap(Collection::stream).mapToInt(bit -> {
            int count = 0;
            for (String mime : mimeList) {
                try {
                    if (!bit.getFormat(context).getMIMEType().equals(mime.trim()) || bit.getSizeBytes() <= size) continue;
                    ++count;
                }
                catch (SQLException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            return count;
        }).sum();
    }

    static int countOriginalBitstreamMimeStartsWith(Context context, Item item, String prefix) {
        return ItemFilterUtil.countBitstreamMimeStartsWith(context, BundleName.ORIGINAL, item, prefix);
    }

    static int countBitstreamMimeStartsWith(Context context, BundleName bundleName, Item item, String prefix) {
        return item.getBundles().stream().filter(bundle -> bundle.getName().equals(bundleName.name())).map(Bundle::getBitstreams).flatMap(Collection::stream).mapToInt(bit -> {
            int count = 0;
            try {
                if (bit.getFormat(context).getMIMEType().startsWith(prefix)) {
                    ++count;
                }
            }
            catch (SQLException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            return count;
        }).sum();
    }

    static boolean hasUnsupportedBundle(Item item, String[] bundleList) {
        if (bundleList == null) {
            return false;
        }
        Set bundles = Arrays.stream(bundleList).collect(Collectors.toSet());
        return item.getBundles().stream().anyMatch(bundle -> !bundles.contains(bundle.getName()));
    }

    static boolean hasOriginalBitstreamMime(Context context, Item item, String[] mimeList) {
        return ItemFilterUtil.hasBitstreamMime(context, BundleName.ORIGINAL, item, mimeList);
    }

    static boolean hasBitstreamMime(Context context, BundleName bundleName, Item item, String[] mimeList) {
        return ItemFilterUtil.countBitstreamMime(context, bundleName, item, mimeList) > 0;
    }

    static boolean hasMetadataMatch(Item item, String fieldList, Pattern regex) {
        if ("*".equals(fieldList)) {
            return itemService.getMetadata(item, "*", "*", "*", "*").stream().anyMatch(md -> regex.matcher(md.getValue()).matches());
        }
        return Arrays.stream(fieldList.split(",")).map(field -> itemService.getMetadataByMetadataString(item, field.trim())).flatMap(Collection::stream).anyMatch(md -> regex.matcher(md.getValue()).matches());
    }

    static boolean hasOnlyMetadataMatch(Item item, String fieldList, Pattern regex) {
        if ("*".equals(fieldList)) {
            return itemService.getMetadata(item, "*", "*", "*", "*").stream().allMatch(md -> regex.matcher(md.getValue()).matches());
        }
        return Arrays.stream(fieldList.split(",")).map(field -> itemService.getMetadataByMetadataString(item, field.trim())).flatMap(Collection::stream).allMatch(md -> regex.matcher(md.getValue()).matches());
    }

    static boolean recentlyModified(Item item, int days) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -days);
        return cal.getTime().before(item.getLastModified());
    }

    static enum BundleName {
        ORIGINAL,
        TEXT,
        LICENSE,
        THUMBNAIL;

    }
}

