/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.dao.impl;

import jakarta.persistence.Query;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import org.dspace.authorize.ResourcePolicy_;
import org.dspace.content.Community;
import org.dspace.content.Community_;
import org.dspace.content.MetadataField;
import org.dspace.content.dao.CommunityDAO;
import org.dspace.core.AbstractHibernateDSODAO;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;

public class CommunityDAOImpl
extends AbstractHibernateDSODAO<Community>
implements CommunityDAO {
    protected CommunityDAOImpl() {
    }

    @Override
    public List<Community> findAll(Context context, MetadataField sortField) throws SQLException {
        return this.findAll(context, sortField, null, null);
    }

    @Override
    public List<Community> findAll(Context context, MetadataField sortField, Integer limit, Integer offset) throws SQLException {
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append("SELECT c FROM Community c left join c.metadata title on title.metadataField = :sortField and title.dSpaceObject = c and title.place = (select min(internal.place) from c.metadata internal where internal.metadataField = :sortField and internal.dSpaceObject = c) ORDER BY LOWER(CAST(title.value as string))");
        Query query = this.createQuery(context, queryBuilder.toString());
        if (offset != null) {
            query.setFirstResult(offset.intValue());
        }
        if (limit != null) {
            query.setMaxResults(limit.intValue());
        }
        query.setParameter("sortField", (Object)sortField);
        return this.list(query);
    }

    @Override
    public Community findByAdminGroup(Context context, Group group) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Community> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Community.class);
        Root communityRoot = criteriaQuery.from(Community.class);
        criteriaQuery.select((Selection)communityRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)communityRoot.get(Community_.admins), (Object)group));
        return (Community)this.singleResult(context, criteriaQuery);
    }

    @Override
    public List<Community> findAllNoParent(Context context, MetadataField sortField) throws SQLException {
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append("SELECT c FROM Community c left join c.metadata title on title.metadataField = :sortField and title.dSpaceObject = c and title.place = (select min(internal.place) from c.metadata internal where internal.metadataField = :sortField and internal.dSpaceObject = c) WHERE c.parentCommunities IS EMPTY  ORDER BY LOWER(CAST(title.value as string))");
        Query query = this.createQuery(context, queryBuilder.toString());
        query.setParameter("sortField", (Object)sortField);
        query.setHint("org.hibernate.cacheable", (Object)Boolean.TRUE);
        return this.findMany(context, query);
    }

    @Override
    public List<Community> findAuthorized(Context context, EPerson ePerson, List<Integer> actions) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Community> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Community.class);
        Root communityRoot = criteriaQuery.from(Community.class);
        Join join = communityRoot.join("resourcePolicies");
        LinkedList<Predicate> orPredicates = new LinkedList<Predicate>();
        for (Integer action : actions) {
            orPredicates.add(criteriaBuilder.equal((Expression)join.get(ResourcePolicy_.actionId), (Object)action));
        }
        Predicate orPredicate = criteriaBuilder.or(orPredicates.toArray(new Predicate[0]));
        criteriaQuery.select((Selection)communityRoot);
        criteriaQuery.where((Expression)criteriaBuilder.and(new Predicate[]{criteriaBuilder.equal((Expression)join.get(ResourcePolicy_.resourceTypeId), (Object)4), criteriaBuilder.equal((Expression)join.get(ResourcePolicy_.eperson), (Object)ePerson), orPredicate}));
        return this.list(context, criteriaQuery, true, Community.class, -1, -1);
    }

    @Override
    public List<Community> findAuthorizedByGroup(Context context, EPerson ePerson, List<Integer> actions) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select c from Community c join c.resourcePolicies rp join rp.epersonGroup rpGroup WHERE ");
        for (int i = 0; i < actions.size(); ++i) {
            Integer action = actions.get(i);
            if (i != 0) {
                query.append(" AND ");
            }
            query.append("rp.actionId=").append(action);
        }
        query.append(" AND rp.resourceTypeId=").append(4);
        query.append(" AND rp.epersonGroup.id IN (select g.id from Group g where (from EPerson e where e.id = :eperson_id) in elements(epeople))");
        Query persistenceQuery = this.createQuery(context, query.toString());
        persistenceQuery.setParameter("eperson_id", (Object)ePerson.getID());
        persistenceQuery.setHint("org.hibernate.cacheable", (Object)Boolean.TRUE);
        return this.list(persistenceQuery);
    }

    @Override
    public int countRows(Context context) throws SQLException {
        return this.count(this.createQuery(context, "SELECT count(*) FROM Community"));
    }
}

