/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.ldn;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.ldn.LDNMessageEntity;
import org.dspace.app.ldn.processor.LDNProcessor;

public class LDNRouter {
    private Map<Set<String>, LDNProcessor> incomingProcessors = new HashMap<Set<String>, LDNProcessor>();
    private Map<Set<String>, LDNProcessor> outcomingProcessors = new HashMap<Set<String>, LDNProcessor>();
    private static final Logger log = LogManager.getLogger(LDNRouter.class);

    public LDNProcessor route(LDNMessageEntity ldnMessage) {
        if (ldnMessage == null) {
            log.warn("A null LDNMessage was received and could not be routed.");
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)ldnMessage.getType())) {
            log.warn("LDNMessage " + ldnMessage + " was received. It has no type, so it couldn't be routed.");
            return null;
        }
        HashSet<String> ldnMessageTypeSet = new HashSet<String>();
        ldnMessageTypeSet.add(ldnMessage.getActivityStreamType());
        ldnMessageTypeSet.add(ldnMessage.getCoarNotifyType());
        LDNProcessor processor = null;
        if (ldnMessage.getTarget() == null) {
            processor = this.incomingProcessors.get(ldnMessageTypeSet);
        } else if (ldnMessage.getOrigin() == null) {
            processor = this.outcomingProcessors.get(ldnMessageTypeSet);
        }
        return processor;
    }

    public Map<Set<String>, LDNProcessor> getIncomingProcessors() {
        return this.incomingProcessors;
    }

    public void setIncomingProcessors(Map<Set<String>, LDNProcessor> incomingProcessors) {
        this.incomingProcessors = incomingProcessors;
    }

    public Map<Set<String>, LDNProcessor> getOutcomingProcessors() {
        return this.outcomingProcessors;
    }

    public void setOutcomingProcessors(Map<Set<String>, LDNProcessor> outcomingProcessors) {
        this.outcomingProcessors = outcomingProcessors;
    }
}

