/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.dao.impl;

import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.ResourcePolicy_;
import org.dspace.content.Collection;
import org.dspace.content.Collection_;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.dao.CollectionDAO;
import org.dspace.core.AbstractHibernateDSODAO;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;

public class CollectionDAOImpl
extends AbstractHibernateDSODAO<Collection>
implements CollectionDAO {
    private static Logger log = LogManager.getLogger(CollectionDAOImpl.class);

    protected CollectionDAOImpl() {
    }

    @Override
    public List<Collection> findAll(Context context, MetadataField order) throws SQLException {
        return this.findAll(context, order, null, null);
    }

    @Override
    public List<Collection> findAll(Context context, MetadataField order, Integer limit, Integer offset) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("SELECT c FROM Collection c left join c.metadata title on title.metadataField = :sortField and title.dSpaceObject = c.id and title.place = (select min(internal.place) from c.metadata internal where internal.metadataField = :sortField and internal.dSpaceObject = c.id) ORDER BY LOWER(title.value)");
        Query hibernateQuery = this.createQuery(context, query.toString());
        if (offset != null) {
            hibernateQuery.setFirstResult(offset.intValue());
        }
        if (limit != null) {
            hibernateQuery.setMaxResults(limit.intValue());
        }
        hibernateQuery.setParameter("sortField", (Object)order);
        return this.list(hibernateQuery);
    }

    @Override
    public Collection findByTemplateItem(Context context, Item item) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Collection> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Collection.class);
        Root collectionRoot = criteriaQuery.from(Collection.class);
        criteriaQuery.select((Selection)collectionRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)collectionRoot.get(Collection_.template), (Object)item));
        return this.uniqueResult(context, criteriaQuery, false, Collection.class);
    }

    @Override
    public Collection findByGroup(Context context, Group group) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Collection> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Collection.class);
        Root collectionRoot = criteriaQuery.from(Collection.class);
        criteriaQuery.select((Selection)collectionRoot);
        criteriaQuery.where((Expression)criteriaBuilder.or((Expression)criteriaBuilder.equal((Expression)collectionRoot.get(Collection_.submitters), (Object)group), (Expression)criteriaBuilder.equal((Expression)collectionRoot.get(Collection_.admins), (Object)group)));
        return (Collection)this.singleResult(context, criteriaQuery);
    }

    @Override
    public List<Collection> findAuthorized(Context context, EPerson ePerson, List<Integer> actions) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Collection> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Collection.class);
        Root collectionRoot = criteriaQuery.from(Collection.class);
        Join join = collectionRoot.join("resourcePolicies");
        ArrayList<Predicate> orPredicates = new ArrayList<Predicate>(actions.size());
        for (Integer action : actions) {
            orPredicates.add(criteriaBuilder.equal((Expression)join.get(ResourcePolicy_.actionId), (Object)action));
        }
        Predicate orPredicate = criteriaBuilder.or(orPredicates.toArray(new Predicate[0]));
        criteriaQuery.select((Selection)collectionRoot);
        criteriaQuery.where((Expression)criteriaBuilder.and(new Predicate[]{criteriaBuilder.equal((Expression)join.get(ResourcePolicy_.resourceTypeId), (Object)3), criteriaBuilder.equal((Expression)join.get(ResourcePolicy_.eperson), (Object)ePerson), orPredicate}));
        return this.list(context, criteriaQuery, true, Collection.class, -1, -1);
    }

    @Override
    public List<Collection> findAuthorizedByGroup(Context context, EPerson ePerson, List<Integer> actions) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select c from Collection c join c.resourcePolicies rp join rp.epersonGroup rpGroup WHERE ");
        for (int i = 0; i < actions.size(); ++i) {
            Integer action = actions.get(i);
            if (i != 0) {
                query.append(" AND ");
            }
            query.append("rp.actionId=").append(action);
        }
        query.append(" AND rp.resourceTypeId=").append(3);
        query.append(" AND rp.epersonGroup.id IN (select g.id from Group g where (from EPerson e where e.id = :eperson_id) in elements(epeople))");
        Query persistenceQuery = this.createQuery(context, query.toString());
        persistenceQuery.setParameter("eperson_id", (Object)ePerson.getID());
        persistenceQuery.setHint("org.hibernate.cacheable", (Object)Boolean.TRUE);
        return this.list(persistenceQuery);
    }

    @Override
    public List<Collection> findAuthorizedByEPerson(Context context, EPerson ePerson, List<Integer> actions) throws SQLException {
        ArrayList<Group> directGroups = new ArrayList<Group>(ePerson.getGroups());
        HashSet<Group> allGroups = new HashSet<Group>(directGroups);
        LinkedList<Group> queue = new LinkedList<Group>(directGroups);
        while (!queue.isEmpty()) {
            Group current = (Group)queue.poll();
            List<Group> parents = current.getParentGroups();
            for (Group parent : parents) {
                if (!allGroups.add(parent)) continue;
                queue.add(parent);
            }
        }
        CriteriaBuilder cb = this.getCriteriaBuilder(context);
        CriteriaQuery<Collection> cq = this.getCriteriaQuery(cb, Collection.class);
        Root collectionRoot = cq.from(Collection.class);
        Join rpJoin = collectionRoot.join("resourcePolicies");
        cq.select((Selection)collectionRoot).distinct(true);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>(actions.size());
        predicates.add(cb.equal((Expression)rpJoin.get(ResourcePolicy_.resourceTypeId), (Object)3));
        if (actions != null && !actions.isEmpty()) {
            predicates.add(rpJoin.get(ResourcePolicy_.actionId).in(actions));
        }
        Predicate epersonPredicate = cb.equal((Expression)rpJoin.get(ResourcePolicy_.eperson), (Object)ePerson);
        Predicate groupPredicate = cb.disjunction();
        if (allGroups != null && !allGroups.isEmpty()) {
            groupPredicate = rpJoin.get(ResourcePolicy_.epersonGroup).in(allGroups);
        }
        Predicate accessPredicate = cb.or((Expression)epersonPredicate, (Expression)groupPredicate);
        predicates.add(accessPredicate);
        cq.where((Expression)cb.and(predicates.toArray(new Predicate[0])));
        return this.list(context, cq, true, Collection.class, -1, -1);
    }

    @Override
    public List<Collection> findCollectionsWithSubscribers(Context context) throws SQLException {
        return this.list(this.createQuery(context, "SELECT DISTINCT c FROM Collection c JOIN Subscription s ON c = s.dSpaceObject"));
    }

    @Override
    public int countRows(Context context) throws SQLException {
        return this.count(this.createQuery(context, "SELECT count(*) FROM Collection"));
    }

    @Override
    public List<Map.Entry<Collection, Long>> getCollectionsWithBitstreamSizesTotal(Context context) throws SQLException {
        String q = "select col.id, sum(bit.sizeBytes) as totalBytes from Item i join i.collections col join i.bundles bun join bun.bitstreams bit group by col.id";
        Query query = this.createQuery(context, q);
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        List list = query.getResultList();
        ArrayList<Map.Entry<Collection, Long>> returnList = new ArrayList<Map.Entry<Collection, Long>>(list.size());
        for (Object[] o : list) {
            CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Collection.class);
            Root collectionRoot = criteriaQuery.from(Collection.class);
            criteriaQuery.select((Selection)collectionRoot).where((Expression)criteriaBuilder.equal((Expression)collectionRoot.get("id"), (Object)((UUID)o[0])));
            Query collectionQuery = this.createQuery(context, criteriaQuery);
            Collection collection = (Collection)collectionQuery.getSingleResult();
            if (collection != null) {
                returnList.add(new AbstractMap.SimpleEntry<Collection, Long>(collection, (Long)o[1]));
                continue;
            }
            log.warn("Unable to find Collection with UUID: {}", o[0]);
        }
        return returnList;
    }
}

