/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics.content;

import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.apache.solr.client.solrj.SolrServerException;
import org.dspace.core.Context;
import org.dspace.statistics.Dataset;
import org.dspace.statistics.content.DatasetGenerator;
import org.dspace.statistics.content.filter.StatisticsFilter;
import org.dspace.statistics.factory.StatisticsServiceFactory;
import org.dspace.statistics.service.SolrLoggerService;

public abstract class StatisticsData {
    private Dataset dataset;
    private List<DatasetGenerator> datasetgenerators;
    private List<StatisticsFilter> filters;
    protected final SolrLoggerService solrLoggerService;

    protected StatisticsData() {
        this.datasetgenerators = new ArrayList<DatasetGenerator>(2);
        this.filters = new ArrayList<StatisticsFilter>();
        this.solrLoggerService = StatisticsServiceFactory.getInstance().getSolrLoggerService();
    }

    protected StatisticsData(Dataset dataset) {
        this.dataset = dataset;
        this.datasetgenerators = new ArrayList<DatasetGenerator>(2);
        this.filters = new ArrayList<StatisticsFilter>();
        this.solrLoggerService = StatisticsServiceFactory.getInstance().getSolrLoggerService();
    }

    public void addDatasetGenerator(DatasetGenerator set) {
        this.datasetgenerators.add(set);
    }

    public void addFilters(StatisticsFilter filter) {
        this.filters.add(filter);
    }

    public List<DatasetGenerator> getDatasetGenerators() {
        return this.datasetgenerators;
    }

    public List<StatisticsFilter> getFilters() {
        return this.filters;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    public abstract Dataset createDataset(Context var1, int var2) throws SQLException, SolrServerException, IOException, ParseException;
}

