/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.harvest;

import java.sql.SQLException;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.harvest.HarvestedItem;
import org.dspace.harvest.dao.HarvestedItemDAO;
import org.dspace.harvest.service.HarvestedItemService;
import org.springframework.beans.factory.annotation.Autowired;

public class HarvestedItemServiceImpl
implements HarvestedItemService {
    @Autowired(required=true)
    protected HarvestedItemDAO harvestedItemDAO;

    protected HarvestedItemServiceImpl() {
    }

    @Override
    public HarvestedItem find(Context context, Item item) throws SQLException {
        return this.harvestedItemDAO.findByItem(context, item);
    }

    @Override
    public Item getItemByOAIId(Context context, String itemOaiID, Collection collection) throws SQLException {
        HarvestedItem harvestedItem = this.harvestedItemDAO.findByOAIId(context, itemOaiID, collection);
        if (harvestedItem != null) {
            return harvestedItem.getItem();
        }
        return null;
    }

    @Override
    public HarvestedItem create(Context context, Item item, String itemOAIid) throws SQLException {
        HarvestedItem harvestedItem = this.harvestedItemDAO.create(context, new HarvestedItem());
        harvestedItem.setItem(item);
        harvestedItem.setOaiId(itemOAIid);
        this.update(context, harvestedItem);
        return harvestedItem;
    }

    @Override
    public void update(Context context, HarvestedItem harvestedItem) throws SQLException {
        this.harvestedItemDAO.save(context, harvestedItem);
    }

    @Override
    public void delete(Context context, HarvestedItem harvestedItem) throws SQLException {
        this.harvestedItemDAO.delete(context, harvestedItem);
    }
}

