/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.curate;

import java.io.IOException;
import org.dspace.curate.Reporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogReporter
implements Reporter {
    private static final Logger LOG = LoggerFactory.getLogger((String)"curation");
    private final StringBuilder buffer = new StringBuilder();

    @Override
    public Appendable append(CharSequence cs) throws IOException {
        for (int pos = 0; pos < cs.length(); ++pos) {
            char c = cs.charAt(pos);
            if (c == '\n') {
                LOG.info(this.buffer.toString());
                this.buffer.delete(0, this.buffer.length());
                continue;
            }
            this.buffer.append(c);
        }
        return this;
    }

    @Override
    public Appendable append(CharSequence cs, int i, int i1) throws IOException {
        return this.append(cs.subSequence(i, i1));
    }

    @Override
    public Appendable append(char c) throws IOException {
        return this.append(String.valueOf(c));
    }

    @Override
    public void close() throws Exception {
        if (this.buffer.length() > 0) {
            LOG.info(this.buffer.toString());
        }
    }
}

