/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.mail.MessagingException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.util.Util;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.I18nUtil;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.GroupService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.xmlworkflow.Role;
import org.dspace.xmlworkflow.WorkflowConfigurationException;
import org.dspace.xmlworkflow.factory.XmlWorkflowFactory;
import org.dspace.xmlworkflow.factory.XmlWorkflowServiceFactory;
import org.dspace.xmlworkflow.state.Workflow;
import org.dspace.xmlworkflow.storedcomponents.CollectionRole;
import org.dspace.xmlworkflow.storedcomponents.service.CollectionRoleService;

public class WorkflowUtils
extends Util {
    public static Logger log = LogManager.getLogger(WorkflowUtils.class);
    protected static final CollectionRoleService collectionRoleService = XmlWorkflowServiceFactory.getInstance().getCollectionRoleService();
    protected static final GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
    protected static final XmlWorkflowFactory xmlWorkflowFactory = XmlWorkflowServiceFactory.getInstance().getWorkflowFactory();
    protected static final ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();

    private WorkflowUtils() {
    }

    public static String getRequestLogInfo(HttpServletRequest request) {
        String report = "-- URL Was: " + WorkflowUtils.getOriginalURL(request) + "\n";
        report = report + "-- Method: " + request.getMethod() + "\n";
        report = report + "-- Parameters were:\n";
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (name.equals("login_password")) {
                report = report + "-- " + name + ": *not logged*\n";
                continue;
            }
            report = report + "-- " + name + ": \"" + request.getParameter(name) + "\"\n";
        }
        return report;
    }

    public static String getOriginalURL(HttpServletRequest request) {
        WorkflowUtils.storeOriginalURL(request);
        return (String)request.getAttribute("dspace.original.url");
    }

    public static void storeOriginalURL(HttpServletRequest request) {
        String orig = (String)request.getAttribute("dspace.original.url");
        if (orig == null) {
            Object fullURL = request.getRequestURL().toString();
            if (request.getQueryString() != null) {
                fullURL = (String)fullURL + "?" + request.getQueryString();
            }
            request.setAttribute("dspace.original.url", fullURL);
        }
    }

    public static void sendAlert(HttpServletRequest request, Exception exception) {
        String logInfo = WorkflowUtils.getRequestLogInfo(request);
        Context c = (Context)request.getAttribute("dspace.context");
        try {
            String recipient = configurationService.getProperty("alert.recipient");
            if (StringUtils.isNotBlank((CharSequence)recipient)) {
                String stackTrace;
                Email email = Email.getEmail(I18nUtil.getEmailFilename(c.getCurrentLocale(), "internal_error"));
                email.addRecipient(recipient);
                email.addArgument(configurationService.getProperty("dspace.ui.url"));
                email.addArgument(new Date());
                email.addArgument(request.getSession().getId());
                email.addArgument(logInfo);
                if (exception != null) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    exception.printStackTrace(pw);
                    pw.flush();
                    stackTrace = sw.toString();
                } else {
                    stackTrace = "No exception";
                }
                email.addArgument(stackTrace);
                email.send();
            }
        }
        catch (IOException | MessagingException e) {
            log.warn("Unable to send email alert", e);
        }
    }

    public static void createCollectionWorkflowRole(Context context, Collection collection, String roleId, Group group) throws AuthorizeException, SQLException {
        CollectionRole ass = collectionRoleService.create(context, collection, roleId, group);
        collectionRoleService.update(context, ass);
    }

    public static void deleteRoleGroup(Context context, Collection collection, String roleID) throws SQLException, IOException, WorkflowConfigurationException {
        Workflow workflow = xmlWorkflowFactory.getWorkflow(collection);
        Role role = workflow.getRoles().get(roleID);
        if (role.getScope() == Role.Scope.COLLECTION) {
            CollectionRole ass = collectionRoleService.find(context, collection, roleID);
            collectionRoleService.delete(context, ass);
        }
    }

    public static Map<String, Role> getCollectionRoles(Collection thisCollection) throws IOException, WorkflowConfigurationException, SQLException {
        Workflow workflow = xmlWorkflowFactory.getWorkflow(thisCollection);
        LinkedHashMap<String, Role> result = new LinkedHashMap<String, Role>();
        if (workflow != null) {
            Map<String, Role> allRoles = workflow.getRoles();
            for (String roleId : allRoles.keySet()) {
                Role role = allRoles.get(roleId);
                if (role.getScope() != Role.Scope.COLLECTION || role.isInternal()) continue;
                result.put(roleId, role);
            }
        }
        return result;
    }

    public static Map<String, Role> getCollectionAndRepositoryRoles(Collection thisCollection) throws IOException, WorkflowConfigurationException, SQLException {
        Workflow workflow = xmlWorkflowFactory.getWorkflow(thisCollection);
        LinkedHashMap<String, Role> result = new LinkedHashMap<String, Role>();
        if (workflow != null) {
            Map<String, Role> allRoles = workflow.getRoles();
            for (String roleId : allRoles.keySet()) {
                Role role = allRoles.get(roleId);
                if (role.getScope() != Role.Scope.COLLECTION && role.getScope() != Role.Scope.REPOSITORY || role.isInternal()) continue;
                result.put(roleId, role);
            }
        }
        return result;
    }

    public static Map<String, Role> getAllExternalRoles(Collection thisCollection) throws IOException, WorkflowConfigurationException, SQLException {
        Workflow workflow = xmlWorkflowFactory.getWorkflow(thisCollection);
        LinkedHashMap<String, Role> result = new LinkedHashMap<String, Role>();
        if (workflow != null) {
            Map<String, Role> allRoles = workflow.getRoles();
            for (String roleId : allRoles.keySet()) {
                Role role = allRoles.get(roleId);
                if (role.isInternal()) continue;
                result.put(roleId, role);
            }
        }
        return result;
    }

    public static Group getRoleGroup(Context context, Collection collection, Role role) throws SQLException {
        if (role.getScope() == Role.Scope.REPOSITORY) {
            return groupService.findByName(context, role.getName());
        }
        if (role.getScope() == Role.Scope.COLLECTION) {
            CollectionRole collectionRole = collectionRoleService.find(context, collection, role.getId());
            if (collectionRole == null) {
                return null;
            }
            return collectionRole.getGroup();
        }
        if (role.getScope() == Role.Scope.ITEM) {
            // empty if block
        }
        return null;
    }
}

