/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.inject.Inject;
import org.dspace.servicemanager.DSpaceKernelInit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiFormatDateParser {
    private static final Logger log = LoggerFactory.getLogger(MultiFormatDateParser.class);
    private static final ArrayList<Rule> rules = new ArrayList();
    private static final TimeZone UTC_ZONE = TimeZone.getTimeZone("UTC");
    private static final ThreadLocal<DateFormat> formatter = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            DateFormat dateTimeInstance = SimpleDateFormat.getDateTimeInstance();
            dateTimeInstance.setTimeZone(UTC_ZONE);
            return dateTimeInstance;
        }
    };

    @Inject
    public void setPatterns(Map<String, String> patterns) {
        for (Map.Entry<String, String> rule : patterns.entrySet()) {
            SimpleDateFormat format;
            Pattern pattern;
            try {
                pattern = Pattern.compile(rule.getKey(), 2);
            }
            catch (PatternSyntaxException ex) {
                log.error("Skipping format with unparseable pattern '{}'", (Object)rule.getKey());
                continue;
            }
            try {
                format = new SimpleDateFormat(rule.getValue());
            }
            catch (IllegalArgumentException ex) {
                log.error("Skipping uninterpretable date format '{}'", (Object)rule.getValue());
                continue;
            }
            format.setCalendar(Calendar.getInstance(UTC_ZONE));
            format.setLenient(false);
            rules.add(new Rule(pattern, format));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parse(String dateString) {
        for (Rule candidate : rules) {
            Date result;
            if (!candidate.pattern.matcher(dateString).matches()) continue;
            try {
                SimpleDateFormat simpleDateFormat = candidate.format;
                synchronized (simpleDateFormat) {
                    result = candidate.format.parse(dateString);
                }
            }
            catch (ParseException ex) {
                log.info("Date string '{}' matched pattern '{}' but did not parse:  {}", (Object[])new String[]{dateString, candidate.format.toPattern(), ex.getMessage()});
                continue;
            }
            return result;
        }
        return null;
    }

    public static void main(String[] args) throws IOException {
        DSpaceKernelInit.getKernel(null);
        if (args.length > 0) {
            for (String arg : args) {
                MultiFormatDateParser.testDate(arg);
            }
        } else if (null == System.console()) {
            String line;
            BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
            while (null != (line = input.readLine())) {
                MultiFormatDateParser.testDate(line.trim());
            }
        } else {
            String arg;
            while (null != (arg = System.console().readLine("Enter a date-time:  ", new Object[0]))) {
                MultiFormatDateParser.testDate(arg);
            }
        }
    }

    private static void testDate(String arg) {
        Date result = MultiFormatDateParser.parse(arg);
        if (null == result) {
            System.out.println("Did not match any pattern.");
        } else {
            System.out.println(formatter.get().format(result));
        }
    }

    private static class Rule {
        final Pattern pattern;
        final SimpleDateFormat format;

        public Rule(Pattern pattern, SimpleDateFormat format) {
            this.pattern = pattern;
            this.format = format;
        }
    }
}

