/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.service.impl;

import com.google.common.net.InetAddresses;
import java.net.Inet4Address;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.dspace.core.Utils;
import org.dspace.service.ClientInfoService;
import org.dspace.services.ConfigurationService;
import org.dspace.statistics.util.IPTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ClientInfoServiceImpl
implements ClientInfoService {
    private static final String X_FORWARDED_FOR_HEADER = "X-Forwarded-For";
    private static final Logger log = LoggerFactory.getLogger(ClientInfoServiceImpl.class);
    private Boolean useProxiesEnabled;
    private ConfigurationService configurationService;
    private IPTable trustedProxies;

    @Autowired(required=true)
    public ClientInfoServiceImpl(ConfigurationService configurationService) {
        this.configurationService = configurationService;
        this.trustedProxies = this.parseTrustedProxyRanges();
    }

    @Override
    public String getClientIp(HttpServletRequest request) {
        return this.getClientIp(request.getRemoteAddr(), request.getHeader(X_FORWARDED_FOR_HEADER));
    }

    @Override
    public String getClientIp(String remoteIp, String xForwardedForHeaderValue) {
        int ipAnonymizationBytes;
        String ip = remoteIp;
        if (this.isUseProxiesEnabled()) {
            String xForwardedForIp = this.getXForwardedForIpValue(remoteIp, xForwardedForHeaderValue);
            if (StringUtils.isNotBlank((CharSequence)xForwardedForIp) && this.isRequestFromTrustedProxy(ip)) {
                ip = xForwardedForIp;
            }
        } else if (StringUtils.isNotBlank((CharSequence)xForwardedForHeaderValue)) {
            log.warn("X-Forwarded-For header sent from client, but useProxies is not enabled. To trust X-Forwarded-For headers, set useProxies=true.");
        }
        if (this.isIPv4Address(ip) && (ipAnonymizationBytes = this.getIpAnonymizationBytes()) > 0) {
            ip = this.anonymizeIpAddress(ip, ipAnonymizationBytes);
        }
        return ip;
    }

    @Override
    public boolean isUseProxiesEnabled() {
        if (this.useProxiesEnabled == null) {
            this.useProxiesEnabled = this.configurationService.getBooleanProperty("useProxies", true);
            log.info("Proxies (useProxies) enabled? " + this.useProxiesEnabled);
        }
        return this.useProxiesEnabled;
    }

    private IPTable parseTrustedProxyRanges() {
        String uiUrl;
        Object[] uiIpAddresses;
        String localhostIP = "127.0.0.1";
        IPTable ipTable = new IPTable();
        Object[] trustedIpRanges = this.configurationService.getArrayProperty("proxies.trusted.ipranges");
        if (!ArrayUtils.contains((Object[])trustedIpRanges, (Object)localhostIP)) {
            trustedIpRanges = (String[])ArrayUtils.add((Object[])trustedIpRanges, (Object)localhostIP);
        }
        try {
            for (Object object : trustedIpRanges) {
                ipTable.add((String)object);
            }
        }
        catch (IPTable.IPFormatException e) {
            log.error("Property 'proxies.trusted.ipranges' contains an invalid IP range", (Throwable)e);
        }
        boolean uiIsTrustedProxy = this.configurationService.getBooleanProperty("proxies.trusted.include_ui_ip", true);
        if (uiIsTrustedProxy && ArrayUtils.isNotEmpty((Object[])(uiIpAddresses = Utils.getIPAddresses(uiUrl = this.configurationService.getProperty("dspace.ui.url"))))) {
            try {
                for (Object ipRange : uiIpAddresses) {
                    ipTable.add((String)ipRange);
                }
            }
            catch (IPTable.IPFormatException iPFormatException) {
                log.error("IP address lookup for dspace.ui.url={} was invalid and could not be added to trusted proxies", (Object)uiUrl, (Object)iPFormatException);
            }
        }
        if (!ipTable.isEmpty()) {
            log.info("Trusted proxies (configure via 'proxies.trusted.ipranges'): {}", (Object)ipTable);
            return ipTable;
        }
        return null;
    }

    @Override
    public boolean isRequestFromTrustedProxy(String ipAddress) {
        try {
            return this.trustedProxies != null && this.trustedProxies.contains(ipAddress);
        }
        catch (IPTable.IPFormatException e) {
            log.error("Request contains invalid remote address", (Throwable)e);
            return false;
        }
    }

    private String getXForwardedForIpValue(String remoteIp, String xForwardedForValue) {
        String ip = null;
        String headerValue = StringUtils.trimToEmpty((String)xForwardedForValue);
        for (String xfip : headerValue.split(",")) {
            if (StringUtils.equals((CharSequence)remoteIp, (CharSequence)(xfip = xfip.trim())) || !StringUtils.isNotBlank((CharSequence)xfip) || this.isRequestFromTrustedProxy(xfip)) continue;
            ip = xfip;
        }
        return ip;
    }

    private String anonymizeIpAddress(String ipAddress, int bytes) {
        if (bytes > 4) {
            log.warn("It is not possible to anonymize " + bytes + " bytes of an IPv4 address.");
            return ipAddress;
        }
        if (bytes == 4) {
            return "0.0.0.0";
        }
        String zeroSuffix = StringUtils.repeat((String)".0", (int)bytes);
        return this.removeLastBytes(ipAddress, bytes) + zeroSuffix;
    }

    private String removeLastBytes(String ipAddress, int bytes) {
        return ipAddress.substring(0, StringUtils.ordinalIndexOf((CharSequence)ipAddress, (CharSequence)".", (int)(4 - bytes)));
    }

    private int getIpAnonymizationBytes() {
        return this.configurationService.getIntProperty("client.ip-anonymization.parts", 0);
    }

    private boolean isIPv4Address(String ipAddress) {
        return InetAddresses.forString((String)ipAddress) instanceof Inet4Address;
    }
}

