/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.external.provider.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.dspace.content.Item;
import org.dspace.content.MetadataFieldName;
import org.dspace.content.dto.MetadataValueDTO;
import org.dspace.core.Context;
import org.dspace.external.model.ExternalDataObject;
import org.dspace.external.provider.AbstractExternalDataProvider;
import org.dspace.importer.external.datamodel.ImportRecord;
import org.dspace.importer.external.metadatamapping.MetadatumDTO;
import org.dspace.importer.external.service.ImportService;
import org.dspace.orcid.OrcidToken;
import org.dspace.orcid.client.OrcidClient;
import org.dspace.orcid.client.OrcidConfiguration;
import org.dspace.orcid.model.OrcidTokenResponseDTO;
import org.dspace.orcid.model.OrcidWorkFieldMapping;
import org.dspace.orcid.service.OrcidSynchronizationService;
import org.dspace.orcid.service.OrcidTokenService;
import org.dspace.web.ContextUtil;
import org.orcid.jaxb.model.common.CitationType;
import org.orcid.jaxb.model.common.ContributorRole;
import org.orcid.jaxb.model.common.WorkType;
import org.orcid.jaxb.model.v3.release.common.Contributor;
import org.orcid.jaxb.model.v3.release.common.ContributorAttributes;
import org.orcid.jaxb.model.v3.release.common.PublicationDate;
import org.orcid.jaxb.model.v3.release.common.Subtitle;
import org.orcid.jaxb.model.v3.release.common.Title;
import org.orcid.jaxb.model.v3.release.record.Citation;
import org.orcid.jaxb.model.v3.release.record.ExternalIDs;
import org.orcid.jaxb.model.v3.release.record.SourceAware;
import org.orcid.jaxb.model.v3.release.record.Work;
import org.orcid.jaxb.model.v3.release.record.WorkBulk;
import org.orcid.jaxb.model.v3.release.record.WorkContributors;
import org.orcid.jaxb.model.v3.release.record.WorkTitle;
import org.orcid.jaxb.model.v3.release.record.summary.WorkGroup;
import org.orcid.jaxb.model.v3.release.record.summary.WorkSummary;
import org.orcid.jaxb.model.v3.release.record.summary.Works;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class OrcidPublicationDataProvider
extends AbstractExternalDataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrcidPublicationDataProvider.class);
    private static final Pattern ORCID_ID_PATTERN = Pattern.compile("(\\d{4}-){3}\\d{3}(\\d|X)");
    private static final int MAX_PUT_CODES_SIZE = 100;
    @Autowired
    private OrcidClient orcidClient;
    @Autowired
    private OrcidConfiguration orcidConfiguration;
    @Autowired
    private OrcidSynchronizationService orcidSynchronizationService;
    @Autowired
    private ImportService importService;
    @Autowired
    private OrcidTokenService orcidTokenService;
    private OrcidWorkFieldMapping fieldMapping;
    private String sourceIdentifier;
    private String readPublicAccessToken;

    @Override
    public Optional<ExternalDataObject> getExternalDataObject(String id) {
        if (this.isInvalidIdentifier(id)) {
            throw new IllegalArgumentException("Invalid identifier '" + id + "', expected <orcid-id>::<put-code>");
        }
        String[] idSections = id.split("::");
        String orcid = idSections[0];
        String putCode = idSections[1];
        this.validateOrcidId(orcid);
        return this.getWork(orcid, putCode).filter(work -> this.hasDifferentSourceClientId((SourceAware)work)).filter(work -> work.getPutCode() != null).map(work -> this.convertToExternalDataObject(orcid, (Work)work));
    }

    @Override
    public List<ExternalDataObject> searchExternalDataObjects(String orcid, int start, int limit) {
        this.validateOrcidId(orcid);
        return this.findWorks(orcid, start, limit).stream().map(work -> this.convertToExternalDataObject(orcid, (Work)work)).collect(Collectors.toList());
    }

    private boolean isInvalidIdentifier(String id) {
        return StringUtils.isBlank((CharSequence)id) || id.split("::").length != 2;
    }

    private void validateOrcidId(String orcid) {
        if (!ORCID_ID_PATTERN.matcher(orcid).matches()) {
            throw new IllegalArgumentException("The given ORCID ID is not valid: " + orcid);
        }
    }

    private List<Work> findWorks(String orcid, int start, int limit) {
        List<WorkSummary> workSummaries = this.findWorkSummaries(orcid, start, limit);
        return this.findWorks(orcid, workSummaries);
    }

    private List<WorkSummary> findWorkSummaries(String orcid, int start, int limit) {
        return this.getWorks(orcid).getWorkGroup().stream().filter(workGroup -> this.allWorkSummariesHaveDifferentSourceClientId((WorkGroup)workGroup)).map(workGroup -> this.getPreferredWorkSummary((WorkGroup)workGroup)).flatMap(Optional::stream).skip(start).limit(limit > 0 ? (long)limit : Long.MAX_VALUE).collect(Collectors.toList());
    }

    private List<Work> findWorks(String orcid, List<WorkSummary> workSummaries) {
        List<String> workPutCodes = this.getPutCodes(workSummaries);
        if (CollectionUtils.isEmpty(workPutCodes)) {
            return Collections.emptyList();
        }
        if (workPutCodes.size() == 1) {
            return this.getWork(orcid, workPutCodes.get(0)).stream().collect(Collectors.toList());
        }
        return ListUtils.partition(workPutCodes, (int)100).stream().map(putCodes -> this.getWorkBulk(orcid, (List<String>)putCodes)).flatMap(workBulk -> this.getWorks((WorkBulk)workBulk).stream()).collect(Collectors.toList());
    }

    private Optional<Work> getWork(String orcid, String putCode) {
        if (this.orcidConfiguration.isApiConfigured()) {
            String accessToken = this.getAccessToken(orcid);
            return this.orcidClient.getObject(accessToken, orcid, putCode, Work.class);
        }
        return this.orcidClient.getObject(orcid, putCode, Work.class);
    }

    private Works getWorks(String orcid) {
        if (this.orcidConfiguration.isApiConfigured()) {
            String accessToken = this.getAccessToken(orcid);
            return this.orcidClient.getWorks(accessToken, orcid);
        }
        return this.orcidClient.getWorks(orcid);
    }

    private WorkBulk getWorkBulk(String orcid, List<String> putCodes) {
        if (this.orcidConfiguration.isApiConfigured()) {
            String accessToken = this.getAccessToken(orcid);
            return this.orcidClient.getWorkBulk(accessToken, orcid, putCodes);
        }
        return this.orcidClient.getWorkBulk(orcid, putCodes);
    }

    private String getAccessToken(String orcid) {
        List<Item> items = this.orcidSynchronizationService.findProfilesByOrcid(new Context(), orcid);
        return Optional.ofNullable(items.isEmpty() ? null : items.get(0)).flatMap(item -> this.getAccessToken((Item)item)).orElseGet(() -> this.getReadPublicAccessToken());
    }

    private Optional<String> getAccessToken(Item item) {
        return Optional.ofNullable(this.orcidTokenService.findByProfileItem(this.getContext(), item)).map(OrcidToken::getAccessToken);
    }

    private String getReadPublicAccessToken() {
        if (this.readPublicAccessToken != null) {
            return this.readPublicAccessToken;
        }
        OrcidTokenResponseDTO accessTokenResponse = this.orcidClient.getReadPublicAccessToken();
        this.readPublicAccessToken = accessTokenResponse.getAccessToken();
        return this.readPublicAccessToken;
    }

    private List<Work> getWorks(WorkBulk workBulk) {
        return workBulk.getBulk().stream().filter(bulkElement -> bulkElement instanceof Work).map(bulkElement -> (Work)bulkElement).collect(Collectors.toList());
    }

    private List<String> getPutCodes(List<WorkSummary> workSummaries) {
        return workSummaries.stream().map(WorkSummary::getPutCode).map(String::valueOf).collect(Collectors.toList());
    }

    private Optional<WorkSummary> getPreferredWorkSummary(WorkGroup workGroup) {
        return workGroup.getWorkSummary().stream().filter(work -> work.getPutCode() != null).filter(work -> NumberUtils.isCreatable((String)work.getDisplayIndex())).sorted(Comparator.comparing(work -> Integer.valueOf(work.getDisplayIndex()), Comparator.reverseOrder())).findFirst();
    }

    private ExternalDataObject convertToExternalDataObject(String orcid, Work work) {
        ExternalDataObject externalDataObject = new ExternalDataObject(this.sourceIdentifier);
        externalDataObject.setId(orcid + "::" + work.getPutCode().toString());
        String title = this.getWorkTitle(work);
        externalDataObject.setDisplayValue(title);
        externalDataObject.setValue(title);
        this.addMetadataValue(externalDataObject, this.fieldMapping.getTitleField(), () -> title);
        this.addMetadataValue(externalDataObject, this.fieldMapping.getTypeField(), () -> this.getWorkType(work));
        this.addMetadataValue(externalDataObject, this.fieldMapping.getPublicationDateField(), () -> this.getPublicationDate(work));
        this.addMetadataValue(externalDataObject, this.fieldMapping.getJournalTitleField(), () -> this.getJournalTitle(work));
        this.addMetadataValue(externalDataObject, this.fieldMapping.getSubTitleField(), () -> this.getSubTitleField(work));
        this.addMetadataValue(externalDataObject, this.fieldMapping.getShortDescriptionField(), () -> this.getDescription(work));
        this.addMetadataValue(externalDataObject, this.fieldMapping.getLanguageField(), () -> this.getLanguage(work));
        for (String contributorField : this.fieldMapping.getContributorFields().keySet()) {
            ContributorRole role = this.fieldMapping.getContributorFields().get(contributorField);
            this.addMetadataValues(externalDataObject, contributorField, () -> this.getContributors(work, role));
        }
        for (String externalIdField : this.fieldMapping.getExternalIdentifierFields().keySet()) {
            String type = this.fieldMapping.getExternalIdentifierFields().get(externalIdField);
            this.addMetadataValues(externalDataObject, externalIdField, () -> this.getExternalIds(work, type));
        }
        try {
            this.addMetadataValuesFromCitation(externalDataObject, work.getWorkCitation());
        }
        catch (Exception e) {
            LOGGER.error("An error occurs reading the following citation: " + work.getWorkCitation().getCitation(), (Throwable)e);
        }
        return externalDataObject;
    }

    private boolean allWorkSummariesHaveDifferentSourceClientId(WorkGroup workGroup) {
        return workGroup.getWorkSummary().stream().allMatch(this::hasDifferentSourceClientId);
    }

    private boolean hasDifferentSourceClientId(SourceAware sourceAware) {
        return Optional.ofNullable(sourceAware.getSource()).map(source -> source.getSourceClientId()).map(sourceClientId -> sourceClientId.getPath()).map(clientId -> !StringUtils.equals((CharSequence)this.orcidConfiguration.getClientId(), (CharSequence)clientId)).orElse(true);
    }

    private void addMetadataValues(ExternalDataObject externalData, String metadata, Supplier<List<String>> values) {
        if (StringUtils.isBlank((CharSequence)metadata)) {
            return;
        }
        MetadataFieldName field = new MetadataFieldName(metadata);
        for (String value : values.get()) {
            externalData.addMetadata(new MetadataValueDTO(field.schema, field.element, field.qualifier, null, value));
        }
    }

    private void addMetadataValue(ExternalDataObject externalData, String metadata, Supplier<String> valueSupplier) {
        this.addMetadataValues(externalData, metadata, () -> {
            String value = (String)valueSupplier.get();
            return StringUtils.isNotBlank((CharSequence)value) ? List.of(value) : Collections.emptyList();
        });
    }

    private String getWorkTitle(Work work) {
        WorkTitle workTitle = work.getWorkTitle();
        if (workTitle == null) {
            return null;
        }
        Title title = workTitle.getTitle();
        return title != null ? title.getContent() : null;
    }

    private String getWorkType(Work work) {
        WorkType workType = work.getWorkType();
        return workType != null ? this.fieldMapping.convertType(workType.value()) : null;
    }

    private String getPublicationDate(Work work) {
        PublicationDate publicationDate = work.getPublicationDate();
        if (publicationDate == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder(publicationDate.getYear().getValue());
        if (publicationDate.getMonth() != null) {
            builder.append("-");
            builder.append(publicationDate.getMonth().getValue());
        }
        if (publicationDate.getDay() != null) {
            builder.append("-");
            builder.append(publicationDate.getDay().getValue());
        }
        return builder.toString();
    }

    private String getJournalTitle(Work work) {
        Title journalTitle = work.getJournalTitle();
        return journalTitle != null ? journalTitle.getContent() : null;
    }

    private String getSubTitleField(Work work) {
        WorkTitle workTitle = work.getWorkTitle();
        if (workTitle == null) {
            return null;
        }
        Subtitle subTitle = workTitle.getSubtitle();
        return subTitle != null ? subTitle.getContent() : null;
    }

    private String getDescription(Work work) {
        return work.getShortDescription();
    }

    private String getLanguage(Work work) {
        return work.getLanguageCode() != null ? this.fieldMapping.convertLanguage(work.getLanguageCode()) : null;
    }

    private List<String> getContributors(Work work, ContributorRole role) {
        WorkContributors workContributors = work.getWorkContributors();
        if (workContributors == null) {
            return Collections.emptyList();
        }
        return workContributors.getContributor().stream().filter(contributor -> this.hasRole((Contributor)contributor, role)).map(contributor -> this.getContributorName((Contributor)contributor)).flatMap(Optional::stream).collect(Collectors.toList());
    }

    private void addMetadataValuesFromCitation(ExternalDataObject externalDataObject, Citation citation) throws Exception {
        if (citation == null || citation.getWorkCitationType() == CitationType.FORMATTED_UNSPECIFIED) {
            return;
        }
        this.getImportRecord(citation).ifPresent(importRecord -> this.enrichExternalDataObject(externalDataObject, (ImportRecord)importRecord));
    }

    private Optional<ImportRecord> getImportRecord(Citation citation) throws Exception {
        File citationFile = File.createTempFile("temp", "." + citation.getWorkCitationType().value());
        try {
            Optional<ImportRecord> optional;
            try (FileOutputStream outputStream = new FileOutputStream(citationFile);){
                IOUtils.write((String)citation.getCitation(), (OutputStream)new FileOutputStream(citationFile), (Charset)Charset.defaultCharset());
                optional = Optional.ofNullable(this.importService.getRecord(citationFile, citationFile.getName()));
            }
            return optional;
        }
        finally {
            citationFile.delete();
        }
    }

    private void enrichExternalDataObject(ExternalDataObject externalDataObject, ImportRecord importRecord) {
        importRecord.getValueList().stream().filter(metadata -> this.doesNotContains(externalDataObject, (MetadatumDTO)metadata)).forEach(metadata -> this.addMetadata(externalDataObject, (MetadatumDTO)metadata));
    }

    private void addMetadata(ExternalDataObject externalDataObject, MetadatumDTO metadata) {
        externalDataObject.addMetadata(new MetadataValueDTO(metadata.getSchema(), metadata.getElement(), metadata.getQualifier(), null, metadata.getValue()));
    }

    private boolean doesNotContains(ExternalDataObject externalDataObject, MetadatumDTO metadata) {
        return externalDataObject.getMetadata().stream().filter(metadataValue -> StringUtils.equals((CharSequence)metadataValue.getSchema(), (CharSequence)metadata.getSchema())).filter(metadataValue -> StringUtils.equals((CharSequence)metadataValue.getElement(), (CharSequence)metadata.getElement())).filter(metadataValue -> StringUtils.equals((CharSequence)metadataValue.getQualifier(), (CharSequence)metadata.getQualifier())).findAny().isEmpty();
    }

    private boolean hasRole(Contributor contributor, ContributorRole role) {
        ContributorAttributes attributes = contributor.getContributorAttributes();
        return attributes != null ? role.equals((Object)attributes.getContributorRole()) : false;
    }

    private Optional<String> getContributorName(Contributor contributor) {
        return Optional.ofNullable(contributor.getCreditName()).map(creditName -> creditName.getContent());
    }

    private List<String> getExternalIds(Work work, String type) {
        ExternalIDs externalIdentifiers = work.getExternalIdentifiers();
        if (externalIdentifiers == null) {
            return Collections.emptyList();
        }
        return externalIdentifiers.getExternalIdentifier().stream().filter(externalId -> type.equals(externalId.getType())).map(externalId -> externalId.getValue()).collect(Collectors.toList());
    }

    private Context getContext() {
        Context context = ContextUtil.obtainCurrentRequestContext();
        return context != null ? context : new Context();
    }

    @Override
    public boolean supports(String source) {
        return StringUtils.equals((CharSequence)this.sourceIdentifier, (CharSequence)source);
    }

    @Override
    public int getNumberOfResults(String orcid) {
        return this.findWorkSummaries(orcid, 0, -1).size();
    }

    public void setSourceIdentifier(String sourceIdentifier) {
        this.sourceIdentifier = sourceIdentifier;
    }

    @Override
    public String getSourceIdentifier() {
        return this.sourceIdentifier;
    }

    public void setFieldMapping(OrcidWorkFieldMapping fieldMapping) {
        this.fieldMapping = fieldMapping;
    }

    public void setReadPublicAccessToken(String readPublicAccessToken) {
        this.readPublicAccessToken = readPublicAccessToken;
    }

    public OrcidClient getOrcidClient() {
        return this.orcidClient;
    }

    public void setOrcidClient(OrcidClient orcidClient) {
        this.orcidClient = orcidClient;
    }
}

