/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.ctask.general;

import java.io.IOException;
import java.sql.SQLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.logic.Filter;
import org.dspace.content.logic.FilterUtils;
import org.dspace.content.logic.TrueFilter;
import org.dspace.curate.AbstractCurationTask;
import org.dspace.curate.Curator;
import org.dspace.identifier.DOIIdentifierProvider;
import org.dspace.identifier.IdentifierException;
import org.dspace.identifier.doi.DOIIdentifierNotApplicableException;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.utils.DSpace;

public class RegisterDOI
extends AbstractCurationTask {
    private int status = 0;
    private boolean skipFilter = true;
    private boolean distributed = false;
    private static final String PLUGIN_PREFIX = "doi-curation";
    private static final Logger log = LogManager.getLogger(RegisterDOI.class);
    private DOIIdentifierProvider provider;
    private Filter trueFilter;

    @Override
    public void init(Curator curator, String taskId) throws IOException {
        super.init(curator, taskId);
        this.distributed = this.configurationService.getBooleanProperty("doi-curation.distributed", false);
        log.debug("PLUGIN_PREFIX = doi-curation, skipFilter = " + this.skipFilter + ", distributed = " + this.distributed);
        this.provider = (DOIIdentifierProvider)new DSpace().getSingletonService(DOIIdentifierProvider.class);
        this.trueFilter = (Filter)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName("always_true_filter", TrueFilter.class);
    }

    @Override
    public int perform(DSpaceObject dso) throws IOException {
        if (!this.distributed) {
            if (dso instanceof Item) {
                Item item = (Item)dso;
                this.performRegistration(item);
            } else {
                log.warn("DOI registration attempted on non-item DSpace Object: " + dso.getID());
            }
            return this.status;
        }
        this.distribute(dso);
        return this.status;
    }

    @Override
    protected void performItem(Item item) {
        this.performRegistration(item);
    }

    private void performRegistration(Item item) {
        String doi = this.register(item);
        String result = "DOI registration task performed on " + item.getHandle() + ".";
        result = doi != null ? result + " DOI: (" + doi + ")" : result + " DOI was null, either item was filtered or an error was encountered.";
        this.setResult(result);
        this.report(result);
    }

    private String register(Item item) {
        String doi = null;
        try {
            Filter filter = FilterUtils.getFilterFromConfiguration("identifiers.submission.filter.curation", this.trueFilter);
            doi = this.provider.register(Curator.curationContext(), (DSpaceObject)item, filter);
            if (doi != null) {
                String message = "New DOI minted in database for item " + item.getHandle() + ": " + doi + ". This DOI will be registered online with the DOI provider when the queue is next run";
                this.report(message);
            } else {
                log.error("Got a null DOI after registering...");
            }
        }
        catch (SQLException e) {
            log.error("Error obtaining curator context: " + e.getMessage());
            this.status = -1;
        }
        catch (DOIIdentifierNotApplicableException e) {
            log.info("Item was filtered from DOI registration: " + e.getMessage());
            String message = "Item " + item.getHandle() + " was skipped from DOI registration because it matched the item filter configured in identifier-services.xml.";
            this.report(message);
            this.status = 0;
        }
        catch (IdentifierException e) {
            log.error("Error registering identifier: " + e.getMessage());
            this.status = -1;
        }
        return doi;
    }
}

