/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.checker;

import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.dspace.checker.ChecksumHistory;
import org.dspace.checker.ChecksumResult;
import org.dspace.checker.ChecksumResultCode;
import org.dspace.checker.MostRecentChecksum;
import org.dspace.checker.dao.ChecksumHistoryDAO;
import org.dspace.checker.service.ChecksumHistoryService;
import org.dspace.checker.service.ChecksumResultService;
import org.dspace.checker.service.MostRecentChecksumService;
import org.dspace.content.Bitstream;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;

public class ChecksumHistoryServiceImpl
implements ChecksumHistoryService {
    @Autowired(required=true)
    protected ChecksumHistoryDAO checksumHistoryDAO;
    @Autowired(required=true)
    protected MostRecentChecksumService mostRecentChecksumService;
    @Autowired(required=true)
    protected ChecksumResultService checksumResultService;

    protected ChecksumHistoryServiceImpl() {
    }

    @Override
    public void updateMissingBitstreams(Context context) throws SQLException {
        List<MostRecentChecksum> mostRecentChecksums = this.mostRecentChecksumService.findNotInHistory(context);
        for (MostRecentChecksum mostRecentChecksum : mostRecentChecksums) {
            this.addHistory(context, mostRecentChecksum);
        }
    }

    @Override
    public void addHistory(Context context, MostRecentChecksum mostRecentChecksum) throws SQLException {
        ChecksumHistory checksumHistory = new ChecksumHistory();
        checksumHistory.setBitstream(mostRecentChecksum.getBitstream());
        checksumHistory.setProcessStartDate(mostRecentChecksum.getProcessStartDate());
        checksumHistory.setProcessEndDate(mostRecentChecksum.getProcessEndDate());
        checksumHistory.setChecksumExpected(mostRecentChecksum.getExpectedChecksum());
        checksumHistory.setChecksumCalculated(mostRecentChecksum.getCurrentChecksum());
        ChecksumResult checksumResult = mostRecentChecksum.getBitstream().isDeleted() ? this.checksumResultService.findByCode(context, ChecksumResultCode.BITSTREAM_MARKED_DELETED) : this.checksumResultService.findByCode(context, mostRecentChecksum.getChecksumResult().getResultCode());
        checksumHistory.setResult(checksumResult);
        this.checksumHistoryDAO.create(context, checksumHistory);
        this.checksumHistoryDAO.save(context, checksumHistory);
    }

    @Override
    public int deleteByDateAndCode(Context context, Date retentionDate, ChecksumResultCode checksumResultCode) throws SQLException {
        return this.checksumHistoryDAO.deleteByDateAndCode(context, retentionDate, checksumResultCode);
    }

    @Override
    public void deleteByBitstream(Context context, Bitstream bitstream) throws SQLException {
        this.mostRecentChecksumService.deleteByBitstream(context, bitstream);
        this.checksumHistoryDAO.deleteByBitstream(context, bitstream);
    }

    @Override
    public int prune(Context context, Map<ChecksumResultCode, Long> interests) throws SQLException {
        long now = System.currentTimeMillis();
        int count = 0;
        for (Map.Entry<ChecksumResultCode, Long> interest : interests.entrySet()) {
            count += this.deleteByDateAndCode(context, new Date(now - interest.getValue()), interest.getKey());
        }
        return count;
    }
}

